/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.service;

import io.vpv.saml.metadata.model.IDPMetaData;
import io.vpv.saml.metadata.model.SPMetaData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Objects;

public interface MetaDataParser {
    public SPMetaData parseSPMetadata(InputStream var1);

    public IDPMetaData parseIDPMetaData(InputStream var1);

    default public SPMetaData parseSPMetadata(File xmlFile) throws FileNotFoundException {
        if (Objects.nonNull(xmlFile) && xmlFile.exists()) {
            return this.parseSPMetadata(new FileInputStream(xmlFile));
        }
        throw new FileNotFoundException("Unable to parse file :" + xmlFile);
    }

    default public IDPMetaData parseIDPMetaData(File xmlFile) throws FileNotFoundException {
        if (Objects.nonNull(xmlFile) && xmlFile.exists()) {
            return this.parseIDPMetaData(new FileInputStream(xmlFile));
        }
        throw new FileNotFoundException("Unable to parse file :" + xmlFile);
    }

    default public SPMetaData parseSPMetadata(String fileName) throws FileNotFoundException {
        if (Objects.nonNull(fileName)) {
            return this.parseSPMetadata(new File(fileName));
        }
        throw new FileNotFoundException("Unable to parse null filename");
    }

    default public IDPMetaData parseIDPMetaData(String fileName) throws FileNotFoundException {
        if (Objects.nonNull(fileName)) {
            return this.parseIDPMetaData(new File(fileName));
        }
        throw new FileNotFoundException("Unable to parse null filename");
    }

    default public SPMetaData parseSPMetadata(URL xmlUrl) throws IOException {
        if (Objects.nonNull(xmlUrl)) {
            return this.parseSPMetadata(xmlUrl.openStream());
        }
        throw new IOException("Unable to parse as the URL provided was null");
    }

    default public IDPMetaData parseIDPMetaData(URL xmlUrl) throws IOException {
        if (Objects.nonNull(xmlUrl)) {
            return this.parseIDPMetaData(xmlUrl.openStream());
        }
        throw new IOException("Unable to parse as the URL provided was null");
    }
}

