/*
 * Decompiled with CFR 0.152.
 */
package io.vpv.saml.metadata.model;

import io.vpv.saml.metadata.model.KeyInfo;
import io.vpv.saml.metadata.model.SignedInfo;

public class Signature {
    public SignedInfo signedInfo;
    public String signatureValue;
    public KeyInfo keyInfo;

    Signature(SignedInfo signedInfo, String signatureValue, KeyInfo keyInfo) {
        this.signedInfo = signedInfo;
        this.signatureValue = signatureValue;
        this.keyInfo = keyInfo;
    }

    public static SignatureBuilder builder() {
        return new SignatureBuilder();
    }

    public void setSignedInfo(SignedInfo signedInfo) {
        this.signedInfo = signedInfo;
    }

    public void setSignatureValue(String signatureValue) {
        this.signatureValue = signatureValue;
    }

    public void setKeyInfo(KeyInfo keyInfo) {
        this.keyInfo = keyInfo;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public String getSignatureValue() {
        return this.signatureValue;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public String toString() {
        return "Signature(signedInfo=" + this.getSignedInfo() + ", signatureValue=" + this.getSignatureValue() + ", keyInfo=" + this.getKeyInfo() + ")";
    }

    public static class SignatureBuilder {
        private SignedInfo signedInfo;
        private String signatureValue;
        private KeyInfo keyInfo;

        SignatureBuilder() {
        }

        public SignatureBuilder signedInfo(SignedInfo signedInfo) {
            this.signedInfo = signedInfo;
            return this;
        }

        public SignatureBuilder signatureValue(String signatureValue) {
            this.signatureValue = signatureValue;
            return this;
        }

        public SignatureBuilder keyInfo(KeyInfo keyInfo) {
            this.keyInfo = keyInfo;
            return this;
        }

        public Signature build() {
            return new Signature(this.signedInfo, this.signatureValue, this.keyInfo);
        }

        public String toString() {
            return "Signature.SignatureBuilder(signedInfo=" + this.signedInfo + ", signatureValue=" + this.signatureValue + ", keyInfo=" + this.keyInfo + ")";
        }
    }
}

