/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.errors;

import com.google.api.gax.rpc.UnauthenticatedException;
import io.vortex.spring.boot.base.errors.EmptyResultError;
import io.vortex.spring.boot.base.errors.ErrorDetails;
import io.vortex.spring.boot.base.errors.VortexAuthException;
import io.vortex.spring.boot.base.errors.VortexHandler;
import io.vortex.spring.boot.base.errors.VortexInvalidValueException;
import io.vortex.spring.boot.base.errors.VortexMethodError;
import io.vortex.spring.boot.base.errors.VortexNotFoundException;
import io.vortex.spring.boot.base.errors.VortexUserAlreadyRegisteredException;
import io.vortex.spring.boot.base.response.VortexError;
import io.vortex.spring.boot.base.response.VortexErrorResponse;
import javax.servlet.http.HttpServletRequest;
import kotlin.KotlinNullPointerException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.MethodNotSupportedException;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.web.firewall.RequestRejectedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.server.MethodNotAllowedException;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0017J\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0017J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\u000fj\u0002`\u0010H\u0017J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0012H\u0017J\"\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u00060\u000fj\u0002`\u0010H\u0017\u00a8\u0006\u0014"}, d2={"Lio/vortex/spring/boot/base/errors/VortexExceptionHandler;", "Lio/vortex/spring/boot/base/errors/VortexHandler;", "Lio/vortex/spring/boot/base/response/VortexErrorResponse;", "()V", "handleAuthRegistered", "Lorg/springframework/http/ResponseEntity;", "request", "Ljavax/servlet/http/HttpServletRequest;", "exception", "Lio/vortex/spring/boot/base/errors/VortexAuthException;", "handleInvalidValueException", "Lio/vortex/spring/boot/base/errors/VortexInvalidValueException;", "handleNotFoundException", "Lio/vortex/spring/boot/base/errors/VortexNotFoundException;", "handleNullExceptionException", "Ljava/lang/Exception;", "Lkotlin/Exception;", "handleUserAlreadyRegistered", "Lio/vortex/spring/boot/base/errors/VortexUserAlreadyRegisteredException;", "handleWrongMethodException", "Vortex-SpringBoot"})
public abstract class VortexExceptionHandler
implements VortexHandler<VortexErrorResponse> {
    @Override
    @ExceptionHandler(value={VortexNotFoundException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleNotFoundException(@NotNull HttpServletRequest request, @NotNull VortexNotFoundException exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.NOT_FOUND.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        ErrorDetails errorDetails = exception.getDetails();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("Not Found", errorDetails, stackTraceElementArray);
        String string3 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string3, 4, null), HttpStatus.NOT_FOUND);
    }

    @Override
    @ExceptionHandler(value={VortexInvalidValueException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleInvalidValueException(@NotNull HttpServletRequest request, @NotNull VortexInvalidValueException exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.BAD_REQUEST.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        ErrorDetails errorDetails = exception.getDetails();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("Invalid Or Missing Value", errorDetails, stackTraceElementArray);
        String string3 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string3, 4, null), HttpStatus.BAD_REQUEST);
    }

    @Override
    @ExceptionHandler(value={MethodNotAllowedException.class, NoSuchMethodException.class, MethodNotSupportedException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleWrongMethodException(@NotNull HttpServletRequest request, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.METHOD_NOT_ALLOWED.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        String string3 = request.getMethod();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"request.method");
        ErrorDetails errorDetails = new VortexMethodError(string3, "This Method Not Supported At This Request");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("Invalid Or Missing Value", errorDetails, stackTraceElementArray);
        String string4 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string4, 4, null), HttpStatus.METHOD_NOT_ALLOWED);
    }

    @Override
    @ExceptionHandler(value={NullPointerException.class, KotlinNullPointerException.class, InstantiationException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleNullExceptionException(@NotNull HttpServletRequest request, @NotNull Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.NOT_FOUND.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        ErrorDetails errorDetails = new EmptyResultError("No Content At This Request");
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("Empty Result", errorDetails, stackTraceElementArray);
        String string3 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string3, 4, null), HttpStatus.NOT_FOUND);
    }

    @Override
    @ExceptionHandler(value={VortexAuthException.class, UnauthenticatedException.class, RequestRejectedException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleAuthRegistered(@NotNull HttpServletRequest request, @NotNull VortexAuthException exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.UNAUTHORIZED.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        ErrorDetails errorDetails = exception.getDetails();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("UnAuthorized Error", errorDetails, stackTraceElementArray);
        String string3 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string3, 4, null), HttpStatus.UNAUTHORIZED);
    }

    @Override
    @ExceptionHandler(value={VortexUserAlreadyRegisteredException.class})
    @NotNull
    public ResponseEntity<VortexErrorResponse> handleUserAlreadyRegistered(@NotNull HttpServletRequest request, @NotNull VortexUserAlreadyRegisteredException exception) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        int n = HttpStatus.BAD_REQUEST.value();
        String string = exception.getMessage();
        String string2 = request.getPathInfo();
        ErrorDetails errorDetails = exception.getDetails();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"exception.stackTrace");
        VortexError vortexError = new VortexError("Duplicate User", errorDetails, stackTraceElementArray);
        String string3 = string2;
        return new ResponseEntity((Object)new VortexErrorResponse(n, string, null, vortexError, string3, 4, null), HttpStatus.BAD_REQUEST);
    }
}

