/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.controller;

import io.vortex.spring.boot.base.controller.VortexMysqlControllerImpl;
import io.vortex.spring.boot.base.errors.VortexInvalidValueException;
import io.vortex.spring.boot.base.errors.details.BodyErrorDetails;
import io.vortex.spring.boot.base.models.database.VortexBaseEntity;
import io.vortex.spring.boot.base.models.database.VortexMysqlEntity;
import io.vortex.spring.boot.base.response.VortexListResponse;
import io.vortex.spring.boot.base.response.VortexResponse;
import io.vortex.spring.boot.base.response.VortexSuccessResponse;
import io.vortex.spring.boot.base.service.VortexMysqlService;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Component
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0017\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\u0004\b\u0001\u0010\u0003*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0005*\u001a\b\u0003\u0010\u0006*\u0014\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00040\u00072\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u0004\u0012\u0004\u0012\u0002H\u00060\bB\u000f\b\u0007\u0012\u0006\u0010\t\u001a\u00028\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017J\u001f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0017\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0017J\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0017\u00a2\u0006\u0002\u0010\u0011J\r\u0010\u0014\u001a\u00028\u0003H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\b\u0001\u0010\u0017\u001a\u0004\u0018\u00018\u0000H\u0017\u00a2\u0006\u0002\u0010\u0018R\u0010\u0010\t\u001a\u00028\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lio/vortex/spring/boot/base/controller/VortexMysqlController;", "E", "Lio/vortex/spring/boot/base/models/database/VortexMysqlEntity;", "ID", "R", "Lorg/springframework/data/jpa/repository/JpaRepository;", "S", "Lio/vortex/spring/boot/base/service/VortexMysqlService;", "Lio/vortex/spring/boot/base/controller/VortexMysqlControllerImpl;", "controller", "(Lio/vortex/spring/boot/base/service/VortexMysqlService;)V", "Lio/vortex/spring/boot/base/service/VortexMysqlService;", "deleteAll", "Lorg/springframework/http/ResponseEntity;", "Lio/vortex/spring/boot/base/response/VortexResponse;", "deleteById", "id", "(Ljava/lang/Object;)Lorg/springframework/http/ResponseEntity;", "getAll", "getById", "getService", "()Lio/vortex/spring/boot/base/service/VortexMysqlService;", "save", "content", "(Lio/vortex/spring/boot/base/models/database/VortexMysqlEntity;)Lorg/springframework/http/ResponseEntity;", "update", "Vortex-SpringBoot"})
public class VortexMysqlController<E extends VortexMysqlEntity<ID>, ID, R extends JpaRepository<E, ID>, S extends VortexMysqlService<ID, E, R>>
implements VortexMysqlControllerImpl<E, ID, R, S> {
    private final S controller;

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, value={"/"})
    @NotNull
    public ResponseEntity<VortexResponse> save(@Valid @RequestBody @Nullable E content) {
        if (content == null) {
            throw (Throwable)new VortexInvalidValueException("Body Required", new BodyErrorDetails("Body Not Attached", "Create Request"));
        }
        VortexMysqlEntity result = (VortexMysqlEntity)this.getService().create((VortexBaseEntity)content);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)new VortexSuccessResponse(HttpStatus.CREATED.value(), "Data Saved", null, result, 4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026a = result\n            ))");
        return responseEntity;
    }

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.PUT}, value={"/"})
    @NotNull
    public ResponseEntity<VortexResponse> update(@Valid @RequestBody @Nullable E content) {
        if (content == null) {
            throw (Throwable)new VortexInvalidValueException("Body Required", new BodyErrorDetails("Body Not Attached", "Update Request"));
        }
        VortexMysqlEntity result = (VortexMysqlEntity)this.getService().update((VortexBaseEntity)content);
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.ACCEPTED).body((Object)new VortexSuccessResponse(HttpStatus.ACCEPTED.value(), "Data Updated", null, result, 4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026a = result\n            ))");
        return responseEntity;
    }

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/{id}"})
    @NotNull
    public ResponseEntity<VortexResponse> deleteById(@PathVariable(value="id") @Nullable ID id) {
        if (id == null) {
            throw (Throwable)new VortexInvalidValueException("Id Required", new BodyErrorDetails("Id Attached", "Delete Request"));
        }
        boolean result = ((VortexMysqlService)this.getService()).deleteEntityById(id);
        ResponseEntity responseEntity = ResponseEntity.status((int)HttpStatus.OK.value()).body((Object)new VortexSuccessResponse(HttpStatus.OK.value(), "Data Deleted", null, result, 4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026a = result\n            ))");
        return responseEntity;
    }

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.DELETE}, value={"/all"})
    @NotNull
    public ResponseEntity<VortexResponse> deleteAll() {
        ((VortexMysqlService)this.getService()).deleteAllEntities();
        Object var1_1 = null;
        String string = "Data Deleted";
        String string2 = "Success";
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)new VortexSuccessResponse(HttpStatus.NOT_FOUND.value(), string, string2, var1_1));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026   data = null\n        ))");
        return responseEntity;
    }

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/{id}"})
    @NotNull
    public ResponseEntity<VortexResponse> getById(@PathVariable(value="id") @Nullable ID id) {
        if (id == null) {
            throw (Throwable)new VortexInvalidValueException("Id Required", new BodyErrorDetails("Id Attached", "Get By Id Request"));
        }
        VortexBaseEntity result = ((VortexMysqlService)this.getService()).getEntityById((Object)id);
        ResponseEntity responseEntity = ResponseEntity.status((int)HttpStatus.OK.value()).body((Object)new VortexSuccessResponse(HttpStatus.OK.value(), "Data Found", null, result, 4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026a = result\n            ))");
        return responseEntity;
    }

    @Override
    @ResponseBody
    @RequestMapping(method={RequestMethod.GET}, value={"/"})
    @NotNull
    public ResponseEntity<VortexResponse> getAll() {
        ArrayList result = ((VortexMysqlService)this.getService()).getAllEntities();
        int n = result.size();
        String string = "Success";
        String string2 = "Data Found";
        List list = result;
        ResponseEntity responseEntity = ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)new VortexListResponse(HttpStatus.OK.value(), string2, string, list, n));
        Intrinsics.checkExpressionValueIsNotNull((Object)responseEntity, (String)"ResponseEntity.status(Ht\u2026 = result.size\n        ))");
        return responseEntity;
    }

    @Override
    @NotNull
    public S getService() {
        return this.controller;
    }

    @Autowired
    public VortexMysqlController(@NotNull S controller) {
        Intrinsics.checkParameterIsNotNull(controller, (String)"controller");
        this.controller = controller;
    }
}

