/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.config.security;

import io.vortex.spring.boot.base.config.security.VortexTokenProvider;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.filter.GenericFilterBean;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/vortex/spring/boot/base/config/security/VortexJwtTokenFilter;", "Lorg/springframework/web/filter/GenericFilterBean;", "provider", "Lio/vortex/spring/boot/base/config/security/VortexTokenProvider;", "(Lio/vortex/spring/boot/base/config/security/VortexTokenProvider;)V", "doFilter", "", "request", "Ljavax/servlet/ServletRequest;", "response", "Ljavax/servlet/ServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "Vortex-SpringBoot"})
public class VortexJwtTokenFilter
extends GenericFilterBean {
    private final VortexTokenProvider<?> provider;

    public void doFilter(@Nullable ServletRequest request, @Nullable ServletResponse response, @Nullable FilterChain chain) {
        block2: {
            ServletRequest servletRequest = request;
            if (servletRequest == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.servlet.http.HttpServletRequest");
            }
            String token = this.provider.resolveToken((HttpServletRequest)servletRequest);
            if (token != null && this.provider.validateToken(token)) {
                Authentication auth = this.provider.getAuthentication(token);
                SecurityContext securityContext = SecurityContextHolder.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)securityContext, (String)"SecurityContextHolder.getContext()");
                securityContext.setAuthentication(auth);
            }
            FilterChain filterChain = chain;
            if (filterChain == null) break block2;
            filterChain.doFilter(request, response);
        }
    }

    public VortexJwtTokenFilter(@NotNull VortexTokenProvider<?> provider) {
        Intrinsics.checkParameterIsNotNull(provider, (String)"provider");
        this.provider = provider;
    }
}

