/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.config;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import io.vortex.spring.boot.base.config.impl.FirebaseConfig;
import io.vortex.spring.boot.base.errors.VortexFirebaseException;
import io.vortex.spring.boot.base.errors.details.FirebaseErrorDetails;
import io.vortex.spring.boot.base.models.PathFirebaseConfiguration;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0017J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lio/vortex/spring/boot/base/config/VortexFirebasePathConfiguration;", "Lio/vortex/spring/boot/base/config/impl/FirebaseConfig;", "Lio/vortex/spring/boot/base/models/PathFirebaseConfiguration;", "()V", "configFirebase", "Lcom/google/firebase/FirebaseApp;", "params", "validateParams", "", "Vortex-SpringBoot"})
public abstract class VortexFirebasePathConfiguration
implements FirebaseConfig<PathFirebaseConfiguration> {
    @Override
    public void validateParams(@NotNull PathFirebaseConfiguration params2) {
        Intrinsics.checkParameterIsNotNull((Object)params2, (String)"params");
        CharSequence charSequence = params2.getFilePath();
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw (Throwable)new VortexFirebaseException("Firebase : The File Path Missing ... Empty Path", new FirebaseErrorDetails("The File Path Missing ... Empty Path", CollectionsKt.arrayListOf((Object[])new String[]{"Path"})));
        }
        File file = new File(params2.getFilePath());
        if (!file.exists()) {
            throw (Throwable)new VortexFirebaseException("Firebase Configuration : File Not Exist At Path : " + params2, new FirebaseErrorDetails("Firebase Configuration : File Not Exist At Path : " + params2, CollectionsKt.arrayListOf((Object[])new String[]{"Path"})));
        }
    }

    @Override
    @Bean
    @NotNull
    public FirebaseApp configFirebase(@NotNull PathFirebaseConfiguration params2) {
        Intrinsics.checkParameterIsNotNull((Object)params2, (String)"params");
        FileInputStream serviceAccount = new FileInputStream(params2.getFilePath());
        FirebaseOptions options = new FirebaseOptions.Builder().setCredentials(GoogleCredentials.fromStream((InputStream)serviceAccount)).setDatabaseUrl(params2.getDatabaseLink()).build();
        FirebaseApp firebaseApp = FirebaseApp.initializeApp((FirebaseOptions)options);
        Intrinsics.checkExpressionValueIsNotNull((Object)firebaseApp, (String)"FirebaseApp.initializeApp(options)");
        return firebaseApp;
    }
}

