/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.config;

import io.vortex.spring.boot.base.config.VortexResponseLogger;
import io.vortex.spring.boot.base.config.impl.VortexApplicationStarterImpl;
import io.vortex.spring.boot.base.models.VortexApplicationInfo;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.env.Environment;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/vortex/spring/boot/base/config/VortexApplicationStarter;", "Lio/vortex/spring/boot/base/config/impl/VortexApplicationStarterImpl;", "environment", "Lorg/springframework/core/env/Environment;", "(Lorg/springframework/core/env/Environment;)V", "build", "", "isExecutePageEnabled", "", "executePage", "url", "", "getApplicationDetails", "Lio/vortex/spring/boot/base/models/VortexApplicationInfo;", "getBaseUrl", "getSwaggerLink", "details", "registerVortexRestTemplate", "Vortex-SpringBoot"})
public final class VortexApplicationStarter
implements VortexApplicationStarterImpl {
    private final Environment environment;

    @Override
    public void registerVortexRestTemplate() {
        BufferingClientHttpRequestFactory factory = new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)new SimpleClientHttpRequestFactory());
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        List<VortexResponseLogger> list = Collections.singletonList(new VortexResponseLogger());
        if (list == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<org.springframework.http.client.ClientHttpRequestInterceptor>");
        }
        restTemplate.setInterceptors(list);
    }

    @Override
    @NotNull
    public String getBaseUrl(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return "http://" + this.getApplicationDetails(environment).getAddress() + ':' + this.getApplicationDetails(environment).getPort();
    }

    @Override
    @NotNull
    public String getSwaggerLink(@NotNull VortexApplicationInfo details) {
        Intrinsics.checkParameterIsNotNull((Object)details, (String)"details");
        return this.getBaseUrl(this.environment) + "/swagger-ui.html";
    }

    @Override
    @NotNull
    public VortexApplicationInfo getApplicationDetails(@NotNull Environment environment) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        String string = environment.getProperty("server.address", "localhost");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"environment.getProperty(\u2026er.address\", \"localhost\")");
        String string2 = environment.getProperty("spring.application.name", "Vortex Application");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"environment.getProperty(\u2026e\", \"Vortex Application\")");
        String string3 = environment.getProperty("server.port", "8090");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"environment.getProperty(\"server.port\", \"8090\")");
        String string4 = string3;
        String string5 = string2;
        String string6 = string;
        boolean bl = false;
        int n2 = n = Integer.parseInt(string4);
        String string7 = string5;
        String string8 = string6;
        int n3 = n2;
        String string9 = string8;
        String string10 = string7;
        return new VortexApplicationInfo(string10, string9, n3);
    }

    @Override
    public void executePage(@NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Runtime rt = Runtime.getRuntime();
        rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
    }

    @Override
    public void build(boolean isExecutePageEnabled) {
        VortexApplicationInfo details = this.getApplicationDetails(this.environment);
        String string = StringsKt.trimIndent((String)("\n            =========================================================================================================\n            Vortex Application Started ....\n            Application Name : " + details.getName() + "\n            Application Base Url : " + this.getBaseUrl(this.environment) + "\n            Application Address : " + details.getAddress() + "\n            Application Port : " + details.getPort() + "\n            Swagger Link : " + this.getSwaggerLink(details) + "\n            =========================================================================================================\n        "));
        boolean bl = false;
        System.out.println((Object)string);
    }

    public VortexApplicationStarter(@NotNull Environment environment) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        this.environment = environment;
    }
}

