/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.service;

import io.vortex.spring.boot.base.errors.EmptyErrorDetails;
import io.vortex.spring.boot.base.errors.VortexInternalServerException;
import io.vortex.spring.boot.base.errors.VortexNotFoundException;
import io.vortex.spring.boot.base.models.database.VortexMysqlEntity;
import io.vortex.spring.boot.base.service.VortexMysqlServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.transaction.Transactional;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Service;

@Service
@Transactional
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u0003*\u0014\b\u0002\u0010\u0004*\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00010\u00052\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\u0015\u0010\u0013\u001a\u00028\u00012\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/vortex/spring/boot/base/service/VortexMysqlService;", "ID", "Entity", "Lio/vortex/spring/boot/base/models/database/VortexMysqlEntity;", "Repo", "Lorg/springframework/data/jpa/repository/JpaRepository;", "Lio/vortex/spring/boot/base/service/VortexMysqlServiceImpl;", "()V", "checkRepoStatus", "", "repo", "(Lorg/springframework/data/jpa/repository/JpaRepository;)Z", "deleteAllEntities", "", "deleteEntityById", "id", "(Ljava/lang/Object;)Z", "getAllEntities", "Ljava/util/ArrayList;", "getEntityById", "(Ljava/lang/Object;)Lio/vortex/spring/boot/base/models/database/VortexMysqlEntity;", "Vortex-SpringBoot"})
public abstract class VortexMysqlService<ID, Entity extends VortexMysqlEntity, Repo extends JpaRepository<Entity, ID>>
implements VortexMysqlServiceImpl<ID, Entity, Repo> {
    @Override
    @NotNull
    public ArrayList<Entity> getAllEntities() throws VortexNotFoundException {
        try {
            List list;
            if (this.checkRepoStatus((Repo)((JpaRepository)this.getRepository()))) {
                list = ((JpaRepository)this.getRepository()).findAll();
                if (list == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.ArrayList<Entity>");
                }
            } else {
                throw (Throwable)new VortexNotFoundException("Data Not Found", new EmptyErrorDetails(null, "No Data Available For This Section"));
            }
            return (ArrayList)list;
        }
        catch (EmptyResultDataAccessException ex) {
            throw (Throwable)new VortexNotFoundException("Data Not Found", new EmptyErrorDetails(null, ex.getMessage()));
        }
    }

    @Override
    @NotNull
    public Entity getEntityById(ID id) throws VortexNotFoundException {
        try {
            if (!this.checkRepoStatus((Repo)((JpaRepository)this.getRepository()))) {
                throw (Throwable)new VortexNotFoundException("Data Not Found", new EmptyErrorDetails(id, "No Data Available For This Section"));
            }
            Object t = ((JpaRepository)this.getRepository()).findById(id).get();
            Intrinsics.checkExpressionValueIsNotNull(t, (String)"getRepository().findById(id).get()");
            return (Entity)((VortexMysqlEntity)t);
        }
        catch (NoSuchElementException ex) {
            throw (Throwable)new VortexNotFoundException(ex.getMessage(), new EmptyErrorDetails(id, ex.getMessage()));
        }
    }

    @Override
    public boolean checkRepoStatus(@NotNull Repo repo) {
        Intrinsics.checkParameterIsNotNull(repo, (String)"repo");
        return ((JpaRepository)this.getRepository()).count() > 0L;
    }

    @Override
    public void deleteAllEntities() {
        ((JpaRepository)this.getRepository()).deleteAll();
    }

    @Override
    public boolean deleteEntityById(ID id) throws VortexNotFoundException {
        boolean bl;
        if (this.checkRepoStatus((Repo)((JpaRepository)this.getRepository()))) {
            ((JpaRepository)this.getRepository()).deleteById(id);
            try {
                this.getEntityById((Object)id);
                throw (Throwable)new VortexInternalServerException("Data Not Deleted", new VortexInternalServerException.DataNotDeletedDetails(id, "Data Not Deleted For This ID ... Still in Database"));
            }
            catch (NoSuchElementException ex) {
                bl = true;
            }
        } else {
            throw (Throwable)new VortexNotFoundException("Data Not Found", new EmptyErrorDetails(id, "No Data To Delete At This Section"));
        }
        return bl;
    }
}

