/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.config.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.vortex.spring.boot.base.errors.VortexAuthException;
import io.vortex.spring.boot.base.models.TokenErrorDetails;
import io.vortex.spring.boot.base.models.TokenInformation;
import io.vortex.spring.boot.base.models.VortexTokenDetails;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u000fH$J\r\u0010\u0010\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/vortex/spring/boot/base/config/security/VortexTokenProvider;", "US", "Lorg/springframework/security/core/userdetails/UserDetailsService;", "", "()V", "secreteKey", "", "createToken", "details", "Ljava/util/ArrayList;", "Lio/vortex/spring/boot/base/models/TokenInformation;", "getAuthentication", "Lorg/springframework/security/core/Authentication;", "token", "getTokenDetails", "Lio/vortex/spring/boot/base/models/VortexTokenDetails;", "getUserService", "()Lorg/springframework/security/core/userdetails/UserDetailsService;", "getUsername", "resolveToken", "req", "Ljavax/servlet/http/HttpServletRequest;", "validateToken", "", "Vortex-SpringBoot"})
public abstract class VortexTokenProvider<US extends UserDetailsService> {
    private String secreteKey;

    @NotNull
    public final String createToken(@NotNull ArrayList<TokenInformation> details) {
        Intrinsics.checkParameterIsNotNull(details, (String)"details");
        Claims claims = Jwts.claims().setSubject(details.get(0).getValue());
        Iterable $this$forEach$iv = details;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TokenInformation it = (TokenInformation)element$iv;
            boolean bl = false;
            Claims claims2 = claims;
            Intrinsics.checkExpressionValueIsNotNull((Object)claims2, (String)"claims");
            ((Map)claims2).put(it.getKey(), it.getValue());
        }
        Date now = new Date();
        Date validity = new Date(now.getTime() + this.getTokenDetails().getValidityInMilliseconds());
        String string = Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(validity).signWith(SignatureAlgorithm.HS256, this.secreteKey).compact();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Jwts.builder()\n         \u2026               .compact()");
        return string;
    }

    @NotNull
    public final Authentication getAuthentication(@NotNull String token) {
        UserDetails userDetails;
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        UserDetails userDetails2 = userDetails = this.getUserService().loadUserByUsername(this.getUsername(token));
        Intrinsics.checkExpressionValueIsNotNull((Object)userDetails2, (String)"userDetails");
        return (Authentication)new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"", userDetails2.getAuthorities());
    }

    private final String getUsername(String token) {
        Jws jws = Jwts.parser().setSigningKey(this.secreteKey).parseClaimsJws(token);
        Intrinsics.checkExpressionValueIsNotNull((Object)jws, (String)"Jwts.parser().setSigning\u2026ey).parseClaimsJws(token)");
        Object object = jws.getBody();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"Jwts.parser().setSigning\u2026arseClaimsJws(token).body");
        String string = ((Claims)object).getSubject();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"Jwts.parser().setSigning\u2026msJws(token).body.subject");
        return string;
    }

    @Nullable
    public final String resolveToken(@NotNull HttpServletRequest req) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)req, (String)"req");
        String bearerToken = req.getHeader("Authorization");
        if (bearerToken != null && StringsKt.startsWith$default((String)bearerToken, (String)"Bearer ", (boolean)false, (int)2, null)) {
            String string2 = bearerToken;
            int n = 7;
            int n2 = bearerToken.length();
            boolean bl = false;
            String string3 = string2.substring(n, n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string = null;
        }
        return string;
    }

    public final boolean validateToken(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        try {
            CharSequence charSequence = token;
            boolean bl = false;
            if (charSequence.length() > 0) {
                Jws claims;
                Jws jws = claims = Jwts.parser().setSigningKey(this.secreteKey).parseClaimsJws(token);
                Intrinsics.checkExpressionValueIsNotNull((Object)jws, (String)"claims");
                Object object = jws.getBody();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"claims.body");
                return !((Claims)object).getExpiration().before(new Date());
            }
            throw (Throwable)new VortexAuthException("Token Missing At Header", new TokenErrorDetails("Token Missing ... Should Send Token At Header {Authorization}"));
        }
        catch (JwtException e) {
            if (!StringsKt.contains$default((CharSequence)token, (CharSequence)"Bearer", (boolean)false, (int)2, null)) {
                throw (Throwable)new VortexAuthException("Expired or invalid JWT token", new TokenErrorDetails("Token Should Be Bearer + Token ... Bearer Missing"));
            }
            throw (Throwable)new VortexAuthException("Expired or invalid JWT token", new TokenErrorDetails("Token is Invalid Or Missing"));
        }
        catch (IllegalArgumentException e) {
            throw (Throwable)new VortexAuthException(e.getMessage(), new TokenErrorDetails("Token is Invalid Or Expired"));
        }
    }

    @NotNull
    protected abstract US getUserService();

    @NotNull
    protected abstract VortexTokenDetails getTokenDetails();

    public VortexTokenProvider() {
        String string = this.getTokenDetails().getSecreteKey();
        Base64.Encoder encoder = Base64.getEncoder();
        VortexTokenProvider vortexTokenProvider = this;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String string3 = encoder.encodeToString(byArray2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.getEncoder().enco\u2026secreteKey.toByteArray())");
        vortexTokenProvider.secreteKey = string3;
    }
}

