/*
 * Decompiled with CFR 0.152.
 */
package io.vortex.spring.boot.base.config;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.StreamUtils;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\u0000H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/vortex/spring/boot/base/config/VortexResponseLogger;", "Lorg/springframework/http/client/ClientHttpRequestInterceptor;", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "intercept", "Lorg/springframework/http/client/ClientHttpResponse;", "request", "Lorg/springframework/http/HttpRequest;", "body", "", "execution", "Lorg/springframework/http/client/ClientHttpRequestExecution;", "logRequest", "", "logResponse", "response", "loggingInterceptor", "Vortex-SpringBoot"})
public final class VortexResponseLogger
implements ClientHttpRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @NotNull
    public ClientHttpResponse intercept(@NotNull HttpRequest request, @NotNull byte[] body, @NotNull ClientHttpRequestExecution execution) {
        ClientHttpResponse response;
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Intrinsics.checkParameterIsNotNull((Object)execution, (String)"execution");
        this.logRequest(request, body);
        ClientHttpResponse clientHttpResponse = response = execution.execute(request, body);
        Intrinsics.checkExpressionValueIsNotNull((Object)clientHttpResponse, (String)"response");
        this.logResponse(clientHttpResponse);
        return response;
    }

    public final void logRequest(@NotNull HttpRequest request, @NotNull byte[] body) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)body, (String)"body");
        Logger logger = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            Object object;
            this.log.debug("===========================request begin================================================");
            this.log.debug("URI         : {}", (Object)request.getURI());
            this.log.debug("Method      : {}", (Object)request.getMethod());
            this.log.debug("Headers     : {}", (Object)request.getHeaders());
            Object object2 = "UTF-8";
            String string = "Request body: {}";
            Logger logger2 = this.log;
            boolean bl = false;
            Charset charset = Charset.forName((String)object2);
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(charsetName)");
            object2 = object = charset;
            bl = false;
            object = new String(body, (Charset)object2);
            logger2.debug(string, object);
            this.log.debug("==========================request end================================================");
        }
    }

    public final void logResponse(@NotNull ClientHttpResponse response) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Logger logger = this.log;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"log");
        if (logger.isDebugEnabled()) {
            this.log.debug("============================response begin==========================================");
            this.log.debug("Status code  : {}", (Object)response.getStatusCode());
            this.log.debug("Status text  : {}", (Object)response.getStatusText());
            this.log.debug("Headers      : {}", (Object)response.getHeaders());
            this.log.debug("Response body: {}", (Object)StreamUtils.copyToString((InputStream)response.getBody(), (Charset)Charset.defaultCharset()));
            this.log.debug("=======================response end=================================================");
        }
    }

    @Bean
    @NotNull
    public final VortexResponseLogger loggingInterceptor() {
        return new VortexResponseLogger();
    }
}

