/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.m2m;

import cats.Monad;
import cats.data.EitherT;
import cats.data.OptionT;
import cats.effect.Sync;
import cats.kernel.Eq;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.parser.package$;
import io.unsecurity.HttpProblem$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.m2m.JwtToken;
import io.unsecurity.auth.auth0.m2m.JwtToken$;
import io.unsecurity.auth.auth0.m2m.OauthAuthenticatedApplication;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import okio.ByteString;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.headers.Authorization$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%Q\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0019\u0007A!A!\u0002\u0017!\u0007\"\u00027\u0001\t\u0003i\u0007\"B;\u0001\t\u00032\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011!\t)\u0002\u0001C\u00017\u0005]\u0001bBA\u001f\u0001\u0011%\u0011q\b\u0005\b\u00037\u0002A\u0011BA/\u0011\u001d\t\u0019\b\u0001C\u0005\u00037Cq!a*\u0001\t\u0013\tI\u000bC\u0004\u00020\u0002!I!!-\t\u000f\u0005=\u0007\u0001\"\u0003\u0002R\"9\u0011Q\u0015\u0001\u0005\n\u0005}\u0007bBAy\u0001\u0011%\u00111\u001f\u0005\b\u0003w\u0004A\u0011BA\u007f\u0005]\tU\u000f\u001e51\u001bJj5+Z2ve&$\u0018pQ8oi\u0016DHO\u0003\u0002\u0017/\u0005\u0019QNM7\u000b\u0005aI\u0012!B1vi\"\u0004$B\u0001\u000e\u001c\u0003\u0011\tW\u000f\u001e5\u000b\u0005qi\u0012AC;og\u0016\u001cWO]5us*\ta$\u0001\u0002j_\u000e\u0001QcA\u0011/\u007fM!\u0001A\t\u0015B!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB)\u0011F\u000b\u0017;}5\t1$\u0003\u0002,7\ty1+Z2ve&$\u0018pQ8oi\u0016DH\u000f\u0005\u0002.]1\u0001A!B\u0018\u0001\u0005\u0004\u0001$!\u0001$\u0016\u0005EB\u0014C\u0001\u001a6!\t\u00193'\u0003\u00025I\t9aj\u001c;iS:<\u0007CA\u00127\u0013\t9DEA\u0002B]f$Q!\u000f\u0018C\u0002E\u0012\u0011a\u0018\t\u0003wqj\u0011!F\u0005\u0003{U\u0011QdT1vi\"\fU\u000f\u001e5f]RL7-\u0019;fI\u0006\u0003\b\u000f\\5dCRLwN\u001c\t\u0003[}\"Q\u0001\u0011\u0001C\u0002E\u0012\u0011!\u0016\t\u0004S\tc\u0013BA\"\u001c\u00055)fn]3dkJLG/_(qg\u00061An\\8lkB\u0004Ba\t$;\u0011&\u0011q\t\n\u0002\n\rVt7\r^5p]F\u00022!\f\u0018J!\r\u0019#JP\u0005\u0003\u0017\u0012\u0012aa\u00149uS>t\u0017AB5tgV,'\u000f\u0005\u0002O+:\u0011qj\u0015\t\u0003!\u0012j\u0011!\u0015\u0006\u0003%~\ta\u0001\u0010:p_Rt\u0014B\u0001+%\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q#\u0013\u0001C1vI&,gnY3\u0002\u0017)<8\u000e\u0015:pm&$WM\u001d\t\u00037\u0006l\u0011\u0001\u0018\u0006\u0003;z\u000b1A[<l\u0015\tArLC\u0001a\u0003\r\u0019w.\\\u0005\u0003Er\u00131BS<l!J|g/\u001b3fe\u0006\ta\tE\u0002fU2j\u0011A\u001a\u0006\u0003O\"\fa!\u001a4gK\u000e$(\"A5\u0002\t\r\fGo]\u0005\u0003W\u001a\u0014AaU=oG\u00061A(\u001b8jiz\"RA\\9sgR$\"a\u001c9\u0011\tm\u0002AF\u0010\u0005\u0006G\u001a\u0001\u001d\u0001\u001a\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006\u0019\u001a\u0001\r!\u0014\u0005\u00061\u001a\u0001\r!\u0014\u0005\u00063\u001a\u0001\rAW\u0001\rCV$\b.\u001a8uS\u000e\fG/Z\u000b\u0002oB)\u00010a\u0001-u5\t\u0011P\u0003\u0002{w\u0006QA-\u001b:fGRLg/Z:\u000b\u0005ql\u0018A\u00025uiB$4O\u0003\u0002\u007f\u007f\u0006A1oY1mC\nLgN\u0003\u0002\u0002\u0002\u0005\u0011an\\\u0005\u0004\u0003\u000bI(!\u0003#je\u0016\u001cG/\u001b<f\u0003%A8O\u001d4DQ\u0016\u001c7.\u0006\u0002\u0002\fA)\u00010a\u0001-\u001b\u0006iAO]1og\u001a|'/\\+tKJ$2\u0001SA\t\u0011\u0019\t\u0019\"\u0003a\u0001u\u00059!/Y<Vg\u0016\u0014\u0018\u0001\u0005:fcV,7\u000f^!vi\"$vn[3o)\u0019\tY!!\u0007\u0002,!9\u00111\u0004\u0006A\u0002\u0005u\u0011aD1ui\u0016l\u0007\u000f^3e\u001b\u0016$\bn\u001c3\u0011\t\u0005}\u0011qE\u0007\u0003\u0003CQ1\u0001`A\u0012\u0015\t\t)#A\u0002pe\u001eLA!!\u000b\u0002\"\t1Q*\u001a;i_\u0012Dq!!\f\u000b\u0001\u0004\ty#A\u0007biR,W\u000e\u001d;fIB\u000bG\u000f\u001b\t\u0005\u0003c\t9D\u0004\u0003\u0002 \u0005M\u0012\u0002BA\u001b\u0003C\t1!\u0016:j\u0013\u0011\tI$a\u000f\u0003\tA\u000bG\u000f\u001b\u0006\u0005\u0003k\t\t#\u0001\u0006eK\u000e|G-\u001a3K/R#\u0002\"!\u0011\u0002T\u0005U\u0013q\u000b\t\u0007q\u0006\rA&a\u0011\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005Q\u0011N\u001c;fe\u001a\f7-Z:\u000b\u0007\u00055c,A\u0002koRLA!!\u0015\u0002H\tQA)Z2pI\u0016$'j\u0016+\t\u000f\u0005m1\u00021\u0001\u0002\u001e!9\u0011QF\u0006A\u0002\u0005=\u0002BBA-\u0017\u0001\u0007Q*A\u0003u_.,g.A\bdef\u0004Ho\\!mO>\u0014\u0018\u000e\u001e5n)!\ty&!\u001c\u0002p\u0005E\u0004C\u0002=\u0002\u00041\n\t\u0007\u0005\u0003\u0002d\u0005%TBAA3\u0015\u0011\t9'a\u0013\u0002\u0015\u0005dwm\u001c:ji\"l7/\u0003\u0003\u0002l\u0005\u0015$!C!mO>\u0014\u0018\u000e\u001e5n\u0011\u001d\tY\u0002\u0004a\u0001\u0003;Aq!!\f\r\u0001\u0004\ty\u0003C\u0004\u0002t1\u0001\r!!\u001e\u0002\u0013)<H\u000fS3bI\u0016\u0014\b\u0003BA<\u0003+sA!!\u001f\u0002\u0010:!\u00111PAF\u001d\u0011\ti(!#\u000f\t\u0005}\u0014q\u0011\b\u0005\u0003\u0003\u000b)ID\u0002Q\u0003\u0007K\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012bAAG/\u0005!q.\u001b3d\u0013\u0011\t\t*a%\u0002\u0007);HOC\u0002\u0002\u000e^IA!a&\u0002\u001a\nI!j\u001e;IK\u0006$WM\u001d\u0006\u0005\u0003#\u000b\u0019\n\u0006\u0005\u0002\u001e\u0006}\u0015\u0011UAR!\u0019A\u00181\u0001\u0017\u0002v!9\u00111D\u0007A\u0002\u0005u\u0001bBA\u0017\u001b\u0001\u0007\u0011q\u0006\u0005\b\u0003Kk\u0001\u0019AA\"\u0003!Qw\u000f\u001e+pW\u0016t\u0017\u0001\u00043fG>$WMQ1tKZ\"D\u0003BA\u0006\u0003WCa!!,\u000f\u0001\u0004i\u0015!\u0002<bYV,\u0017aF2sK\u0006$X\rU;cY&\u001c7*Z=Qe>4\u0018\u000eZ3s)\u0011\t\u0019,!/\u0011\t\u0005\u0015\u0013QW\u0005\u0005\u0003o\u000b9E\u0001\bS'\u0006[U-\u001f)s_ZLG-\u001a:\t\u000f\u0005mv\u00021\u0001\u0002>\u0006I\u0001/\u001e2mS\u000e\\U-\u001f\t\u0005\u0003\u007f\u000bY-\u0004\u0002\u0002B*!\u0011\u0011JAb\u0015\u0011\t)-a2\u0002\u0011M,7-\u001e:jifT!!!3\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\f\tM\u0001\u0007S'\u0006\u0003VO\u00197jG.+\u00170A\twKJLg-_!dG\u0016\u001c8\u000fV8lK:$\"\"!\u0011\u0002T\u0006U\u0017q[An\u0011\u001d\tY\u0002\u0005a\u0001\u0003;Aq!!\f\u0011\u0001\u0004\ty\u0003C\u0004\u0002ZB\u0001\r!!\u0019\u0002\u0007\u0005dw\r\u0003\u0004\u0002^B\u0001\r!T\u0001\fC\u000e\u001cWm]:U_.,g\u000e\u0006\u0005\u0002b\u0006%\u00181^Aw!\u0019A\u00181\u0001\u0017\u0002dB\u00191(!:\n\u0007\u0005\u001dXC\u0001\u0005KoR$vn[3o\u0011\u001d\tY\"\u0005a\u0001\u0003;Aq!!\f\u0012\u0001\u0004\ty\u0003C\u0004\u0002pF\u0001\r!a\u0011\u0002\u001bY,'/\u001b4jK\u0012$vn[3o\u0003=\u0019\u0007.Z2l\u000bb\u0004\u0018N]1uS>tG\u0003CA\u0006\u0003k\f90!?\t\u000f\u0005m!\u00031\u0001\u0002\u001e!9\u0011Q\u0006\nA\u0002\u0005=\u0002bBAS%\u0001\u0007\u00111]\u0001\u000fKb$(/Y2u!J|g-\u001b7f)\u00159\u0018q B\u0001\u0011\u001d\t)k\u0005a\u0001\u0003GDaAa\u0001\u0014\u0001\u0004i\u0015\u0001\u0003:boR{7.\u001a8")
public class Auth0M2MSecurityContext<F, U>
implements SecurityContext<F, OauthAuthenticatedApplication, U>,
UnsecurityOps<F> {
    private final Function1<OauthAuthenticatedApplication, F> lookup;
    private final String issuer;
    private final String audience;
    private final JwkProvider jwkProvider;
    private final Sync<F> F;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public Directive<F, OauthAuthenticatedApplication> authenticate() {
        return Directive$.MODULE$.request(this.F).map((Function1 & Serializable)x$1 -> x$1.method()).flatMap((Function1 & Serializable)attemptedMethod -> this.request().path($this.F).flatMap((Function1 & Serializable)attemptedPath -> this.requestAuthToken((Method)attemptedMethod, (String)attemptedPath).flatMap((Function1 & Serializable)requestAuthToken -> this.decodedJWT((Method)attemptedMethod, (String)attemptedPath, (String)requestAuthToken).flatMap((Function1 & Serializable)decodedJWT -> this.jwtHeader((Method)attemptedMethod, (String)attemptedPath, (DecodedJWT)decodedJWT).flatMap((Function1 & Serializable)jwtHeader -> this.cryptoAlgorithm((Method)attemptedMethod, (String)attemptedPath, (Jwt.JwtHeader)jwtHeader).flatMap((Function1 & Serializable)alg -> this.verifyAccessToken((Method)attemptedMethod, (String)attemptedPath, (Algorithm)alg, (String)requestAuthToken).flatMap((Function1 & Serializable)verifiedToken -> this.jwtToken((Method)attemptedMethod, (String)attemptedPath, (DecodedJWT)verifiedToken).flatMap((Function1 & Serializable)jwtToken -> this.checkExpiration((Method)attemptedMethod, (String)attemptedPath, (JwtToken)jwtToken).flatMap((Function1 & Serializable)x$2 -> {
            String string = x$2;
            Directive directive = this.extractProfile((JwtToken)jwtToken, (String)requestAuthToken).map((Function1 & Serializable)userProfile -> userProfile);
            return directive;
        })))))))));
    }

    public Directive<F, String> xsrfCheck() {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> "", this.F);
    }

    public F transformUser(OauthAuthenticatedApplication rawUser) {
        return (F)this.lookup.apply((Object)rawUser);
    }

    public Directive<F, String> requestAuthToken(Method attemptedMethod, String attemptedPath) {
        return this.request().header((HeaderKey)Authorization$.MODULE$, this.F).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> header.value().split(" ")).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Auth0M2MSecurityContext.$anonfun$requestAuthToken$3(x$3))).map((Function1 & Serializable)x$4 -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])x$4))), (Monad)$this.F).toDirective(HttpProblem$.MODULE$.unauthorized(new StringBuilder(54).append("Authorization header with Bearer scheme not found [").append(attemptedMethod).append(", ").append(attemptedPath).append("]").toString(), HttpProblem$.MODULE$.unauthorized$default$2()).toDirectiveError($this.F)).map((Function1 & Serializable)token -> token));
    }

    private Directive<F, DecodedJWT> decodedJWT(Method attemptedMethod, String attemptedPath, String token) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token)), this.F).toSuccess((Function1 & Serializable)throwable -> this.Unauthorized(new StringBuilder(43).append("Could not extract token from request [").append(attemptedMethod).append(", ").append(attemptedPath).append(", ").append(throwable.getMessage()).append("]").toString(), $this.F));
    }

    private Directive<F, Algorithm> cryptoAlgorithm(Method attemptedMethod, String attemptedPath, Jwt.JwtHeader jwtHeader) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> {
            RSAPublicKey publicKey = (RSAPublicKey)$this.jwkProvider.get(jwtHeader.kid()).getPublicKey();
            return Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(publicKey));
        }), this.F).toSuccess((Function1 & Serializable)throwable -> this.Unauthorized(new StringBuilder(48).append("Could not get public key from jwt hedader [").append(attemptedMethod).append(", ").append(attemptedPath).append(", ").append(throwable.getMessage()).append("]").toString(), $this.F));
    }

    private Directive<F, Jwt.JwtHeader> jwtHeader(Method attemptedMethod, String attemptedPath, DecodedJWT jwtToken) {
        return this.decodeBase64(jwtToken.getHeader()).flatMap((Function1 & Serializable)decodedHeaderString -> this.EitherDirectives((Either)package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()), (Monad)$this.F).toDirective((Function1 & Serializable)x$5 -> this.Unauthorized(new StringBuilder(32).append("Could not decode jwt header [").append(attemptedMethod).append(", ").append(attemptedPath).append("]").toString(), $this.F)).map((Function1 & Serializable)header -> header));
    }

    private Directive<F, String> decodeBase64(String value) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> ByteString.decodeBase64((String)value).utf8(), this.F);
    }

    private RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(null, publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    private Directive<F, DecodedJWT> verifyAccessToken(Method attemptedMethod, String attemptedPath, Algorithm alg, String accessToken) {
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{this.issuer}).withAudience(new String[]{this.audience}).build();
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> verifier.verify(accessToken)), this.F).toSuccess((Function1 & Serializable)throwable -> this.Unauthorized(new StringBuilder(35).append("Could not verify token path: [").append(attemptedMethod).append(", ").append(attemptedPath).append(", ").append(throwable.getMessage()).append("]").toString(), $this.F));
    }

    private Directive<F, JwtToken> jwtToken(Method attemptedMethod, String attemptedPath, DecodedJWT verifiedToken) {
        return this.decodeBase64(verifiedToken.getPayload()).flatMap((Function1 & Serializable)base64Token -> this.EitherDirectives((Either)package$.MODULE$.decode(base64Token, JwtToken$.MODULE$.jwtTokenDecoder()), (Monad)$this.F).toDirective((Function1 & Serializable)decodeError -> this.Unauthorized(new StringBuilder(36).append("Unable to decode JWT payload: [").append(attemptedMethod).append(", ").append(attemptedPath).append(", ").append(decodeError).append("]").toString(), $this.F)).map((Function1 & Serializable)jwtToken -> jwtToken));
    }

    private Directive<F, String> checkExpiration(Method attemptedMethod, String attemptedPath, JwtToken jwtToken) {
        OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(jwtToken.exp()).atOffset(ZoneOffset.UTC));
        OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
        return now.isAfter(expirationTime) ? this.Unauthorized(new StringBuilder(83).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).append(" for [sub ").append(jwtToken.sub()).append(", iss ").append(jwtToken.iss()).append(", aud ").append(jwtToken.aud()).append(", method ").append(attemptedMethod).append(", path ").append(attemptedPath).append("]").toString(), this.F) : Directive$.MODULE$.success((Function0 & Serializable)() -> "Valid token", this.F);
    }

    private Directive<F, OauthAuthenticatedApplication> extractProfile(JwtToken jwtToken, String rawToken) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> new OauthAuthenticatedApplication(jwtToken.sub(), jwtToken.scopes(), rawToken), this.F);
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestAuthToken$3(String[] x$3) {
        return ((String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$3))).equalsIgnoreCase("bearer");
    }

    public Auth0M2MSecurityContext(Function1<OauthAuthenticatedApplication, F> lookup, String issuer, String audience, JwkProvider jwkProvider, Sync<F> F) {
        this.lookup = lookup;
        this.issuer = issuer;
        this.audience = audience;
        this.jwkProvider = jwkProvider;
        this.F = F;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
    }
}

