/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.oidc;

import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.OptionT;
import cats.effect.Resource;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.kernel.Eq;
import cats.syntax.package;
import com.auth0.client.auth.AuthAPI;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json$;
import io.circe.KeyEncoder$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import io.unsecurity.HttpProblem$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.oidc.Auth0OidcSecurityContext$Cookies$;
import io.unsecurity.auth.auth0.oidc.AuthConfig;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.auth.auth0.oidc.OidcAuthenticatedUser;
import io.unsecurity.auth.auth0.oidc.RandomProvider;
import io.unsecurity.auth.auth0.oidc.SessionStore;
import io.unsecurity.auth.auth0.oidc.State;
import io.unsecurity.auth.auth0.oidc.TokenRequest;
import io.unsecurity.auth.auth0.oidc.TokenRequest$;
import io.unsecurity.auth.auth0.oidc.TokenResponse;
import io.unsecurity.auth.auth0.oidc.TokenResponse$;
import io.unsecurity.auth.auth0.oidc.TokenVerifier$;
import io.unsecurity.auth.auth0.oidc.UserId;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPublicKey;
import java.time.OffsetDateTime;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import org.http4s.Charset$;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.headers.Content$minusType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import scodec.bits.BitVector$;

@ScalaSignature(bytes="\u0006\u0005\tuc\u0001B\u0014)\u0001MB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0011)A\u00053\"AQ\f\u0001BC\u0002\u0013\u0005a\f\u0003\u0005c\u0001\t\u0005\t\u0015!\u0003`\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011u\u0004!1!Q\u0001\fyDq!a\u0001\u0001\t\u0003\t)\u0001\u0003\u0005\u0002\u0016\u0001\u0001\u000b\u0011BA\f\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!a\u000b\u0001\t\u0003\ni\u0003C\u0004\u0002F\u0001!\t%a\u0012\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d!9\u0011q\r\u0001\u0005\u0002\u0005M\u0004bBA<\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\tY\t\u0001C\u0001\u0003\u001bCq!a*\u0001\t\u0003\tI\u000bC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005%\u0007\u0001\"\u0001\u0002L\"9\u0011q\u001a\u0001\u0005\u0002\u0005E\u0007bBAq\u0001\u0011\u0005\u00111\u001d\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u000f\u001d\u0011Y\u0002\u0001E\u0001\u0005;1qA!\t\u0001\u0011\u0003\u0011\u0019\u0003C\u0004\u0002\u0004e!\tA!\n\b\u000f\t\u001d\u0012\u0004#\u0001\u0003*\u00199!QF\r\t\u0002\t=\u0002bBA\u00029\u0011\u0005!\u0011\u0007\u0005\n\u0005ga\"\u0019!C\u0001\u0005kA\u0001Ba\u000e\u001dA\u0003%\u00111\n\u0005\n\u0005sa\"\u0019!C\u0001\u0005kA\u0001Ba\u000f\u001dA\u0003%\u00111\n\u0005\n\u0005{a\"\u0019!C\u0001\u0005kA\u0001Ba\u0010\u001dA\u0003%\u00111\n\u0005\b\u0005\u0003JB\u0011\u0001B\"\u0011\u001d\u0011\t&\u0007C\u0001\u0005'BqAa\u0016\u001a\t\u0003\u0011IF\u0001\rBkRD\u0007gT5eGN+7-\u001e:jif\u001cuN\u001c;fqRT!!\u000b\u0016\u0002\t=LGm\u0019\u0006\u0003W1\nQ!Y;uQBR!!\f\u0018\u0002\t\u0005,H\u000f\u001b\u0006\u0003_A\n!\"\u001e8tK\u000e,(/\u001b;z\u0015\u0005\t\u0014AA5p\u0007\u0001)2\u0001N!S'\u0011\u0001Qg\u000f+\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\u0015aThP'R\u001b\u0005q\u0013B\u0001 /\u0005=\u0019VmY;sSRL8i\u001c8uKb$\bC\u0001!B\u0019\u0001!QA\u0011\u0001C\u0002\r\u0013\u0011AR\u000b\u0003\t.\u000b\"!\u0012%\u0011\u0005Y2\u0015BA$8\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AN%\n\u0005);$aA!os\u0012)A*\u0011b\u0001\t\n\tq\f\u0005\u0002O\u001f6\t\u0001&\u0003\u0002QQ\t)r*\u001b3d\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Vg\u0016\u0014\bC\u0001!S\t\u0015\u0019\u0006A1\u0001E\u0005\u0005)\u0006c\u0001\u001fV\u007f%\u0011aK\f\u0002\u000e+:\u001cXmY;sSRLx\n]:\u0002\u0015\u0005,H\u000f[\"p]\u001aLw-F\u0001Z!\tq%,\u0003\u0002\\Q\tQ\u0011)\u001e;i\u0007>tg-[4\u0002\u0017\u0005,H\u000f[\"p]\u001aLw\rI\u0001\rg\u0016\u001c8/[8o'R|'/Z\u000b\u0002?B!a\nY N\u0013\t\t\u0007F\u0001\u0007TKN\u001c\u0018n\u001c8Ti>\u0014X-A\u0007tKN\u001c\u0018n\u001c8Ti>\u0014X\rI\u0001\u0007G2LWM\u001c;\u0011\t\u0015Tw\b\\\u0007\u0002M*\u0011q\r[\u0001\u0007K\u001a4Wm\u0019;\u000b\u0003%\fAaY1ug&\u00111N\u001a\u0002\t%\u0016\u001cx.\u001e:dKB\u0019Qn] \u000e\u00039T!aY8\u000b\u0005A\f\u0018A\u00025uiB$4OC\u0001s\u0003\ry'oZ\u0005\u0003i:\u0014aa\u00117jK:$\u0018A\u00027p_.,\b\u000f\u0005\u00037o6K\u0018B\u0001=8\u0005%1UO\\2uS>t\u0017\u0007E\u0002A\u0003j\u00042AN>R\u0013\taxG\u0001\u0004PaRLwN\\\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA3\u0000\u007f%\u0019\u0011\u0011\u00014\u0003\tMKhnY\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015\u0005\u001d\u0011QBA\b\u0003#\t\u0019\u0002\u0006\u0003\u0002\n\u0005-\u0001\u0003\u0002(\u0001\u007fECQ! \u0005A\u0004yDQa\u0016\u0005A\u0002eCQ!\u0018\u0005A\u0002}CQa\u0019\u0005A\u0002\u0011DQ!\u001e\u0005A\u0002Y\f1\u0001\\8h!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000fc\u0006)An\\45g&!\u0011\u0011EA\u000e\u0005\u0019aunZ4fe\u0006iAO]1og\u001a|'/\\+tKJ$2!_A\u0014\u0011\u0019\tIC\u0003a\u0001\u001b\u0006\tQ/\u0001\u0007bkRDWM\u001c;jG\u0006$X-\u0006\u0002\u00020A1\u0011\u0011GA!\u007f5k!!a\r\u000b\t\u0005U\u0012qG\u0001\u000bI&\u0014Xm\u0019;jm\u0016\u001c(b\u00019\u0002:)!\u00111HA\u001f\u0003!\u00198-\u00197bE&t'BAA \u0003\tqw.\u0003\u0003\u0002D\u0005M\"!\u0003#je\u0016\u001cG/\u001b<f\u0003%A8O\u001d4DQ\u0016\u001c7.\u0006\u0002\u0002JA9\u0011\u0011GA!\u007f\u0005-\u0003\u0003BA'\u00037rA!a\u0014\u0002XA\u0019\u0011\u0011K\u001c\u000e\u0005\u0005M#bAA+e\u00051AH]8pizJ1!!\u00178\u0003\u0019\u0001&/\u001a3fM&!\u0011QLA0\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011L\u001c\u0002\u0019Y\fG.\u001b3bi\u0016D6O\u001d4\u0015\u0011\u0005%\u0013QMA5\u0003[Bq!a\u001a\u000e\u0001\u0004\tY%\u0001\u0006ygJ4\u0007*Z1eKJDq!a\u001b\u000e\u0001\u0004\tY%A\bygJ47i\\8lS\u00164\u0018\r\\;f\u0011\u001d\ty'\u0004a\u0001\u0003c\nQ\u0002\u001f$pe^\f'\u000fZ3e\r>\u0014\b\u0003\u0002\u001c|\u0003\u0017\"B!!\u0013\u0002v!9\u0011q\u000e\bA\u0002\u0005E\u0014A\u0003=te\u001a\u001cun\\6jKR\u0011\u0011\u0011J\u0001\fkN,'oU3tg&|g\u000e\u0006\u0003\u00020\u0005}\u0004bBAA!\u0001\u0007\u00111Q\u0001\u0007G>|7.[3\u0011\t\u0005\u0015\u0015qQ\u0007\u0002_&\u0019\u0011\u0011R8\u0003\u001bI+\u0017/^3ti\u000e{wn[5f\u00039\u0019'/Z1uK\u0006+H\u000f\u001b\u0019Ve2$b!a\u0013\u0002\u0010\u0006M\u0005bBAI#\u0001\u0007\u00111J\u0001\u0006gR\fG/\u001a\u0005\b\u0003+\u000b\u0002\u0019AAL\u0003A\tW\u000f\u001e51\u0007\u0006dGNY1dWV\u0013H\u000e\u0005\u0003\u0002\u001a\u0006\rVBAAN\u0015\u0011\ti*a(\u0002\u00079,GO\u0003\u0002\u0002\"\u0006!!.\u0019<b\u0013\u0011\t)+a'\u0003\u0007U\u0013\u0016*A\u0007wC2LG-\u0019;f'R\fG/\u001a\u000b\t\u0003W\u000b\u0019,a.\u0002:B9\u0011\u0011GA!\u007f\u00055\u0006c\u0001(\u00020&\u0019\u0011\u0011\u0017\u0015\u0003\u000bM#\u0018\r^3\t\u000f\u0005U&\u00031\u0001\u0002\u0004\u0006Y1\u000f^1uK\u000e{wn[5f\u0011\u001d\t\tJ\u0005a\u0001\u0003\u0017Bq!a\u001c\u0013\u0001\u0004\t\t(\u0001\fjgJ+G/\u001e:o+Jdw\u000b[5uK2L7\u000f^3e)\u0011\ty,!2\u0011\u0007Y\n\t-C\u0002\u0002D^\u0012qAQ8pY\u0016\fg\u000eC\u0004\u0002HN\u0001\r!a&\u0002\u0007U\u0014\u0018.A\u0007tKN\u001c\u0018n\u001c8D_>\\\u0017.Z\u000b\u0003\u0003\u001b\u0004r!!\r\u0002B}\n\u0019)A\ngKR\u001c\u0007\u000eV8lK:4%o\\7BkRD\u0007\u0007\u0006\u0004\u0002T\u0006m\u0017q\u001c\t\b\u0003c\t\tePAk!\rq\u0015q[\u0005\u0004\u00033D#!\u0004+pW\u0016t'+Z:q_:\u001cX\rC\u0004\u0002^V\u0001\r!a\u0013\u0002\t\r|G-\u001a\u0005\b\u0003++\u0002\u0019AAL\u0003e1XM]5gsR{7.\u001a8B]\u0012<U\r^(jI\u000e,6/\u001a:\u0015\r\u0005=\u0012Q]Au\u0011\u001d\t9O\u0006a\u0001\u0003+\fQ\u0002^8lK:\u0014Vm\u001d9p]N,\u0007bBAv-\u0001\u0007\u0011Q^\u0001\fU^\\\u0007K]8wS\u0012,'\u000f\u0005\u0003\u0002p\u0006mXBAAy\u0015\u0011\t\u00190!>\u0002\u0007)<8NC\u0002,\u0003oT!!!?\u0002\u0007\r|W.\u0003\u0003\u0002~\u0006E(a\u0003&xWB\u0013xN^5eKJ\fAB]1oI>l7\u000b\u001e:j]\u001e$BAa\u0001\u0003\u0012Q!!Q\u0001B\u0004!\u0011\u0001\u0015)a\u0013\t\u000f\t%q\u0003q\u0001\u0003\f\u0005q!/\u00198e_6\u0004&o\u001c<jI\u0016\u0014\b\u0003\u0002(\u0003\u000e}J1Aa\u0004)\u00059\u0011\u0016M\u001c3p[B\u0013xN^5eKJDqAa\u0005\u0018\u0001\u0004\u0011)\"A\u0007mK:<G\u000f[%o\u0005f$Xm\u001d\t\u0004m\t]\u0011b\u0001B\ro\t\u0019\u0011J\u001c;\u0002\u000f\r{wn[5fgB\u0019!qD\r\u000e\u0003\u0001\u0011qaQ8pW&,7o\u0005\u0002\u001akQ\u0011!QD\u0001\u0005\u0017\u0016L8\u000fE\u0002\u0003,qi\u0011!\u0007\u0002\u0005\u0017\u0016L8o\u0005\u0002\u001dkQ\u0011!\u0011F\u0001\u0006'R\u000bE+R\u000b\u0003\u0003\u0017\naa\u0015+B)\u0016\u0003\u0013\u0001D&`'\u0016\u001b6+S(O?&#\u0015!D&`'\u0016\u001b6+S(O?&#\u0005%\u0001\u0003Y'J3\u0015!\u0002-T%\u001a\u0003\u0013\u0001E2sK\u0006$X\rW:sM\u000e{wn[5f)\u0011\u0011)E!\u0014\u0011\t\u0001\u000b%q\t\t\u0005\u0003\u000b\u0013I%C\u0002\u0003L=\u0014aBU3ta>t7/Z\"p_.LW\rC\u0004\u0003P\u0011\u0002\r!a0\u0002\u0019M,7-\u001e:f\u0007>|7.[3\u0002'\r\u0014X-\u0019;f'\u0016\u001c8/[8o\u0007>|7.[3\u0015\t\t\u0015#Q\u000b\u0005\b\u0005\u001f*\u0003\u0019AA`\u0003E\u0019'/Z1uKN#\u0018\r^3D_>\\\u0017.\u001a\u000b\u0005\u0005\u000b\u0012Y\u0006C\u0004\u0003P\u0019\u0002\r!a0")
public class Auth0OidcSecurityContext<F, U>
implements SecurityContext<F, OidcAuthenticatedUser, U>,
UnsecurityOps<F> {
    private volatile Auth0OidcSecurityContext$Cookies$ Cookies$module;
    private final AuthConfig authConfig;
    private final SessionStore<F, OidcAuthenticatedUser> sessionStore;
    private final Resource<F, Client<F>> client;
    private final Function1<OidcAuthenticatedUser, F> lookup;
    public final Sync<F> io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1;
    public final Logger io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public Auth0OidcSecurityContext$Cookies$ Cookies() {
        if (this.Cookies$module == null) {
            this.Cookies$lzycompute$1();
        }
        return this.Cookies$module;
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public SessionStore<F, OidcAuthenticatedUser> sessionStore() {
        return this.sessionStore;
    }

    public F transformUser(OidcAuthenticatedUser u) {
        return (F)this.lookup.apply((Object)u);
    }

    public Directive<F, OidcAuthenticatedUser> authenticate() {
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.trace("trying to authenticate");
        return this.sessionCookie().flatMap((Function1 & Serializable)sessionCookie -> this.userSession((RequestCookie)sessionCookie).map((Function1 & Serializable)userProfile -> userProfile));
    }

    public Directive<F, String> xsrfCheck() {
        return this.request().header("X-Forwarded-For", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedFor -> this.xsrfHeader((Option<String>)xForwardedFor.map((Function1 & Serializable)x$1 -> x$1.value())).flatMap((Function1 & Serializable)xsrfHeader -> this.xsrfCookie().flatMap((Function1 & Serializable)xsrfCookie -> this.validateXsrf((String)xsrfHeader, (String)xsrfCookie, (Option<String>)xForwardedFor.map((Function1 & Serializable)x$2 -> x$2.value())).map((Function1 & Serializable)validatedHeader -> validatedHeader))));
    }

    public Directive<F, String> validateXsrf(String xsrfHeader, String xsrfCookievalue, Option<String> xForwardedFor) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> xsrfHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).filter((Function1 & Serializable)hdr -> {
            String string = xsrfCookievalue;
            String string2 = hdr;
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.badRequest("xsrf check failed, possible CSRF-Attack!", (Option)new Some((Object)new StringBuilder(78).append("XsrfCookie does not match Xsrf header, possible CSRF-Attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString())).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        });
    }

    public Directive<F, String> xsrfHeader(Option<String> xForwardedFor) {
        return this.request().header("x-xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> Directive$.MODULE$.getOrElseF(header, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.badRequest("No x-xsrf-token header, possible CSRF-attack!", (Option)new Some((Object)new StringBuilder(47).append("No x-xsrf-token header found. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString())).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfToken -> xsrfToken.value()));
    }

    public Directive<F, String> xsrfCookie() {
        return this.request().cookie("xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> this.request().header("X-Forwarded-For", $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedfor -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.badRequest("No xsrf-token cookie found, possible CSRF-Attack", (Option)new Some((Object)new StringBuilder(42).append("No xsrf-cookie, possible CSRF-Attack from ").append(xForwardedfor.map((Function1 & Serializable)x$3 -> x$3.value()).getOrElse((Function0 & Serializable)() -> "")).toString())).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfCookie -> xsrfCookie.content())));
    }

    public Directive<F, OidcAuthenticatedUser> userSession(RequestCookie cookie) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getSession(cookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> this.responses().unauthorizedResponse((Option)new Some((Object)"Could not extract user profile from the cookie, session timed out"), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
    }

    public String createAuth0Url(String state, URI auth0CallbackUrl) {
        return new AuthAPI(this.authConfig().issuer(), this.authConfig().clientId(), this.authConfig().clientSecret()).authorizeUrl(auth0CallbackUrl.toString()).withScope("openid profile email").withState(state).withResponseType("code").build();
    }

    public Directive<F, State> validateState(RequestCookie stateCookie, String state, Option<String> xForwardedFor) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getState(stateCookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.badRequest(new StringBuilder(63).append("Invalid state, possible CSRF-attack on login. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString(), HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).withFilter((Function1 & Serializable)sessionState -> {
            String string = state;
            String string2 = sessionState.state();
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.badRequest(new StringBuilder(68).append("State values does not match, possible XSRF-attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString(), HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }).map((Function1 & Serializable)sessionState -> sessionState);
    }

    public boolean isReturnUrlWhitelisted(URI uri) {
        return this.authConfig().returnToUrlDomainWhitelist().contains((Object)uri.getHost());
    }

    public Directive<F, RequestCookie> sessionCookie() {
        return this.request().cookie(this.authConfig().cookieName(), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.unauthorized("Session cookie not found. Please login", HttpProblem$.MODULE$.unauthorized$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)cookie -> cookie));
    }

    public Directive<F, TokenResponse> fetchTokenFromAuth0(String code, URI auth0CallbackUrl) {
        Uri tokenUrl = Uri$.MODULE$.unsafeFromString(this.authConfig().issuer()).$div("oauth").$div("token");
        MediaType jsonMediaType = MediaType$.MODULE$.application().json();
        TokenRequest payload = new TokenRequest("authorization_code", this.authConfig().clientId(), this.authConfig().clientSecret(), code, auth0CallbackUrl);
        EntityEncoder jsonEncoder = org.http4s.circe.package$.MODULE$.jsonEncoderOf(TokenRequest$.MODULE$.tokenRequestEncoder());
        Request req = (Request)Request$.MODULE$.apply((Method)Method$.MODULE$.POST(), tokenUrl, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withContentType(Content$minusType$.MODULE$.apply(jsonMediaType, Charset$.MODULE$.UTF$minus8())).withEntity((Object)payload, jsonEncoder);
        Object res = this.client.use((Function1 & Serializable)c -> c.run(req).use((Function1 & Serializable)res -> res.attemptAs(EntityDecoder$.MODULE$.text($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1, EntityDecoder$.MODULE$.text$default$2())).fold((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)None$.MODULE$), (Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)new Some(s)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)new EitherT(package.functor$.MODULE$.toFunctorOps(res, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Status status = (Status)tuple2._1();
            Option maybeBody = (Option)tuple2._2();
            Status status2 = status;
            Status status3 = Status$.MODULE$.Ok();
            Either either = !(status2 != null ? !status2.equals(status3) : status3 != null) ? maybeBody.toRight((Function0 & Serializable)() -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"No data received from IdP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}))).flatMap((Function1 & Serializable)x$5 -> package$.MODULE$.decode(x$5, TokenResponse$.MODULE$.tokenResponseDecoder()).left().map((Function1 & Serializable)e -> {
                if ($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) {
                    $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(42).append("Error parsing token from auth0. Payload : ").append(maybeBody.getOrElse((Function0 & Serializable)() -> "")).toString(), (Throwable)e);
                }
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Error parsing token from auth0", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}));
            })) : scala.package$.MODULE$.Left().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Invalid response from IDP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())})));
            return either;
        })), (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toDirective((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError("Internal Server Error", (Option)None$.MODULE$, (Option)new Some(failure)).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public Directive<F, OidcAuthenticatedUser> verifyTokenAndGetOidcUser(TokenResponse tokenResponse, JwkProvider jwkProvider) {
        DecodedJWT decodedJwt = JWT.decode((String)tokenResponse.idToken());
        String decodedHeaderString = Auth0OidcSecurityContext.decodeBase64$1(decodedJwt.getHeader());
        Either decodedEitherHeader = package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()).left().map((Function1 & Serializable)x$6 -> x$6.getMessage());
        EitherT eitherUser = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), decodedEitherHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> EitherT$.MODULE$.liftF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> (RSAPublicKey)jwkProvider.get(header.kid()).getPublicKey()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)publicKey -> {
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)TokenVerifier$.MODULE$.createPublicKeyProvider((RSAPublicKey)publicKey));
            return new Tuple2(publicKey, (Object)alg);
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Algorithm alg = (Algorithm)tuple2._2();
            EitherT eitherT = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), TokenVerifier$.MODULE$.validateIdToken(alg, this.authConfig().issuer(), this.authConfig().clientId(), tokenResponse.idToken()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)oidcUser -> {
                String x$1 = tokenResponse.idToken();
                Option<String> x$2 = oidcUser.copy$default$1();
                String x$3 = oidcUser.copy$default$2();
                String x$4 = oidcUser.copy$default$3();
                OffsetDateTime x$5 = oidcUser.copy$default$4();
                String x$6 = oidcUser.copy$default$5();
                boolean x$7 = oidcUser.copy$default$6();
                String x$8 = oidcUser.copy$default$7();
                String x$9 = oidcUser.copy$default$8();
                String x$10 = oidcUser.copy$default$9();
                long x$11 = oidcUser.copy$default$10();
                long x$12 = oidcUser.copy$default$11();
                UserId x$13 = oidcUser.copy$default$12();
                String x$14 = oidcUser.copy$default$13();
                return oidcUser.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$1);
            }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            return eitherT;
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)eitherUser, (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toDirective((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError(failure, HttpProblem$.MODULE$.internalServerError$default$2(), HttpProblem$.MODULE$.internalServerError$default$3()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public F randomString(int lengthInBytes, RandomProvider<F> randomProvider) {
        return (F)package.functor$.MODULE$.toFunctorOps(randomProvider.nextBytes(lengthInBytes), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x$8 -> x$8.toHex());
    }

    private final void Cookies$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.Cookies$module == null) {
                this.Cookies$module = new Auth0OidcSecurityContext$Cookies$(this);
            }
        }
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    private static final String decodeBase64$1(String value) {
        return (String)BitVector$.MODULE$.fromValidBase64(value, BitVector$.MODULE$.fromValidBase64$default$2()).decodeUtf8().getOrElse((Function0 & Serializable)() -> "");
    }

    public Auth0OidcSecurityContext(AuthConfig authConfig, SessionStore<F, OidcAuthenticatedUser> sessionStore, Resource<F, Client<F>> client, Function1<OidcAuthenticatedUser, F> lookup, Sync<F> evidence$1) {
        this.authConfig = authConfig;
        this.sessionStore = sessionStore;
        this.client = client;
        this.lookup = lookup;
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log = LoggerFactory.getLogger((String)"io.unsecurity.auth.auth0.oidc.Auth0OidcSecurityContext");
    }
}

