/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.oidc;

import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.OptionT;
import cats.effect.Resource;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.kernel.Eq;
import cats.syntax.package;
import com.auth0.client.auth.AuthAPI;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json$;
import io.circe.KeyEncoder$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import io.unsecurity.HttpProblem$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.AuthConfig;
import io.unsecurity.auth.auth0.oidc.Auth0OidcSecurityContext$Cookies$;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.auth.auth0.oidc.OidcAuthenticatedUser;
import io.unsecurity.auth.auth0.oidc.RandomProvider;
import io.unsecurity.auth.auth0.oidc.SessionStore;
import io.unsecurity.auth.auth0.oidc.State;
import io.unsecurity.auth.auth0.oidc.TokenRequest;
import io.unsecurity.auth.auth0.oidc.TokenRequest$;
import io.unsecurity.auth.auth0.oidc.TokenResponse;
import io.unsecurity.auth.auth0.oidc.TokenResponse$;
import io.unsecurity.auth.auth0.oidc.TokenVerifier$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPublicKey;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import org.http4s.Charset$;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.headers.Content$minusType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import scodec.bits.BitVector$;

@ScalaSignature(bytes="\u0006\u0005\t}c\u0001B\u0014)\u0001MB\u0001b\u0016\u0001\u0003\u0006\u0004%\t\u0001\u0017\u0005\t;\u0002\u0011\t\u0011)A\u00053\"Aa\f\u0001BC\u0002\u0013\u0005q\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003a\u0011!!\u0007A!A!\u0002\u0013)\u0007\u0002\u0003<\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011y\u0004!1!Q\u0001\f}Dq!!\u0002\u0001\t\u0003\t9\u0001\u0003\u0005\u0002\u0018\u0001\u0001\u000b\u0011BA\r\u0011\u001d\t)\u0003\u0001C!\u0003OAq!!\f\u0001\t\u0003\ny\u0003C\u0004\u0002H\u0001!\t%!\u0013\t\u000f\u0005\r\u0004\u0001\"\u0001\u0002f!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005U\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003{\u0002A\u0011AA@\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!!+\u0001\t\u0003\tY\u000bC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005-\u0007\u0001\"\u0001\u0002N\"9\u0011\u0011\u001b\u0001\u0005\u0002\u0005M\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u000f\u001d\u0011i\u0002\u0001E\u0001\u0005?1qAa\t\u0001\u0011\u0003\u0011)\u0003C\u0004\u0002\u0006e!\tAa\n\b\u000f\t%\u0012\u0004#\u0001\u0003,\u00199!qF\r\t\u0002\tE\u0002bBA\u00039\u0011\u0005!1\u0007\u0005\n\u0005ka\"\u0019!C\u0001\u0005oA\u0001B!\u000f\u001dA\u0003%\u0011Q\n\u0005\n\u0005wa\"\u0019!C\u0001\u0005oA\u0001B!\u0010\u001dA\u0003%\u0011Q\n\u0005\n\u0005\u007fa\"\u0019!C\u0001\u0005oA\u0001B!\u0011\u001dA\u0003%\u0011Q\n\u0005\b\u0005\u0007JB\u0011\u0001B#\u0011\u001d\u0011\u0019&\u0007C\u0001\u0005+BqA!\u0017\u001a\t\u0003\u0011YF\u0001\rBkRD\u0007gT5eGN+7-\u001e:jif\u001cuN\u001c;fqRT!!\u000b\u0016\u0002\t=LGm\u0019\u0006\u0003W1\nQ!Y;uQBR!!\f\u0018\u0002\t\u0005,H\u000f\u001b\u0006\u0003_A\n!\"\u001e8tK\u000e,(/\u001b;z\u0015\u0005\t\u0014AA5p\u0007\u0001)2\u0001N!S'\u0011\u0001Qg\u000f+\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g!\u0015aThP'R\u001b\u0005q\u0013B\u0001 /\u0005=\u0019VmY;sSRL8i\u001c8uKb$\bC\u0001!B\u0019\u0001!QA\u0011\u0001C\u0002\r\u0013\u0011AR\u000b\u0003\t.\u000b\"!\u0012%\u0011\u0005Y2\u0015BA$8\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AN%\n\u0005);$aA!os\u0012)A*\u0011b\u0001\t\n\tq\f\u0005\u0002O\u001f6\t\u0001&\u0003\u0002QQ\t)r*\u001b3d\u0003V$\b.\u001a8uS\u000e\fG/\u001a3Vg\u0016\u0014\bC\u0001!S\t\u0015\u0019\u0006A1\u0001E\u0005\u0005)\u0006c\u0001\u001fV\u007f%\u0011aK\f\u0002\u000e+:\u001cXmY;sSRLx\n]:\u0002\u0015\u0005,H\u000f[\"p]\u001aLw-F\u0001Z!\tQ6,D\u0001+\u0013\ta&F\u0001\u0006BkRD7i\u001c8gS\u001e\f1\"Y;uQ\u000e{gNZ5hA\u0005a1/Z:tS>t7\u000b^8sKV\t\u0001\r\u0005\u0003OC~j\u0015B\u00012)\u00051\u0019Vm]:j_:\u001cFo\u001c:f\u00035\u0019Xm]:j_:\u001cFo\u001c:fA\u000511\r\\5f]R\u0004BAZ6@[6\tqM\u0003\u0002iS\u00061QM\u001a4fGRT\u0011A[\u0001\u0005G\u0006$8/\u0003\u0002mO\nA!+Z:pkJ\u001cW\rE\u0002oi~j\u0011a\u001c\u0006\u0003IBT!!\u001d:\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005\u0019\u0018aA8sO&\u0011Qo\u001c\u0002\u0007\u00072LWM\u001c;\u0002\r1|wn[;q!\u00111\u00040\u0014>\n\u0005e<$!\u0003$v]\u000e$\u0018n\u001c82!\r\u0001\u0015i\u001f\t\u0004mq\f\u0016BA?8\u0005\u0019y\u0005\u000f^5p]\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\t\u0019\f\taP\u0005\u0004\u0003\u00079'\u0001B*z]\u000e\fa\u0001P5oSRtDCCA\u0005\u0003\u001f\t\t\"a\u0005\u0002\u0016Q!\u00111BA\u0007!\u0011q\u0005aP)\t\u000byD\u00019A@\t\u000b]C\u0001\u0019A-\t\u000byC\u0001\u0019\u00011\t\u000b\u0011D\u0001\u0019A3\t\u000bYD\u0001\u0019A<\u0002\u00071|w\r\u0005\u0003\u0002\u001c\u0005\u0005RBAA\u000f\u0015\r\tyB]\u0001\u0006Y><Gg]\u0005\u0005\u0003G\tiB\u0001\u0004M_\u001e<WM]\u0001\u000eiJ\fgn\u001d4pe6,6/\u001a:\u0015\u0007i\fI\u0003\u0003\u0004\u0002,)\u0001\r!T\u0001\u0002k\u0006a\u0011-\u001e;iK:$\u0018nY1uKV\u0011\u0011\u0011\u0007\t\u0007\u0003g\t\u0019eP'\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t!\u0002Z5sK\u000e$\u0018N^3t\u0015\r\t\u00181\b\u0006\u0005\u0003{\ty$\u0001\u0005tG\u0006d\u0017MY5o\u0015\t\t\t%\u0001\u0002o_&!\u0011QIA\u001b\u0005%!\u0015N]3di&4X-A\u0005ygJ47\t[3dWV\u0011\u00111\n\t\b\u0003g\t\u0019ePA'!\u0011\ty%!\u0018\u000f\t\u0005E\u0013\u0011\f\t\u0004\u0003':TBAA+\u0015\r\t9FM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005ms'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\n\tG\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037:\u0014\u0001\u0004<bY&$\u0017\r^3YgJ4G\u0003CA&\u0003O\nY'a\u001c\t\u000f\u0005%T\u00021\u0001\u0002N\u0005Q\u0001p\u001d:g\u0011\u0016\fG-\u001a:\t\u000f\u00055T\u00021\u0001\u0002N\u0005y\u0001p\u001d:g\u0007>|7.[3wC2,X\rC\u0004\u0002r5\u0001\r!a\u001d\u0002\u001ba4uN]<be\u0012,GMR8s!\u00111D0!\u0014\u0015\t\u0005-\u0013q\u000f\u0005\b\u0003cr\u0001\u0019AA:\u0003)A8O\u001d4D_>\\\u0017.\u001a\u000b\u0003\u0003\u0017\n1\"^:feN+7o]5p]R!\u0011\u0011GAA\u0011\u001d\t\u0019\t\u0005a\u0001\u0003\u000b\u000baaY8pW&,\u0007\u0003BAD\u0003\u0013k\u0011\u0001]\u0005\u0004\u0003\u0017\u0003(!\u0004*fcV,7\u000f^\"p_.LW-\u0001\bde\u0016\fG/Z!vi\"\u0004TK\u001d7\u0015\r\u00055\u0013\u0011SAK\u0011\u001d\t\u0019*\u0005a\u0001\u0003\u001b\nQa\u001d;bi\u0016Dq!a&\u0012\u0001\u0004\tI*\u0001\tbkRD\u0007gQ1mY\n\f7m[+sYB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016a\u00018fi*\u0011\u00111U\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002(\u0006u%aA+S\u0013\u0006ia/\u00197jI\u0006$Xm\u0015;bi\u0016$\u0002\"!,\u00026\u0006e\u00161\u0018\t\b\u0003g\t\u0019ePAX!\rq\u0015\u0011W\u0005\u0004\u0003gC#!B*uCR,\u0007bBA\\%\u0001\u0007\u0011QQ\u0001\fgR\fG/Z\"p_.LW\rC\u0004\u0002\u0014J\u0001\r!!\u0014\t\u000f\u0005E$\u00031\u0001\u0002t\u00051\u0012n\u001d*fiV\u0014h.\u0016:m/\"LG/\u001a7jgR,G\r\u0006\u0003\u0002B\u0006\u001d\u0007c\u0001\u001c\u0002D&\u0019\u0011QY\u001c\u0003\u000f\t{w\u000e\\3b]\"9\u0011\u0011Z\nA\u0002\u0005e\u0015aA;sS\u0006i1/Z:tS>t7i\\8lS\u0016,\"!a4\u0011\u000f\u0005M\u00121I \u0002\u0006\u0006\u0019b-\u001a;dQR{7.\u001a8Ge>l\u0017)\u001e;iaQ1\u0011Q[Ao\u0003C\u0004r!a\r\u0002D}\n9\u000eE\u0002O\u00033L1!a7)\u00055!vn[3o%\u0016\u001c\bo\u001c8tK\"9\u0011q\\\u000bA\u0002\u00055\u0013\u0001B2pI\u0016Dq!a&\u0016\u0001\u0004\tI*A\rwKJLg-\u001f+pW\u0016t\u0017I\u001c3HKR|\u0015\u000eZ2Vg\u0016\u0014HCBA\u0019\u0003O\fY\u000fC\u0004\u0002jZ\u0001\r!a6\u0002\u001bQ|7.\u001a8SKN\u0004xN\\:f\u0011\u001d\tiO\u0006a\u0001\u0003_\f1B[<l!J|g/\u001b3feB!\u0011\u0011_A\u007f\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0018a\u00016xW*\u00191&!?\u000b\u0005\u0005m\u0018aA2p[&!\u0011q`Az\u0005-Quo\u001b)s_ZLG-\u001a:\u0002\u0019I\fg\u000eZ8n'R\u0014\u0018N\\4\u0015\t\t\u0015!1\u0003\u000b\u0005\u0005\u000f\u0011I\u0001\u0005\u0003A\u0003\u00065\u0003b\u0002B\u0006/\u0001\u000f!QB\u0001\u000fe\u0006tGm\\7Qe>4\u0018\u000eZ3s!\u0011q%qB \n\u0007\tE\u0001F\u0001\bSC:$w.\u001c)s_ZLG-\u001a:\t\u000f\tUq\u00031\u0001\u0003\u0018\u0005iA.\u001a8hi\"LeNQ=uKN\u00042A\u000eB\r\u0013\r\u0011Yb\u000e\u0002\u0004\u0013:$\u0018aB\"p_.LWm\u001d\t\u0004\u0005CIR\"\u0001\u0001\u0003\u000f\r{wn[5fgN\u0011\u0011$\u000e\u000b\u0003\u0005?\tAaS3zgB\u0019!Q\u0006\u000f\u000e\u0003e\u0011AaS3zgN\u0011A$\u000e\u000b\u0003\u0005W\tQa\u0015+B)\u0016+\"!!\u0014\u0002\rM#\u0016\tV#!\u00031YulU#T'&{ejX%E\u00035YulU#T'&{ejX%EA\u0005!\u0001l\u0015*G\u0003\u0015A6K\u0015$!\u0003A\u0019'/Z1uKb\u001b(OZ\"p_.LW\r\u0006\u0003\u0003H\t=\u0003\u0003\u0002!B\u0005\u0013\u0002B!a\"\u0003L%\u0019!Q\n9\u0003\u001dI+7\u000f]8og\u0016\u001cun\\6jK\"9!\u0011\u000b\u0013A\u0002\u0005\u0005\u0017\u0001D:fGV\u0014XmQ8pW&,\u0017aE2sK\u0006$XmU3tg&|gnQ8pW&,G\u0003\u0002B$\u0005/BqA!\u0015&\u0001\u0004\t\t-A\tde\u0016\fG/Z*uCR,7i\\8lS\u0016$BAa\u0012\u0003^!9!\u0011\u000b\u0014A\u0002\u0005\u0005\u0007")
public class Auth0OidcSecurityContext<F, U>
implements SecurityContext<F, OidcAuthenticatedUser, U>,
UnsecurityOps<F> {
    private volatile Auth0OidcSecurityContext$Cookies$ Cookies$module;
    private final AuthConfig authConfig;
    private final SessionStore<F, OidcAuthenticatedUser> sessionStore;
    private final Resource<F, Client<F>> client;
    private final Function1<OidcAuthenticatedUser, F> lookup;
    public final Sync<F> io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1;
    public final Logger io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public Auth0OidcSecurityContext$Cookies$ Cookies() {
        if (this.Cookies$module == null) {
            this.Cookies$lzycompute$1();
        }
        return this.Cookies$module;
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public SessionStore<F, OidcAuthenticatedUser> sessionStore() {
        return this.sessionStore;
    }

    public F transformUser(OidcAuthenticatedUser u) {
        return (F)this.lookup.apply((Object)u);
    }

    public Directive<F, OidcAuthenticatedUser> authenticate() {
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.trace("trying to authenticate");
        return this.sessionCookie().flatMap((Function1 & Serializable)sessionCookie -> this.userSession((RequestCookie)sessionCookie).map((Function1 & Serializable)userProfile -> userProfile));
    }

    public Directive<F, String> xsrfCheck() {
        return this.request().header("X-Forwarded-For", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedFor -> this.xsrfHeader((Option<String>)xForwardedFor.map((Function1 & Serializable)x$1 -> x$1.value())).flatMap((Function1 & Serializable)xsrfHeader -> this.xsrfCookie().flatMap((Function1 & Serializable)xsrfCookie -> this.validateXsrf((String)xsrfHeader, (String)xsrfCookie, (Option<String>)xForwardedFor.map((Function1 & Serializable)x$2 -> x$2.value())).map((Function1 & Serializable)validatedHeader -> validatedHeader))));
    }

    public Directive<F, String> validateXsrf(String xsrfHeader, String xsrfCookievalue, Option<String> xForwardedFor) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> xsrfHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).filter((Function1 & Serializable)hdr -> {
            String string = xsrfCookievalue;
            String string2 = hdr;
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
                block0: {
                    if (!$this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) break block0;
                    $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(78).append("XsrfCookie does not match Xsrf header, possible CSRF-Attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString());
                }
                return HttpProblem$.MODULE$.badRequest("xsrf check failed", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        });
    }

    public Directive<F, String> xsrfHeader(Option<String> xForwardedFor) {
        return this.request().header("x-xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> Directive$.MODULE$.getOrElseF(header, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error("No x-xsrf-token header, possible CSRF-attack!");
            return HttpProblem$.MODULE$.badRequest(new StringBuilder(47).append("No x-xsrf-token header found. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString(), HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfToken -> xsrfToken.value()));
    }

    public Directive<F, String> xsrfCookie() {
        return this.request().cookie("xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> this.request().header("X-Forwarded-For", $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedfor -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            block0: {
                if (!$this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) break block0;
                $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(42).append("No xsrf-cookie, possible CSRF-Attack from ").append(xForwardedfor.map((Function1 & Serializable)x$3 -> x$3.value()).getOrElse((Function0 & Serializable)() -> "")).toString());
            }
            return HttpProblem$.MODULE$.badRequest("No xsrf-token cookie found", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfCookie -> xsrfCookie.content())));
    }

    public Directive<F, OidcAuthenticatedUser> userSession(RequestCookie cookie) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getSession(cookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.warn("Could not extract user profile: {}, session timed out");
            return this.responses().unauthorizedResponse((Option)new Some((Object)"Could not extract user profile from the cookie"), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
    }

    public String createAuth0Url(String state, URI auth0CallbackUrl) {
        return new AuthAPI(this.authConfig().issuer(), this.authConfig().clientId(), this.authConfig().clientSecret()).authorizeUrl(auth0CallbackUrl.toString()).withScope("openid profile email").withState(state).withResponseType("code").build();
    }

    public Directive<F, State> validateState(RequestCookie stateCookie, String state, Option<String> xForwardedFor) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getState(stateCookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            block0: {
                if (!$this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) break block0;
                $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(63).append("Invalid state, possible CSRF-attack on login. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString());
            }
            return HttpProblem$.MODULE$.badRequest("Invalid state, possible csrf-attack", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).withFilter((Function1 & Serializable)sessionState -> {
            String string = state;
            String string2 = sessionState.state();
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
                block0: {
                    if (!$this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) break block0;
                    $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(69).append("State values does not match, possible XSRF-attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).append(" ").toString());
                }
                return HttpProblem$.MODULE$.badRequest("Illegal state value", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }).map((Function1 & Serializable)sessionState -> sessionState);
    }

    public boolean isReturnUrlWhitelisted(URI uri) {
        return this.authConfig().returnToUrlDomainWhitelist().contains((Object)uri.getHost());
    }

    public Directive<F, RequestCookie> sessionCookie() {
        return this.request().cookie(this.authConfig().cookieName(), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.unauthorized("Session cookie not found. Please login", HttpProblem$.MODULE$.unauthorized$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)cookie -> cookie));
    }

    public Directive<F, TokenResponse> fetchTokenFromAuth0(String code, URI auth0CallbackUrl) {
        Uri tokenUrl = Uri$.MODULE$.unsafeFromString(this.authConfig().issuer()).$div("oauth").$div("token");
        MediaType jsonMediaType = MediaType$.MODULE$.application().json();
        TokenRequest payload = new TokenRequest("authorization_code", this.authConfig().clientId(), this.authConfig().clientSecret(), code, auth0CallbackUrl);
        EntityEncoder jsonEncoder = org.http4s.circe.package$.MODULE$.jsonEncoderOf(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1, TokenRequest$.MODULE$.tokenRequestEncoder());
        Request req = (Request)Request$.MODULE$.apply((Method)Method$.MODULE$.POST(), tokenUrl, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withContentType(Content$minusType$.MODULE$.apply(jsonMediaType, Charset$.MODULE$.UTF$minus8())).withEntity((Object)payload, jsonEncoder);
        Object res = this.client.use((Function1 & Serializable)c -> c.fetch(req, (Function1 & Serializable)res -> res.attemptAs(EntityDecoder$.MODULE$.text($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1, EntityDecoder$.MODULE$.text$default$2())).fold((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)None$.MODULE$), (Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)new Some(s)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)new EitherT(package.functor$.MODULE$.toFunctorOps(res, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Status status = (Status)tuple2._1();
            Option maybeBody = (Option)tuple2._2();
            Status status2 = status;
            Status status3 = Status$.MODULE$.Ok();
            Either either = !(status2 != null ? !status2.equals(status3) : status3 != null) ? maybeBody.toRight((Function0 & Serializable)() -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"No data received from IdP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}))).flatMap((Function1 & Serializable)x$5 -> package$.MODULE$.decode(x$5, TokenResponse$.MODULE$.tokenResponseDecoder()).left().map((Function1 & Serializable)e -> {
                if ($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.isErrorEnabled()) {
                    $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log.error(new StringBuilder(42).append("Error parsing token from auth0. Payload : ").append(maybeBody.getOrElse((Function0 & Serializable)() -> "")).toString(), (Throwable)e);
                }
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Error parsing token from auth0", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}));
            })) : scala.package$.MODULE$.Left().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Invalid response from IDP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())})));
            return either;
        })), (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toSuccess((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError("Internal Server Error", (Option)None$.MODULE$, (Option)new Some(failure)).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public Directive<F, OidcAuthenticatedUser> verifyTokenAndGetOidcUser(TokenResponse tokenResponse, JwkProvider jwkProvider) {
        DecodedJWT decodedJwt = JWT.decode((String)tokenResponse.idToken());
        String decodedHeaderString = Auth0OidcSecurityContext.decodeBase64$1(decodedJwt.getHeader());
        Either decodedEitherHeader = package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()).left().map((Function1 & Serializable)x$6 -> x$6.getMessage());
        EitherT eitherUser = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), decodedEitherHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> EitherT$.MODULE$.liftF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> (RSAPublicKey)jwkProvider.get(header.kid()).getPublicKey()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)publicKey -> {
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)TokenVerifier$.MODULE$.createPublicKeyProvider((RSAPublicKey)publicKey));
            return new Tuple2(publicKey, (Object)alg);
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Algorithm alg = (Algorithm)tuple2._2();
            EitherT eitherT = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), TokenVerifier$.MODULE$.validateIdToken(alg, this.authConfig().issuer(), this.authConfig().clientId(), tokenResponse.idToken()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)oidcUser -> oidcUser, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            return eitherT;
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)eitherUser, (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toSuccess((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError(failure, HttpProblem$.MODULE$.internalServerError$default$2(), HttpProblem$.MODULE$.internalServerError$default$3()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public F randomString(int lengthInBytes, RandomProvider<F> randomProvider) {
        return (F)package.functor$.MODULE$.toFunctorOps(randomProvider.nextBytes(lengthInBytes), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x$8 -> x$8.toHex());
    }

    private final void Cookies$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.Cookies$module == null) {
                this.Cookies$module = new Auth0OidcSecurityContext$Cookies$(this);
            }
        }
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    private static final String decodeBase64$1(String value) {
        return (String)BitVector$.MODULE$.fromValidBase64(value, BitVector$.MODULE$.fromValidBase64$default$2()).decodeUtf8().getOrElse((Function0 & Serializable)() -> "");
    }

    public Auth0OidcSecurityContext(AuthConfig authConfig, SessionStore<F, OidcAuthenticatedUser> sessionStore, Resource<F, Client<F>> client, Function1<OidcAuthenticatedUser, F> lookup, Sync<F> evidence$1) {
        this.authConfig = authConfig;
        this.sessionStore = sessionStore;
        this.client = client;
        this.lookup = lookup;
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$log = LoggerFactory.getLogger((String)"io.unsecurity.auth.auth0.oidc.Auth0OidcSecurityContext");
    }
}

