/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.oidc;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Error;
import io.circe.parser.package$;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtPayload$;
import io.unsecurity.auth.auth0.oidc.OidcAuthenticatedUser;
import io.unsecurity.auth.auth0.oidc.OidcAuthenticatedUser$;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.commons.codec.binary.Base64;
import scala.MatchError;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TokenVerifier$ {
    public static final TokenVerifier$ MODULE$ = new TokenVerifier$();

    public String decodeBase64(String value) {
        return new String(Base64.decodeBase64((String)value), "UTF-8");
    }

    public RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    public Either<String, OidcAuthenticatedUser> validateIdToken(Algorithm alg, String issuer, String clientId, String idToken) {
        Left left;
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{issuer}).withAudience(new String[]{clientId}).build();
        try {
            Left left2;
            DecodedJWT verifiedToken = verifier.verify(idToken);
            Either either = package$.MODULE$.decode(this.decodeBase64(verifiedToken.getPayload()), Jwt$JwtPayload$.MODULE$.jwtPayloadDecoder());
            if (either instanceof Left) {
                Left left3 = (Left)either;
                Error error = (Error)left3.value();
                left2 = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(30).append("Unable to decode JWT payload: ").append(error).toString());
            } else if (either instanceof Right) {
                Left left4;
                Right right = (Right)either;
                Jwt.JwtPayload payload = (Jwt.JwtPayload)right.value();
                OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(payload.exp()).atOffset(ZoneOffset.UTC));
                OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
                if (now.isAfter(expirationTime)) {
                    left4 = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(44).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).toString());
                } else {
                    Right right2;
                    Either either2 = package$.MODULE$.decode(this.decodeBase64(verifiedToken.getPayload()), OidcAuthenticatedUser$.MODULE$.authenticatedUserDecoder());
                    if (either2 instanceof Left) {
                        Left left5 = (Left)either2;
                        Error e = (Error)left5.value();
                        right2 = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(50).append("Could not parse userprofile from auth0 ").append(e).append(". Payload: ").append(verifiedToken.getPayload()).toString());
                    } else if (either2 instanceof Right) {
                        Right right3 = (Right)either2;
                        OidcAuthenticatedUser profile = (OidcAuthenticatedUser)right3.value();
                        right2 = scala.package$.MODULE$.Right().apply((Object)profile);
                    } else {
                        throw new MatchError((Object)either2);
                    }
                    left4 = right2;
                }
                left2 = left4;
            } else {
                throw new MatchError((Object)either);
            }
            left = left2;
        }
        catch (Exception ex) {
            left = scala.package$.MODULE$.Left().apply((Object)new StringBuilder(25).append("Exception decoding token ").append(ex.getMessage()).toString());
        }
        return left;
    }

    private TokenVerifier$() {
    }
}

