/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.oidc;

import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.data.OptionT;
import cats.effect.Resource;
import cats.effect.Sync;
import cats.effect.Sync$;
import cats.kernel.Eq;
import cats.syntax.package;
import com.auth0.client.auth.AuthAPI;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json$;
import io.circe.KeyEncoder$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import io.unsecurity.HttpProblem$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.AuthConfig;
import io.unsecurity.auth.auth0.oidc.Auth0OidcSecurityContext$Cookies$;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.auth.auth0.oidc.OidcAuthenticatedUser;
import io.unsecurity.auth.auth0.oidc.RandomProvider;
import io.unsecurity.auth.auth0.oidc.SessionStore;
import io.unsecurity.auth.auth0.oidc.State;
import io.unsecurity.auth.auth0.oidc.TokenRequest;
import io.unsecurity.auth.auth0.oidc.TokenRequest$;
import io.unsecurity.auth.auth0.oidc.TokenResponse;
import io.unsecurity.auth.auth0.oidc.TokenResponse$;
import io.unsecurity.auth.auth0.oidc.TokenVerifier$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPublicKey;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import org.http4s.Charset$;
import org.http4s.EntityDecoder$;
import org.http4s.EntityEncoder;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.MediaType;
import org.http4s.MediaType$;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Request;
import org.http4s.Request$;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Status;
import org.http4s.Status$;
import org.http4s.Uri;
import org.http4s.Uri$;
import org.http4s.client.Client;
import org.http4s.headers.Content$minusType$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try;
import scodec.bits.BitVector$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001\u0002\u0015*\u0001QB\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!\u0017\u0005\t=\u0002\u0011\t\u0011)A\u00055\"Aq\f\u0001BC\u0002\u0013\u0005\u0001\r\u0003\u0005e\u0001\t\u0005\t\u0015!\u0003b\u0011!)\u0007A!A!\u0002\u00131\u0007\u0002C<\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0013}\u0004!1!Q\u0001\f\u0005\u0005\u0001bBA\u0004\u0001\u0011\u0005\u0011\u0011\u0002\u0005\n\u00033\u0001!\u0019!C\u0001\u00037A\u0001\"!\u000b\u0001A\u0003%\u0011Q\u0004\u0005\b\u0003W\u0001A\u0011IA\u0017\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!!\u0014\u0001\t\u0003\ny\u0005C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005=\u0004\u0001\"\u0001\u0002|!9\u0011q\u0010\u0001\u0005\u0002\u0005\u0005\u0005bBAB\u0001\u0011\u0005\u0011Q\u0011\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\ty\u000b\u0001C\u0001\u0003cCq!a1\u0001\t\u0003\t)\rC\u0004\u0002R\u0002!\t!a5\t\u000f\u0005]\u0007\u0001\"\u0001\u0002Z\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\bb\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0004\b\u0005G\u0001\u0001\u0012\u0001B\u0013\r\u001d\u0011I\u0003\u0001E\u0001\u0005WAq!a\u0002\u001b\t\u0003\u0011icB\u0004\u00030iA\tA!\r\u0007\u000f\tU\"\u0004#\u0001\u00038!9\u0011qA\u000f\u0005\u0002\te\u0002\"\u0003B\u001e;\t\u0007I\u0011\u0001B\u001f\u0011!\u0011y$\bQ\u0001\n\u0005M\u0003\"\u0003B!;\t\u0007I\u0011\u0001B\u001f\u0011!\u0011\u0019%\bQ\u0001\n\u0005M\u0003\"\u0003B#;\t\u0007I\u0011\u0001B\u001f\u0011!\u00119%\bQ\u0001\n\u0005M\u0003b\u0002B%5\u0011\u0005!1\n\u0005\b\u00053RB\u0011\u0001B.\u0011\u001d\u0011yF\u0007C\u0001\u0005C\u0012\u0001$Q;uQBz\u0015\u000eZ2TK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u0015\tQ3&\u0001\u0003pS\u0012\u001c'B\u0001\u0017.\u0003\u0015\tW\u000f\u001e51\u0015\tqs&\u0001\u0003bkRD'B\u0001\u00192\u0003))hn]3dkJLG/\u001f\u0006\u0002e\u0005\u0011\u0011n\\\u0002\u0001+\r)$iU\n\u0005\u0001YbT\u000b\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VM\u001a\t\u0006{y\u0002eJU\u0007\u0002_%\u0011qh\f\u0002\u0010'\u0016\u001cWO]5us\u000e{g\u000e^3yiB\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019\u0005A1\u0001E\u0005\u00051UCA#M#\t1\u0015\n\u0005\u00028\u000f&\u0011\u0001\n\u000f\u0002\b\u001d>$\b.\u001b8h!\t9$*\u0003\u0002Lq\t\u0019\u0011I\\=\u0005\u000b5\u0013%\u0019A#\u0003\u0003}\u0003\"a\u0014)\u000e\u0003%J!!U\u0015\u0003+=KGmY!vi\",g\u000e^5dCR,G-V:feB\u0011\u0011i\u0015\u0003\u0006)\u0002\u0011\r!\u0012\u0002\u0002+B\u0019QH\u0016!\n\u0005]{#!D+og\u0016\u001cWO]5us>\u00038/\u0001\u0006bkRD7i\u001c8gS\u001e,\u0012A\u0017\t\u00037rk\u0011aK\u0005\u0003;.\u0012!\"Q;uQ\u000e{gNZ5h\u0003-\tW\u000f\u001e5D_:4\u0017n\u001a\u0011\u0002\u0019M,7o]5p]N#xN]3\u0016\u0003\u0005\u0004Ba\u00142A\u001d&\u00111-\u000b\u0002\r'\u0016\u001c8/[8o'R|'/Z\u0001\u000eg\u0016\u001c8/[8o'R|'/\u001a\u0011\u0002\r\rd\u0017.\u001a8u!\u00119G\u000e\u00118\u000e\u0003!T!!\u001b6\u0002\r\u00154g-Z2u\u0015\u0005Y\u0017\u0001B2biNL!!\u001c5\u0003\u0011I+7o\\;sG\u0016\u00042a\\;A\u001b\u0005\u0001(BA3r\u0015\t\u00118/\u0001\u0004iiR\u0004Hg\u001d\u0006\u0002i\u0006\u0019qN]4\n\u0005Y\u0004(AB\"mS\u0016tG/\u0001\u0004m_>\\W\u000f\u001d\t\u0005oet50\u0003\u0002{q\tIa)\u001e8di&|g.\r\t\u0004\u0003\nc\bcA\u001c~%&\u0011a\u0010\u000f\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u0005\u0003h\u0003\u0007\u0001\u0015bAA\u0003Q\n!1+\u001f8d\u0003\u0019a\u0014N\\5u}QQ\u00111BA\t\u0003'\t)\"a\u0006\u0015\t\u00055\u0011q\u0002\t\u0005\u001f\u0002\u0001%\u000b\u0003\u0004\u0000\u0011\u0001\u000f\u0011\u0011\u0001\u0005\u00061\"\u0001\rA\u0017\u0005\u0006?\"\u0001\r!\u0019\u0005\u0006K\"\u0001\rA\u001a\u0005\u0006o\"\u0001\r\u0001_\u0001\u0004Y><WCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012g\u0006)1\u000f\u001c45U&!\u0011qEA\u0011\u0005\u0019aunZ4fe\u0006!An\\4!\u00035!(/\u00198tM>\u0014X.V:feR\u001910a\f\t\r\u0005E2\u00021\u0001O\u0003\u0005)\u0018\u0001D1vi\",g\u000e^5dCR,WCAA\u001c!\u0019\tI$!\u0013A\u001d6\u0011\u00111\b\u0006\u0005\u0003{\ty$\u0001\u0006eSJ,7\r^5wKNT1A]A!\u0015\u0011\t\u0019%!\u0012\u0002\u0011M\u001c\u0017\r\\1cS:T!!a\u0012\u0002\u00059|\u0017\u0002BA&\u0003w\u0011\u0011\u0002R5sK\u000e$\u0018N^3\u0002\u0013a\u001c(OZ\"iK\u000e\\WCAA)!\u001d\tI$!\u0013A\u0003'\u0002B!!\u0016\u0002d9!\u0011qKA0!\r\tI\u0006O\u0007\u0003\u00037R1!!\u00184\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\r\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\t)'a\u001a\u0003\rM#(/\u001b8h\u0015\r\t\t\u0007O\u0001\rm\u0006d\u0017\u000eZ1uKb\u001b(O\u001a\u000b\t\u0003#\ni'!\u001d\u0002v!9\u0011q\u000e\bA\u0002\u0005M\u0013A\u0003=te\u001aDU-\u00193fe\"9\u00111\u000f\bA\u0002\u0005M\u0013a\u0004=te\u001a\u001cun\\6jKZ\fG.^3\t\u000f\u0005]d\u00021\u0001\u0002z\u0005i\u0001PR8so\u0006\u0014H-\u001a3G_J\u0004BaN?\u0002TQ!\u0011\u0011KA?\u0011\u001d\t9h\u0004a\u0001\u0003s\n!\u0002_:sM\u000e{wn[5f)\t\t\t&A\u0006vg\u0016\u00148+Z:tS>tG\u0003BA\u001c\u0003\u000fCq!!#\u0012\u0001\u0004\tY)\u0001\u0004d_>\\\u0017.\u001a\t\u0005\u0003\u001b\u000by)D\u0001r\u0013\r\t\t*\u001d\u0002\u000e%\u0016\fX/Z:u\u0007>|7.[3\u0002\u001d\r\u0014X-\u0019;f\u0003V$\b\u000eM+sYR1\u00111KAL\u00037Cq!!'\u0013\u0001\u0004\t\u0019&A\u0003ti\u0006$X\rC\u0004\u0002\u001eJ\u0001\r!a(\u0002!\u0005,H\u000f\u001b\u0019DC2d'-Y2l+Jd\u0007\u0003BAQ\u0003Wk!!a)\u000b\t\u0005\u0015\u0016qU\u0001\u0004]\u0016$(BAAU\u0003\u0011Q\u0017M^1\n\t\u00055\u00161\u0015\u0002\u0004+JK\u0015!\u0004<bY&$\u0017\r^3Ti\u0006$X\r\u0006\u0005\u00024\u0006m\u0016qXAa!\u001d\tI$!\u0013A\u0003k\u00032aTA\\\u0013\r\tI,\u000b\u0002\u0006'R\fG/\u001a\u0005\b\u0003{\u001b\u0002\u0019AAF\u0003-\u0019H/\u0019;f\u0007>|7.[3\t\u000f\u0005e5\u00031\u0001\u0002T!9\u0011qO\nA\u0002\u0005e\u0014AF5t%\u0016$XO\u001d8Ve2<\u0006.\u001b;fY&\u001cH/\u001a3\u0015\t\u0005\u001d\u0017Q\u001a\t\u0004o\u0005%\u0017bAAfq\t9!i\\8mK\u0006t\u0007bBAh)\u0001\u0007\u0011qT\u0001\u0004kJL\u0017!D:fgNLwN\\\"p_.LW-\u0006\u0002\u0002VB9\u0011\u0011HA%\u0001\u0006-\u0015a\u00054fi\u000eDGk\\6f]\u001a\u0013x.\\!vi\"\u0004DCBAn\u0003G\f9\u000fE\u0004\u0002:\u0005%\u0003)!8\u0011\u0007=\u000by.C\u0002\u0002b&\u0012Q\u0002V8lK:\u0014Vm\u001d9p]N,\u0007bBAs-\u0001\u0007\u00111K\u0001\u0005G>$W\rC\u0004\u0002\u001eZ\u0001\r!a(\u00023Y,'/\u001b4z)>\\WM\\!oI\u001e+GoT5eGV\u001bXM\u001d\u000b\u0007\u0003o\ti/!=\t\u000f\u0005=x\u00031\u0001\u0002^\u0006iAo\\6f]J+7\u000f]8og\u0016Dq!a=\u0018\u0001\u0004\t)0A\u0006ko.\u0004&o\u001c<jI\u0016\u0014\b\u0003BA|\u0005\u0007i!!!?\u000b\t\u0005m\u0018Q`\u0001\u0004U^\\'b\u0001\u0017\u0002\u0000*\u0011!\u0011A\u0001\u0004G>l\u0017\u0002\u0002B\u0003\u0003s\u00141BS<l!J|g/\u001b3fe\u0006a!/\u00198e_6\u001cFO]5oOR!!1\u0002B\r)\u0011\u0011iAa\u0004\u0011\t\u0005\u0013\u00151\u000b\u0005\b\u0005#A\u00029\u0001B\n\u00039\u0011\u0018M\u001c3p[B\u0013xN^5eKJ\u0004Ba\u0014B\u000b\u0001&\u0019!qC\u0015\u0003\u001dI\u000bg\u000eZ8n!J|g/\u001b3fe\"9!1\u0004\rA\u0002\tu\u0011!\u00047f]\u001e$\b.\u00138CsR,7\u000fE\u00028\u0005?I1A!\t9\u0005\rIe\u000e^\u0001\b\u0007>|7.[3t!\r\u00119CG\u0007\u0002\u0001\t91i\\8lS\u0016\u001c8C\u0001\u000e7)\t\u0011)#\u0001\u0003LKf\u001c\bc\u0001B\u001a;5\t!D\u0001\u0003LKf\u001c8CA\u000f7)\t\u0011\t$A\u0003T)\u0006#V)\u0006\u0002\u0002T\u000511\u000bV!U\u000b\u0002\nAbS0T\u000bN\u001b\u0016j\u0014(`\u0013\u0012\u000bQbS0T\u000bN\u001b\u0016j\u0014(`\u0013\u0012\u0003\u0013\u0001\u0002-T%\u001a\u000bQ\u0001W*S\r\u0002\n\u0001c\u0019:fCR,\u0007l\u001d:g\u0007>|7.[3\u0015\t\t5#Q\u000b\t\u0005\u0003\n\u0013y\u0005\u0005\u0003\u0002\u000e\nE\u0013b\u0001B*c\nq!+Z:q_:\u001cXmQ8pW&,\u0007b\u0002B,K\u0001\u0007\u0011qY\u0001\rg\u0016\u001cWO]3D_>\\\u0017.Z\u0001\u0014GJ,\u0017\r^3TKN\u001c\u0018n\u001c8D_>\\\u0017.\u001a\u000b\u0005\u0005\u001b\u0012i\u0006C\u0004\u0003X\u0019\u0002\r!a2\u0002#\r\u0014X-\u0019;f'R\fG/Z\"p_.LW\r\u0006\u0003\u0003N\t\r\u0004b\u0002B,O\u0001\u0007\u0011q\u0019")
public class Auth0OidcSecurityContext<F, U>
implements SecurityContext<F, OidcAuthenticatedUser, U>,
UnsecurityOps<F> {
    private volatile Auth0OidcSecurityContext$Cookies$ Cookies$module;
    private final AuthConfig authConfig;
    private final SessionStore<F, OidcAuthenticatedUser> sessionStore;
    private final Resource<F, Client<F>> client;
    private final Function1<OidcAuthenticatedUser, F> lookup;
    public final Sync<F> io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1;
    private final Logger log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public Auth0OidcSecurityContext$Cookies$ Cookies() {
        if (this.Cookies$module == null) {
            this.Cookies$lzycompute$1();
        }
        return this.Cookies$module;
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public AuthConfig authConfig() {
        return this.authConfig;
    }

    public SessionStore<F, OidcAuthenticatedUser> sessionStore() {
        return this.sessionStore;
    }

    public Logger log() {
        return this.log;
    }

    public F transformUser(OidcAuthenticatedUser u) {
        return (F)this.lookup.apply((Object)u);
    }

    public Directive<F, OidcAuthenticatedUser> authenticate() {
        this.log().trace("trying to authenticate");
        return this.sessionCookie().flatMap((Function1 & Serializable)sessionCookie -> this.userSession((RequestCookie)sessionCookie).map((Function1 & Serializable)userProfile -> userProfile));
    }

    public Directive<F, String> xsrfCheck() {
        return this.request().header("X-Forwarded-For", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedFor -> this.xsrfHeader((Option<String>)xForwardedFor.map((Function1 & Serializable)x$1 -> x$1.value())).flatMap((Function1 & Serializable)xsrfHeader -> this.xsrfCookie().flatMap((Function1 & Serializable)xsrfCookie -> this.validateXsrf((String)xsrfHeader, (String)xsrfCookie, (Option<String>)xForwardedFor.map((Function1 & Serializable)x$2 -> x$2.value())).map((Function1 & Serializable)validatedHeader -> validatedHeader))));
    }

    public Directive<F, String> validateXsrf(String xsrfHeader, String xsrfCookievalue, Option<String> xForwardedFor) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> xsrfHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).filter((Function1 & Serializable)hdr -> {
            String string = xsrfCookievalue;
            String string2 = hdr;
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
                this.log().error(new StringBuilder(78).append("XsrfCookie does not match Xsrf header, possible CSRF-Attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString());
                return HttpProblem$.MODULE$.badRequest("xsrf check failed", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        });
    }

    public Directive<F, String> xsrfHeader(Option<String> xForwardedFor) {
        return this.request().header("x-xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> Directive$.MODULE$.getOrElseF(header, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            this.log().error("No x-xsrf-token header, possible CSRF-attack!");
            return HttpProblem$.MODULE$.badRequest(new StringBuilder(47).append("No x-xsrf-token header found. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString(), HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfToken -> xsrfToken.value()));
    }

    public Directive<F, String> xsrfCookie() {
        return this.request().cookie("xsrf-token", this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> this.request().header("X-Forwarded-For", $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)xForwardedfor -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            this.log().error(new StringBuilder(42).append("No xsrf-cookie, possible CSRF-Attack from ").append(xForwardedfor.map((Function1 & Serializable)x$3 -> x$3.value()).getOrElse((Function0 & Serializable)() -> "")).toString());
            return HttpProblem$.MODULE$.badRequest("No xsrf-token cookie found", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)xsrfCookie -> xsrfCookie.content())));
    }

    public Directive<F, OidcAuthenticatedUser> userSession(RequestCookie cookie) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getSession(cookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            this.log().warn("Could not extract user profile: {}, session timed out");
            return this.responses().unauthorizedResponse((Option)new Some((Object)"Could not extract user profile from the cookie"), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
    }

    public String createAuth0Url(String state, URI auth0CallbackUrl) {
        return new AuthAPI(this.authConfig().issuer(), this.authConfig().clientId(), this.authConfig().clientSecret()).authorizeUrl(auth0CallbackUrl.toString()).withScope("openid profile email").withState(state).withResponseType("code").build();
    }

    public Directive<F, State> validateState(RequestCookie stateCookie, String state, Option<String> xForwardedFor) {
        return Directive$.MODULE$.getOrElseF(this.sessionStore().getState(stateCookie.content()), Sync$.MODULE$.apply(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
            this.log().error(new StringBuilder(63).append("Invalid state, possible CSRF-attack on login. X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).toString());
            return HttpProblem$.MODULE$.badRequest("Invalid state, possible csrf-attack", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).withFilter((Function1 & Serializable)sessionState -> {
            String string = state;
            String string2 = sessionState.state();
            return this.FilterSyntax(!(string != null ? !string.equals(string2) : string2 != null)).orF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> {
                this.log().error(new StringBuilder(69).append("State values does not match, possible XSRF-attack! X-Forwarded-For: ").append(xForwardedFor.getOrElse((Function0 & Serializable)() -> "")).append(" ").toString());
                return HttpProblem$.MODULE$.badRequest("Illegal state value", HttpProblem$.MODULE$.badRequest$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            }), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        }).map((Function1 & Serializable)sessionState -> sessionState);
    }

    public boolean isReturnUrlWhitelisted(URI uri) {
        return this.authConfig().returnToUrlDomainWhitelist().contains((Object)uri.getHost());
    }

    public Directive<F, RequestCookie> sessionCookie() {
        return this.request().cookie(this.authConfig().cookieName(), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)maybeCookie -> Directive$.MODULE$.getOrElseF(maybeCookie, Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> HttpProblem$.MODULE$.unauthorized("Session cookie not found. Please login", HttpProblem$.MODULE$.unauthorized$default$2()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)cookie -> cookie));
    }

    public Directive<F, TokenResponse> fetchTokenFromAuth0(String code, URI auth0CallbackUrl) {
        Uri tokenUrl = Uri$.MODULE$.unsafeFromString(this.authConfig().issuer()).$div("oauth").$div("token");
        MediaType jsonMediaType = MediaType$.MODULE$.application().json();
        TokenRequest payload = new TokenRequest("authorization_code", this.authConfig().clientId(), this.authConfig().clientSecret(), code, auth0CallbackUrl);
        EntityEncoder jsonEncoder = org.http4s.circe.package$.MODULE$.jsonEncoderOf(this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1, TokenRequest$.MODULE$.tokenRequestEncoder());
        Request req = (Request)Request$.MODULE$.apply((Method)Method$.MODULE$.POST(), tokenUrl, Request$.MODULE$.apply$default$3(), Request$.MODULE$.apply$default$4(), Request$.MODULE$.apply$default$5(), Request$.MODULE$.apply$default$6()).withContentType(Content$minusType$.MODULE$.apply(jsonMediaType, Charset$.MODULE$.UTF$minus8())).withEntity((Object)payload, jsonEncoder);
        Object res = this.client.use((Function1 & Serializable)c -> c.fetch(req, (Function1 & Serializable)res -> res.attemptAs(EntityDecoder$.MODULE$.text($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1, EntityDecoder$.MODULE$.text$default$2())).fold((Function1 & Serializable)x$4 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)None$.MODULE$), (Function1 & Serializable)s -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)res.status()), (Object)new Some(s)), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1)), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)new EitherT(package.functor$.MODULE$.toFunctorOps(res, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Status status = (Status)tuple2._1();
            Option maybeBody = (Option)tuple2._2();
            Status status2 = status;
            Status status3 = Status$.MODULE$.Ok();
            Either either = !(status2 != null ? !status2.equals(status3) : status3 != null) ? maybeBody.toRight((Function0 & Serializable)() -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"No data received from IdP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}))).flatMap((Function1 & Serializable)x$5 -> package$.MODULE$.decode(x$5, TokenResponse$.MODULE$.tokenResponseDecoder()).left().map((Function1 & Serializable)e -> {
                this.log().error("Error parsing token from auth0 {}. Payload : {}", (Object[])((IterableOnceOps)new .colon.colon(e, (List)new .colon.colon(maybeBody.getOrElse((Function0 & Serializable)() -> ""), (List)Nil$.MODULE$))).toArray(ClassTag$.MODULE$.apply(Object.class)));
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Error parsing token from auth0", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())}));
            })) : scala.package$.MODULE$.Left().apply((Object)Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{package.KeyOps$.MODULE$.$colon$eq$extension(io.circe.syntax.package$.MODULE$.KeyOps((Object)"msg"), (Object)"Invalid response from IDP", Encoder$.MODULE$.encodeString(), KeyEncoder$.MODULE$.encodeKeyString())})));
            return either;
        })), (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toSuccess((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError("Internal Server Error", (Option)None$.MODULE$, (Option)new Some(failure)).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public Directive<F, OidcAuthenticatedUser> verifyTokenAndGetOidcUser(TokenResponse tokenResponse, JwkProvider jwkProvider) {
        DecodedJWT decodedJwt = JWT.decode((String)tokenResponse.idToken());
        String decodedHeaderString = Auth0OidcSecurityContext.decodeBase64$1(decodedJwt.getHeader());
        Either decodedEitherHeader = package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()).left().map((Function1 & Serializable)x$6 -> x$6.getMessage());
        EitherT eitherUser = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), decodedEitherHeader, this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)header -> EitherT$.MODULE$.liftF(Sync$.MODULE$.apply($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).delay((Function0 & Serializable)() -> (RSAPublicKey)jwkProvider.get(header.kid()).getPublicKey()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)publicKey -> {
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)TokenVerifier$.MODULE$.createPublicKeyProvider((RSAPublicKey)publicKey));
            return new Tuple2(publicKey, (Object)alg);
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).flatMap((Function1 & Serializable)x$7 -> {
            Tuple2 tuple2 = x$7;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Algorithm alg = (Algorithm)tuple2._2();
            EitherT eitherT = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), TokenVerifier$.MODULE$.validateIdToken(alg, this.authConfig().issuer(), this.authConfig().clientId(), tokenResponse.idToken()), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)oidcUser -> oidcUser, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
            return eitherT;
        }, $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1);
        return this.EitherTDirectives((EitherT)eitherUser, (Monad<F>)this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).toSuccess((Function1 & Serializable)failure -> Directive$.MODULE$.failure((Function0 & Serializable)() -> HttpProblem$.MODULE$.internalServerError(failure, HttpProblem$.MODULE$.internalServerError$default$2(), HttpProblem$.MODULE$.internalServerError$default$3()).toResponse($this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1), $this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1));
    }

    public F randomString(int lengthInBytes, RandomProvider<F> randomProvider) {
        return (F)package.functor$.MODULE$.toFunctorOps(randomProvider.nextBytes(lengthInBytes), this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1).map((Function1 & Serializable)x$8 -> x$8.toHex());
    }

    private final void Cookies$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.Cookies$module == null) {
                this.Cookies$module = new Auth0OidcSecurityContext$Cookies$(this);
            }
        }
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0OidcSecurityContext auth0OidcSecurityContext = this;
        synchronized (auth0OidcSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    private static final String decodeBase64$1(String value) {
        return (String)BitVector$.MODULE$.fromValidBase64(value, BitVector$.MODULE$.fromValidBase64$default$2()).decodeUtf8().getOrElse((Function0 & Serializable)() -> "");
    }

    public Auth0OidcSecurityContext(AuthConfig authConfig, SessionStore<F, OidcAuthenticatedUser> sessionStore, Resource<F, Client<F>> client, Function1<OidcAuthenticatedUser, F> lookup, Sync<F> evidence$1) {
        this.authConfig = authConfig;
        this.sessionStore = sessionStore;
        this.client = client;
        this.lookup = lookup;
        this.io$unsecurity$auth$auth0$oidc$Auth0OidcSecurityContext$$evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.log = LoggerFactory.getLogger(Auth0OidcSecurityContext.class);
    }
}

