/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.m2m;

import cats.Monad;
import cats.data.EitherT;
import cats.data.OptionT;
import cats.effect.Sync;
import cats.kernel.Eq;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.parser.package$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.m2m.JwtToken;
import io.unsecurity.auth.auth0.m2m.JwtToken$;
import io.unsecurity.auth.auth0.m2m.OauthAuthenticatedApplication;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import okio.ByteString;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u000b\u0017\u0001\u0005B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\f\u0001B\u0001B\u0003%a\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!!\u0007AaA!\u0002\u0017)\u0007\"B7\u0001\t\u0003q\u0007b\u0002<\u0001\u0005\u0004%\ta\u001e\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003y\u0011\u001d\t\u0019\u0001\u0001C!\u0003\u000bAq!a\b\u0001\t\u0003\n\t\u0003C\u0004\u0002&\u0001!\t%a\n\t\u000f\u00055\u0002\u0001\"\u0003\u0002\"!9\u0011q\u0006\u0001\u0005\n\u0005E\u0002bBA%\u0001\u0011%\u00111\n\u0005\b\u0003s\u0002A\u0011BA>\u0011\u001d\t\t\t\u0001C\u0005\u0003\u0007Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002x\u0001!I!!0\t\u000f\u0005-\u0007\u0001\"\u0003\u0002N\"9\u0011\u0011\u001b\u0001\u0005\n\u0005M'aF!vi\"\u0004TJM'TK\u000e,(/\u001b;z\u0007>tG/\u001a=u\u0015\t9\u0002$A\u0002ne5T!!\u0007\u000e\u0002\u000b\u0005,H\u000f\u001b\u0019\u000b\u0005ma\u0012\u0001B1vi\"T!!\b\u0010\u0002\u0015Ut7/Z2ve&$\u0018PC\u0001 \u0003\tIwn\u0001\u0001\u0016\u0007\tz\u0003i\u0005\u0003\u0001G%\u0012\u0005C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\rE\u0003+W5Zt(D\u0001\u001d\u0013\taCDA\bTK\u000e,(/\u001b;z\u0007>tG/\u001a=u!\tqs\u0006\u0004\u0001\u0005\u000bA\u0002!\u0019A\u0019\u0003\u0003\u0019+\"AM\u001d\u0012\u0005M2\u0004C\u0001\u00135\u0013\t)TEA\u0004O_RD\u0017N\\4\u0011\u0005\u0011:\u0014B\u0001\u001d&\u0005\r\te.\u001f\u0003\u0006u=\u0012\rA\r\u0002\u0002?B\u0011A(P\u0007\u0002-%\u0011aH\u0006\u0002\u001e\u001f\u0006,H\u000f[!vi\",g\u000e^5dCR,G-\u00119qY&\u001c\u0017\r^5p]B\u0011a\u0006\u0011\u0003\u0006\u0003\u0002\u0011\rA\r\u0002\u0002+B\u0019!fQ\u0017\n\u0005\u0011c\"!D+og\u0016\u001cWO]5us>\u00038/\u0001\u0004m_>\\W\u000f\u001d\t\u0005I\u001d[\u0014*\u0003\u0002IK\tIa)\u001e8di&|g.\r\t\u0004]=R\u0005c\u0001\u0013L\u007f%\u0011A*\n\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0015\u0005,H\u000f\u001b#p[\u0006Lg\u000e\u0005\u0002P-:\u0011\u0001\u000b\u0016\t\u0003#\u0016j\u0011A\u0015\u0006\u0003'\u0002\na\u0001\u0010:p_Rt\u0014BA+&\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U+\u0013\u0001C1vI&,gnY3\u0002\u0017)<8\u000e\u0015:pm&$WM\u001d\t\u00039\nl\u0011!\u0018\u0006\u0003=~\u000b1A[<l\u0015\tI\u0002MC\u0001b\u0003\r\u0019w.\\\u0005\u0003Gv\u00131BS<l!J|g/\u001b3fe\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\u0007\u0019\\W&D\u0001h\u0015\tA\u0017.\u0001\u0004fM\u001a,7\r\u001e\u0006\u0002U\u0006!1-\u0019;t\u0013\tawM\u0001\u0003Ts:\u001c\u0017A\u0002\u001fj]&$h\bF\u0003peN$X\u000f\u0006\u0002qcB!A\bA\u0017@\u0011\u0015!g\u0001q\u0001f\u0011\u0015)e\u00011\u0001G\u0011\u0015ie\u00011\u0001O\u0011\u0015If\u00011\u0001O\u0011\u0015Qf\u00011\u0001\\\u0003\rawnZ\u000b\u0002qB\u0011\u0011P`\u0007\u0002u*\u00111\u0010`\u0001\u0006g24GG\u001b\u0006\u0002{\u0006\u0019qN]4\n\u0005}T(A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013\u0001D1vi\",g\u000e^5dCR,WCAA\u0004!\u0019\tI!a\u0007.w5\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0006eSJ,7\r^5wKNTA!!\u0005\u0002\u0014\u00051\u0001\u000e\u001e;qiMTA!!\u0006\u0002\u0018\u0005A1oY1mC\nLgN\u0003\u0002\u0002\u001a\u0005\u0011an\\\u0005\u0005\u0003;\tYAA\u0005ESJ,7\r^5wK\u0006I\u0001p\u001d:g\u0007\",7m[\u000b\u0003\u0003G\u0001b!!\u0003\u0002\u001c5r\u0015!\u0004;sC:\u001chm\u001c:n+N,'\u000fF\u0002J\u0003SAa!a\u000b\f\u0001\u0004Y\u0014a\u0002:boV\u001bXM]\u0001\u0011e\u0016\fX/Z:u\u0003V$\b\u000eV8lK:\f!\u0002Z3d_\u0012,GMS,U)\u0011\t\u0019$!\u0012\u0011\u000f\u0005%\u00111D\u0017\u00026A!\u0011qGA!\u001b\t\tID\u0003\u0003\u0002<\u0005u\u0012AC5oi\u0016\u0014h-Y2fg*\u0019\u0011qH0\u0002\u0007)<H/\u0003\u0003\u0002D\u0005e\"A\u0003#fG>$W\r\u001a&X)\"1\u0011qI\u0007A\u00029\u000bQ\u0001^8lK:\f\u0011B[<u\u0011\u0016\fG-\u001a:\u0015\t\u00055\u0013Q\u000f\t\b\u0003\u0013\tY\"LA(!\u0011\t\t&a\u001c\u000f\t\u0005M\u0013\u0011\u000e\b\u0005\u0003+\n)G\u0004\u0003\u0002X\u0005\rd\u0002BA-\u0003CrA!a\u0017\u0002`9\u0019\u0011+!\u0018\n\u0003}I!!\b\u0010\n\u0005ma\u0012BA\r\u001b\u0013\r\t9\u0007G\u0001\u0005_&$7-\u0003\u0003\u0002l\u00055\u0014a\u0001&xi*\u0019\u0011q\r\r\n\t\u0005E\u00141\u000f\u0002\n\u0015^$\b*Z1eKJTA!a\u001b\u0002n!9\u0011q\u000f\bA\u0002\u0005U\u0012\u0001\u00036xiR{7.\u001a8\u0002\u0019\u0011,7m\u001c3f\u0005\u0006\u001cXM\u000e\u001b\u0015\t\u0005\r\u0012Q\u0010\u0005\u0007\u0003\u007fz\u0001\u0019\u0001(\u0002\u000bY\fG.^3\u0002/\r\u0014X-\u0019;f!V\u0014G.[2LKf\u0004&o\u001c<jI\u0016\u0014H\u0003BAC\u0003\u0017\u0003B!a\u000e\u0002\b&!\u0011\u0011RA\u001d\u00059\u00116+Q&fsB\u0013xN^5eKJDq!!$\u0011\u0001\u0004\ty)A\u0005qk\nd\u0017nY&fsB!\u0011\u0011SAO\u001b\t\t\u0019J\u0003\u0003\u0002<\u0005U%\u0002BAL\u00033\u000b\u0001b]3dkJLG/\u001f\u0006\u0003\u00037\u000bAA[1wC&!\u0011qTAJ\u00051\u00116+\u0011)vE2L7mS3z\u0003E1XM]5gs\u0006\u001b7-Z:t)>\\WM\u001c\u000b\t\u0003g\t)+!.\u0002:\"9\u0011qU\tA\u0002\u0005%\u0016aA1mOB!\u00111VAY\u001b\t\tiK\u0003\u0003\u00020\u0006u\u0012AC1mO>\u0014\u0018\u000e\u001e5ng&!\u00111WAW\u0005%\tEnZ8sSRDW\u000e\u0003\u0004\u00028F\u0001\rAT\u0001\fC\u000e\u001cWm]:U_.,g\u000e\u0003\u0004\u0002<F\u0001\rAT\u0001\u000eCR$X-\u001c9uK\u0012\u0004\u0016\r\u001e5\u0015\t\u0005}\u0016q\u0019\t\b\u0003\u0013\tY\"LAa!\ra\u00141Y\u0005\u0004\u0003\u000b4\"\u0001\u0003&xiR{7.\u001a8\t\u000f\u0005%'\u00031\u0001\u00026\u0005ia/\u001a:jM&,G\rV8lK:\fqb\u00195fG.,\u0005\u0010]5sCRLwN\u001c\u000b\u0005\u0003G\ty\rC\u0004\u0002xM\u0001\r!!1\u0002\u001d\u0015DHO]1diB\u0013xNZ5mKR!\u0011qAAk\u0011\u001d\t9\b\u0006a\u0001\u0003\u0003\u0004")
public class Auth0M2MSecurityContext<F, U>
implements SecurityContext<F, OauthAuthenticatedApplication, U>,
UnsecurityOps<F> {
    private final Function1<OauthAuthenticatedApplication, F> lookup;
    private final String authDomain;
    private final String audience;
    private final JwkProvider jwkProvider;
    private final Sync<F> evidence$1;
    private final Logger log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public Logger log() {
        return this.log;
    }

    public Directive<F, OauthAuthenticatedApplication> authenticate() {
        return this.request().path(this.evidence$1).flatMap((Function1 & Serializable)attemptedPath -> this.requestAuthToken().flatMap((Function1 & Serializable)requestAuthToken -> this.decodedJWT((String)requestAuthToken).flatMap((Function1 & Serializable)decodedJWT -> this.jwtHeader((DecodedJWT)decodedJWT).map((Function1 & Serializable)jwtHeader -> {
            RSAPublicKey publicKey = (RSAPublicKey)$this.jwkProvider.get(jwtHeader.kid()).getPublicKey();
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(publicKey));
            return new Tuple3(jwtHeader, (Object)publicKey, (Object)alg);
        }).flatMap((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Algorithm alg = (Algorithm)tuple3._3();
            Directive directive = this.verifyAccessToken(alg, (String)requestAuthToken, (String)attemptedPath).flatMap((Function1 & Serializable)verifiedToken -> this.jwtToken((DecodedJWT)verifiedToken).flatMap((Function1 & Serializable)jwtToken -> this.checkExpiration((JwtToken)jwtToken).flatMap((Function1 & Serializable)x$1 -> {
                String string = x$1;
                Directive directive = this.extractProfile((JwtToken)jwtToken).map((Function1 & Serializable)userProfile -> userProfile);
                return directive;
            })));
            return directive;
        }))));
    }

    public Directive<F, String> xsrfCheck() {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> "", this.evidence$1);
    }

    public F transformUser(OauthAuthenticatedApplication rawUser) {
        return (F)this.lookup.apply((Object)rawUser);
    }

    private Directive<F, String> requestAuthToken() {
        return this.request().header("authorization", this.evidence$1).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])header.value().split(" ")))), (Monad)$this.evidence$1).toSuccess(this.Unauthorized("Authorization header not found. Please log in", $this.evidence$1)).map((Function1 & Serializable)token -> token));
    }

    private Directive<F, DecodedJWT> decodedJWT(String token) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            this.log().warn("Could not extract token from request", throwable);
            return this.Unauthorized("Could not extract token from request", $this.evidence$1);
        });
    }

    private Directive<F, Jwt.JwtHeader> jwtHeader(DecodedJWT jwtToken) {
        return this.decodeBase64(jwtToken.getHeader()).flatMap((Function1 & Serializable)decodedHeaderString -> this.EitherDirectives((Either)package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)error -> {
            this.log().warn("Could not decode jwt header", (Throwable)error);
            return this.Unauthorized("Could not decode jwt header", $this.evidence$1);
        }).map((Function1 & Serializable)header -> header));
    }

    private Directive<F, String> decodeBase64(String value) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> ByteString.decodeBase64((String)value).utf8(), this.evidence$1);
    }

    private RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(null, publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    private Directive<F, DecodedJWT> verifyAccessToken(Algorithm alg, String accessToken, String attemptedPath) {
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{new StringBuilder(9).append("https://").append(this.authDomain).append("/").toString()}).withAudience(new String[]{this.audience}).build();
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> verifier.verify(accessToken)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            this.log().warn(new StringBuilder(33).append("Could not verify token for path: ").append(attemptedPath).toString(), throwable);
            return this.Unauthorized("Could not verify token", $this.evidence$1);
        });
    }

    private Directive<F, JwtToken> jwtToken(DecodedJWT verifiedToken) {
        return this.decodeBase64(verifiedToken.getPayload()).flatMap((Function1 & Serializable)base64Token -> this.EitherDirectives((Either)package$.MODULE$.decode(base64Token, JwtToken$.MODULE$.jwtTokenDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)decodeError -> {
            this.log().warn(new StringBuilder(30).append("Unable to decode JWT payload: ").append(decodeError).toString());
            return this.Unauthorized("Unable to decode JWT payload", $this.evidence$1);
        }).map((Function1 & Serializable)jwtToken -> jwtToken));
    }

    private Directive<F, String> checkExpiration(JwtToken jwtToken) {
        OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(jwtToken.exp()).atOffset(ZoneOffset.UTC));
        OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
        return now.isAfter(expirationTime) ? this.Unauthorized(new StringBuilder(44).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).toString(), this.evidence$1) : Directive$.MODULE$.success((Function0 & Serializable)() -> "Valid token", this.evidence$1);
    }

    private Directive<F, OauthAuthenticatedApplication> extractProfile(JwtToken jwtToken) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> new OauthAuthenticatedApplication(jwtToken.sub(), jwtToken.scopes()), this.evidence$1);
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    public Auth0M2MSecurityContext(Function1<OauthAuthenticatedApplication, F> lookup, String authDomain, String audience, JwkProvider jwkProvider, Sync<F> evidence$1) {
        this.lookup = lookup;
        this.authDomain = authDomain;
        this.audience = audience;
        this.jwkProvider = jwkProvider;
        this.evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.log = LoggerFactory.getLogger(Auth0M2MSecurityContext.class);
    }
}

