/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.m2m;

import cats.Monad;
import cats.data.EitherT;
import cats.data.OptionT;
import cats.effect.Sync;
import cats.kernel.Eq;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.parser.package$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.m2m.JwtToken;
import io.unsecurity.auth.auth0.m2m.JwtToken$;
import io.unsecurity.auth.auth0.m2m.OauthAuthenticatedApplication;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import okio.ByteString;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.headers.Authorization$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ug\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%Q\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0019\u0007AaA!\u0002\u0017!\u0007\"\u00027\u0001\t\u0003i\u0007BB;\u0001A\u0003%a\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!A\u0011q\u0005\u0001\u0005\u0002m\tY\u0002C\u0004\u0002*\u0001!I!a\u000b\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u00111\u000f\u0001\u0005\n\u0005U\u0004bBA>\u0001\u0011%\u0011Q\u0010\u0005\b\u00037\u0003A\u0011BAO\u0011\u001d\t\t\b\u0001C\u0005\u0003oCq!!2\u0001\t\u0013\t9\rC\u0004\u0002L\u0002!I!!4\u0003/\u0005+H\u000f\u001b\u0019Ne5\u001bVmY;sSRL8i\u001c8uKb$(B\u0001\f\u0018\u0003\ri''\u001c\u0006\u00031e\tQ!Y;uQBR!AG\u000e\u0002\t\u0005,H\u000f\u001b\u0006\u00039u\t!\"\u001e8tK\u000e,(/\u001b;z\u0015\u0005q\u0012AA5p\u0007\u0001)2!\t\u0018@'\u0011\u0001!\u0005K!\u0011\u0005\r2S\"\u0001\u0013\u000b\u0003\u0015\nQa]2bY\u0006L!a\n\u0013\u0003\r\u0005s\u0017PU3g!\u0015I#\u0006\f\u001e?\u001b\u0005Y\u0012BA\u0016\u001c\u0005=\u0019VmY;sSRL8i\u001c8uKb$\bCA\u0017/\u0019\u0001!Qa\f\u0001C\u0002A\u0012\u0011AR\u000b\u0003ca\n\"AM\u001b\u0011\u0005\r\u001a\u0014B\u0001\u001b%\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"a\t\u001c\n\u0005]\"#aA!os\u0012)\u0011H\fb\u0001c\t\tq\f\u0005\u0002<y5\tQ#\u0003\u0002>+\tir*Y;uQ\u0006+H\u000f[3oi&\u001c\u0017\r^3e\u0003B\u0004H.[2bi&|g\u000e\u0005\u0002.\u007f\u0011)\u0001\t\u0001b\u0001c\t\tQ\u000bE\u0002*\u00052J!aQ\u000e\u0003\u001bUs7/Z2ve&$\u0018p\u00149t\u0003\u0019awn\\6vaB!1E\u0012\u001eI\u0013\t9EEA\u0005Gk:\u001cG/[8ocA\u0019QFL%\u0011\u0007\rRe(\u0003\u0002LI\t1q\n\u001d;j_:\fa![:tk\u0016\u0014\bC\u0001(V\u001d\ty5\u000b\u0005\u0002QI5\t\u0011K\u0003\u0002S?\u00051AH]8pizJ!\u0001\u0016\u0013\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)\u0012\n\u0001\"Y;eS\u0016t7-Z\u0001\fU^\\\u0007K]8wS\u0012,'\u000f\u0005\u0002\\C6\tAL\u0003\u0002^=\u0006\u0019!n^6\u000b\u0005ay&\"\u00011\u0002\u0007\r|W.\u0003\u0002c9\nY!j^6Qe>4\u0018\u000eZ3s\u0003))g/\u001b3f]\u000e,G%\r\t\u0004K*dS\"\u00014\u000b\u0005\u001dD\u0017AB3gM\u0016\u001cGOC\u0001j\u0003\u0011\u0019\u0017\r^:\n\u0005-4'\u0001B*z]\u000e\fa\u0001P5oSRtD#\u00028reN$HCA8q!\u0011Y\u0004\u0001\f \t\u000b\r4\u00019\u00013\t\u000b\u00113\u0001\u0019A#\t\u000b13\u0001\u0019A'\t\u000ba3\u0001\u0019A'\t\u000be3\u0001\u0019\u0001.\u0002\u00071|w\r\u0005\u0002xy6\t\u0001P\u0003\u0002zu\u0006)An\\45g*\t10A\u0002pe\u001eL!! =\u0003\r1{wmZ3s\u00031\tW\u000f\u001e5f]RL7-\u0019;f+\t\t\t\u0001\u0005\u0004\u0002\u0004\u0005UAFO\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005QA-\u001b:fGRLg/Z:\u000b\t\u0005-\u0011QB\u0001\u0007QR$\b\u000fN:\u000b\t\u0005=\u0011\u0011C\u0001\tg\u000e\fG.\u00192j]*\u0011\u00111C\u0001\u0003]>LA!a\u0006\u0002\u0006\tIA)\u001b:fGRLg/Z\u0001\nqN\u0014hm\u00115fG.,\"!!\b\u0011\r\u0005\r\u0011Q\u0003\u0017N\u00035!(/\u00198tM>\u0014X.V:feR\u0019\u0001*a\t\t\r\u0005\u0015\"\u00021\u0001;\u0003\u001d\u0011\u0018m^+tKJ\f\u0001C]3rk\u0016\u001cH/Q;uQR{7.\u001a8\u0002\u0015\u0011,7m\u001c3fI*;F\u000b\u0006\u0003\u0002.\u0005}\u0002cBA\u0002\u0003+a\u0013q\u0006\t\u0005\u0003c\tY$\u0004\u0002\u00024)!\u0011QGA\u001c\u0003)Ig\u000e^3sM\u0006\u001cWm\u001d\u0006\u0004\u0003sq\u0016a\u00016xi&!\u0011QHA\u001a\u0005)!UmY8eK\u0012Tu\u000b\u0016\u0005\u0007\u0003\u0003b\u0001\u0019A'\u0002\u000bQ|7.\u001a8\u0002\u0013)<H\u000fS3bI\u0016\u0014H\u0003BA$\u0003_\u0002r!a\u0001\u0002\u00161\nI\u0005\u0005\u0003\u0002L\u0005%d\u0002BA'\u0003GrA!a\u0014\u0002`9!\u0011\u0011KA/\u001d\u0011\t\u0019&a\u0017\u000f\t\u0005U\u0013\u0011\f\b\u0004!\u0006]\u0013\"\u0001\u0010\n\u0005qi\u0012B\u0001\u000e\u001c\u0013\tA\u0012$C\u0002\u0002b]\tAa\\5eG&!\u0011QMA4\u0003\rQu\u000f\u001e\u0006\u0004\u0003C:\u0012\u0002BA6\u0003[\u0012\u0011BS<u\u0011\u0016\fG-\u001a:\u000b\t\u0005\u0015\u0014q\r\u0005\b\u0003cj\u0001\u0019AA\u0018\u0003!Qw\u000f\u001e+pW\u0016t\u0017\u0001\u00043fG>$WMQ1tKZ\"D\u0003BA\u000f\u0003oBa!!\u001f\u000f\u0001\u0004i\u0015!\u0002<bYV,\u0017aF2sK\u0006$X\rU;cY&\u001c7*Z=Qe>4\u0018\u000eZ3s)\u0011\ty(!\"\u0011\t\u0005E\u0012\u0011Q\u0005\u0005\u0003\u0007\u000b\u0019D\u0001\bS'\u0006[U-\u001f)s_ZLG-\u001a:\t\u000f\u0005\u001du\u00021\u0001\u0002\n\u0006I\u0001/\u001e2mS\u000e\\U-\u001f\t\u0005\u0003\u0017\u000b9*\u0004\u0002\u0002\u000e*!\u0011QGAH\u0015\u0011\t\t*a%\u0002\u0011M,7-\u001e:jifT!!!&\u0002\t)\fg/Y\u0005\u0005\u00033\u000biI\u0001\u0007S'\u0006\u0003VO\u00197jG.+\u00170A\twKJLg-_!dG\u0016\u001c8\u000fV8lK:$\u0002\"!\f\u0002 \u0006=\u00161\u0017\u0005\b\u0003C\u0003\u0002\u0019AAR\u0003\r\tGn\u001a\t\u0005\u0003K\u000bY+\u0004\u0002\u0002(*!\u0011\u0011VA\u001c\u0003)\tGnZ8sSRDWn]\u0005\u0005\u0003[\u000b9KA\u0005BY\u001e|'/\u001b;i[\"1\u0011\u0011\u0017\tA\u00025\u000b1\"Y2dKN\u001cHk\\6f]\"1\u0011Q\u0017\tA\u00025\u000bQ\"\u0019;uK6\u0004H/\u001a3QCRDG\u0003BA]\u0003\u0003\u0004r!a\u0001\u0002\u00161\nY\fE\u0002<\u0003{K1!a0\u0016\u0005!Qu\u000f\u001e+pW\u0016t\u0007bBAb#\u0001\u0007\u0011qF\u0001\u000em\u0016\u0014\u0018NZ5fIR{7.\u001a8\u0002\u001f\rDWmY6FqBL'/\u0019;j_:$B!!\b\u0002J\"9\u0011\u0011\u000f\nA\u0002\u0005m\u0016AD3yiJ\f7\r\u001e)s_\u001aLG.\u001a\u000b\u0007\u0003\u0003\ty-!5\t\u000f\u0005E4\u00031\u0001\u0002<\"1\u00111[\nA\u00025\u000b\u0001B]1x)>\\WM\u001c")
public class Auth0M2MSecurityContext<F, U>
implements SecurityContext<F, OauthAuthenticatedApplication, U>,
UnsecurityOps<F> {
    private final Function1<OauthAuthenticatedApplication, F> lookup;
    private final String issuer;
    private final String audience;
    private final JwkProvider jwkProvider;
    private final Sync<F> evidence$1;
    private final Logger log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public Directive<F, OauthAuthenticatedApplication> authenticate() {
        return this.request().path(this.evidence$1).flatMap((Function1 & Serializable)attemptedPath -> this.requestAuthToken().flatMap((Function1 & Serializable)requestAuthToken -> this.decodedJWT((String)requestAuthToken).flatMap((Function1 & Serializable)decodedJWT -> this.jwtHeader((DecodedJWT)decodedJWT).map((Function1 & Serializable)jwtHeader -> {
            RSAPublicKey publicKey = (RSAPublicKey)$this.jwkProvider.get(jwtHeader.kid()).getPublicKey();
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(publicKey));
            return new Tuple3(jwtHeader, (Object)publicKey, (Object)alg);
        }).flatMap((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Algorithm alg = (Algorithm)tuple3._3();
            Directive directive = this.verifyAccessToken(alg, (String)requestAuthToken, (String)attemptedPath).flatMap((Function1 & Serializable)verifiedToken -> this.jwtToken((DecodedJWT)verifiedToken).flatMap((Function1 & Serializable)jwtToken -> this.checkExpiration((JwtToken)jwtToken).flatMap((Function1 & Serializable)x$1 -> {
                String string = x$1;
                Directive directive = this.extractProfile((JwtToken)jwtToken, (String)requestAuthToken).map((Function1 & Serializable)userProfile -> userProfile);
                return directive;
            })));
            return directive;
        }))));
    }

    public Directive<F, String> xsrfCheck() {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> "", this.evidence$1);
    }

    public F transformUser(OauthAuthenticatedApplication rawUser) {
        return (F)this.lookup.apply((Object)rawUser);
    }

    public Directive<F, String> requestAuthToken() {
        return this.request().headers(this.evidence$1).map((Function1 & Serializable)x$3 -> Headers$.MODULE$.toList$extension(((Headers)x$3).org$http4s$Headers$$headers())).map((Function1 & Serializable)x$4 -> x$4.find((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)Auth0M2MSecurityContext.$anonfun$requestAuthToken$3(h)))).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])header.value().split(" ")))), (Monad)$this.evidence$1).toSuccess(this.Unauthorized("Authorization header not found. Please log in", $this.evidence$1)).map((Function1 & Serializable)token -> token));
    }

    private Directive<F, DecodedJWT> decodedJWT(String token) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            $this.log.warn("Could not extract token from request", throwable);
            return this.Unauthorized("Could not extract token from request", $this.evidence$1);
        });
    }

    private Directive<F, Jwt.JwtHeader> jwtHeader(DecodedJWT jwtToken) {
        return this.decodeBase64(jwtToken.getHeader()).flatMap((Function1 & Serializable)decodedHeaderString -> this.EitherDirectives((Either)package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)error -> {
            $this.log.warn("Could not decode jwt header", (Throwable)error);
            return this.Unauthorized("Could not decode jwt header", $this.evidence$1);
        }).map((Function1 & Serializable)header -> header));
    }

    private Directive<F, String> decodeBase64(String value) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> ByteString.decodeBase64((String)value).utf8(), this.evidence$1);
    }

    private RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(null, publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    private Directive<F, DecodedJWT> verifyAccessToken(Algorithm alg, String accessToken, String attemptedPath) {
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{this.issuer}).withAudience(new String[]{this.audience}).build();
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> verifier.verify(accessToken)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(33).append("Could not verify token for path: ").append(attemptedPath).toString(), throwable);
            }
            return this.Unauthorized("Could not verify token", $this.evidence$1);
        });
    }

    private Directive<F, JwtToken> jwtToken(DecodedJWT verifiedToken) {
        return this.decodeBase64(verifiedToken.getPayload()).flatMap((Function1 & Serializable)base64Token -> this.EitherDirectives((Either)package$.MODULE$.decode(base64Token, JwtToken$.MODULE$.jwtTokenDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)decodeError -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(30).append("Unable to decode JWT payload: ").append(decodeError).toString());
            }
            return this.Unauthorized("Unable to decode JWT payload", $this.evidence$1);
        }).map((Function1 & Serializable)jwtToken -> jwtToken));
    }

    private Directive<F, String> checkExpiration(JwtToken jwtToken) {
        OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(jwtToken.exp()).atOffset(ZoneOffset.UTC));
        OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
        return now.isAfter(expirationTime) ? this.Unauthorized(new StringBuilder(44).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).toString(), this.evidence$1) : Directive$.MODULE$.success((Function0 & Serializable)() -> "Valid token", this.evidence$1);
    }

    private Directive<F, OauthAuthenticatedApplication> extractProfile(JwtToken jwtToken, String rawToken) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> new OauthAuthenticatedApplication(jwtToken.sub(), jwtToken.scopes(), rawToken), this.evidence$1);
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestAuthToken$3(Header h) {
        return h.is((HeaderKey)Authorization$.MODULE$) && h.value().toLowerCase().contains("bearer");
    }

    public Auth0M2MSecurityContext(Function1<OauthAuthenticatedApplication, F> lookup, String issuer, String audience, JwkProvider jwkProvider, Sync<F> evidence$1) {
        this.lookup = lookup;
        this.issuer = issuer;
        this.audience = audience;
        this.jwkProvider = jwkProvider;
        this.evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.log = LoggerFactory.getLogger((String)"io.unsecurity.auth.auth0.m2m.Auth0M2MSecurityContext");
    }
}

