/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.m2m;

import cats.Monad;
import cats.data.EitherT;
import cats.data.OptionT;
import cats.effect.Sync;
import cats.kernel.Eq;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.parser.package$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.m2m.JwtToken;
import io.unsecurity.auth.auth0.m2m.JwtToken$;
import io.unsecurity.auth.auth0.m2m.OauthAuthenticatedApplication;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import okio.ByteString;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Headers;
import org.http4s.Headers$;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Uri;
import org.http4s.headers.Authorization$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005eg\u0001B\u000b\u0017\u0001\u0005B\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\"A\u0011\f\u0001B\u0001B\u0003%a\n\u0003\u0005[\u0001\t\u0005\t\u0015!\u0003\\\u0011!!\u0007AaA!\u0002\u0017)\u0007\"B7\u0001\t\u0003q\u0007B\u0002<\u0001A\u0003%q\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u00037\u0001A\u0011IA\u000f\u0011\u001d\t\t\u0003\u0001C!\u0003GA\u0001\"!\u000b\u0001\t\u0003a\u0012Q\u0004\u0005\t\u0003W\u0001A\u0011\u0001\u000f\u0002\u001e!9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002bBA$\u0001\u0011%\u0011\u0011\n\u0005\b\u0003o\u0002A\u0011BA=\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!a(\u0001\t\u0013\t\t\u000bC\u0004\u0002v\u0001!I!a/\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011q\u001a\u0001\u0005\n\u0005E'!I!vi\"\u0004TJM'P]\n+\u0007.\u00197g\u001f\u001a\u001cVmY;sSRL8i\u001c8uKb$(BA\f\u0019\u0003\ri''\u001c\u0006\u00033i\tQ!Y;uQBR!a\u0007\u000f\u0002\t\u0005,H\u000f\u001b\u0006\u0003;y\t!\"\u001e8tK\u000e,(/\u001b;z\u0015\u0005y\u0012AA5p\u0007\u0001)2AI\u0018A'\u0011\u00011%\u000b\"\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\u0015Q3&L\u001e@\u001b\u0005a\u0012B\u0001\u0017\u001d\u0005=\u0019VmY;sSRL8i\u001c8uKb$\bC\u0001\u00180\u0019\u0001!Q\u0001\r\u0001C\u0002E\u0012\u0011AR\u000b\u0003ee\n\"a\r\u001c\u0011\u0005\u0011\"\u0014BA\u001b&\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001J\u001c\n\u0005a*#aA!os\u0012)!h\fb\u0001e\t\tq\f\u0005\u0002={5\ta#\u0003\u0002?-\tir*Y;uQ\u0006+H\u000f[3oi&\u001c\u0017\r^3e\u0003B\u0004H.[2bi&|g\u000e\u0005\u0002/\u0001\u0012)\u0011\t\u0001b\u0001e\t\tQ\u000bE\u0002+\u00076J!\u0001\u0012\u000f\u0003\u001bUs7/Z2ve&$\u0018p\u00149t\u0003\u0019awn\\6vaB!AeR\u001eJ\u0013\tAUEA\u0005Gk:\u001cG/[8ocA\u0019af\f&\u0011\u0007\u0011Zu(\u0003\u0002MK\t1q\n\u001d;j_:\fa![:tk\u0016\u0014\bCA(W\u001d\t\u0001F\u000b\u0005\u0002RK5\t!K\u0003\u0002TA\u00051AH]8pizJ!!V\u0013\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+\u0016\n\u0001\"Y;eS\u0016t7-Z\u0001\fU^\\\u0007K]8wS\u0012,'\u000f\u0005\u0002]E6\tQL\u0003\u0002_?\u0006\u0019!n^6\u000b\u0005e\u0001'\"A1\u0002\u0007\r|W.\u0003\u0002d;\nY!j^6Qe>4\u0018\u000eZ3s\u0003))g/\u001b3f]\u000e,G%\r\t\u0004M.lS\"A4\u000b\u0005!L\u0017AB3gM\u0016\u001cGOC\u0001k\u0003\u0011\u0019\u0017\r^:\n\u00051<'\u0001B*z]\u000e\fa\u0001P5oSRtD#B8sgR,HC\u00019r!\u0011a\u0004!L \t\u000b\u00114\u00019A3\t\u000b\u00153\u0001\u0019\u0001$\t\u000b53\u0001\u0019\u0001(\t\u000be3\u0001\u0019\u0001(\t\u000bi3\u0001\u0019A.\u0002\u00071|w\r\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006)An\\45g*\tA0A\u0002pe\u001eL!A`=\u0003\r1{wmZ3s\u00031\tW\u000f\u001e5f]RL7-\u0019;f+\t\t\u0019\u0001\u0005\u0004\u0002\u0006\u0005]QfO\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005QA-\u001b:fGRLg/Z:\u000b\t\u00055\u0011qB\u0001\u0007QR$\b\u000fN:\u000b\t\u0005E\u00111C\u0001\tg\u000e\fG.\u00192j]*\u0011\u0011QC\u0001\u0003]>LA!!\u0007\u0002\b\tIA)\u001b:fGRLg/Z\u0001\nqN\u0014hm\u00115fG.,\"!a\b\u0011\r\u0005\u0015\u0011qC\u0017O\u00035!(/\u00198tM>\u0014X.V:feR\u0019\u0011*!\n\t\r\u0005\u001d\"\u00021\u0001<\u0003\u001d\u0011\u0018m^+tKJ\faC]3rk\u0016\u001cH/Q;uQ\n+\u0017M]3s)>\\WM\\\u0001\u001be\u0016\fX/Z:u\u0003V$\bn\u00148CK\"\fGNZ(g)>\\WM\\\u0001\u000bI\u0016\u001cw\u000eZ3e\u0015^#F\u0003BA\u0019\u0003\u0007\u0002r!!\u0002\u0002\u00185\n\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\u0015%tG/\u001a:gC\u000e,7OC\u0002\u0002>}\u000b1A[<u\u0013\u0011\t\t%a\u000e\u0003\u0015\u0011+7m\u001c3fI*;F\u000b\u0003\u0004\u0002F5\u0001\rAT\u0001\u0006i>\\WM\\\u0001\nU^$\b*Z1eKJ$B!a\u0013\u0002tA9\u0011QAA\f[\u00055\u0003\u0003BA(\u0003[rA!!\u0015\u0002h9!\u00111KA2\u001d\u0011\t)&!\u0019\u000f\t\u0005]\u0013q\f\b\u0005\u00033\niFD\u0002R\u00037J\u0011aH\u0005\u0003;yI!a\u0007\u000f\n\u0005eQ\u0012bAA31\u0005!q.\u001b3d\u0013\u0011\tI'a\u001b\u0002\u0007);HOC\u0002\u0002faIA!a\u001c\u0002r\tI!j\u001e;IK\u0006$WM\u001d\u0006\u0005\u0003S\nY\u0007C\u0004\u0002v9\u0001\r!a\r\u0002\u0011)<H\u000fV8lK:\fA\u0002Z3d_\u0012,')Y:fmQ\"B!a\b\u0002|!1\u0011QP\bA\u00029\u000bQA^1mk\u0016\fqc\u0019:fCR,\u0007+\u001e2mS\u000e\\U-\u001f)s_ZLG-\u001a:\u0015\t\u0005\r\u0015\u0011\u0012\t\u0005\u0003k\t))\u0003\u0003\u0002\b\u0006]\"A\u0004*T\u0003.+\u0017\u0010\u0015:pm&$WM\u001d\u0005\b\u0003\u0017\u0003\u0002\u0019AAG\u0003%\u0001XO\u00197jG.+\u0017\u0010\u0005\u0003\u0002\u0010\u0006mUBAAI\u0015\u0011\tI$a%\u000b\t\u0005U\u0015qS\u0001\tg\u0016\u001cWO]5us*\u0011\u0011\u0011T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0006E%\u0001\u0004*T\u0003B+(\r\\5d\u0017\u0016L\u0018!\u0005<fe&4\u00170Q2dKN\u001cHk\\6f]RA\u0011\u0011GAR\u0003g\u000b9\fC\u0004\u0002&F\u0001\r!a*\u0002\u0007\u0005dw\r\u0005\u0003\u0002*\u0006=VBAAV\u0015\u0011\ti+a\u000f\u0002\u0015\u0005dwm\u001c:ji\"l7/\u0003\u0003\u00022\u0006-&!C!mO>\u0014\u0018\u000e\u001e5n\u0011\u0019\t),\u0005a\u0001\u001d\u0006Y\u0011mY2fgN$vn[3o\u0011\u0019\tI,\u0005a\u0001\u001d\u0006i\u0011\r\u001e;f[B$X\r\u001a)bi\"$B!!0\u0002FB9\u0011QAA\f[\u0005}\u0006c\u0001\u001f\u0002B&\u0019\u00111\u0019\f\u0003\u0011);H\u000fV8lK:Dq!a2\u0013\u0001\u0004\t\u0019$A\u0007wKJLg-[3e)>\\WM\\\u0001\u0010G\",7m[#ya&\u0014\u0018\r^5p]R!\u0011qDAg\u0011\u001d\t)h\u0005a\u0001\u0003\u007f\u000ba\"\u001a=ue\u0006\u001cG\u000f\u0015:pM&dW\r\u0006\u0004\u0002\u0004\u0005M\u0017Q\u001b\u0005\b\u0003k\"\u0002\u0019AA`\u0011\u0019\t9\u000e\u0006a\u0001\u001d\u0006A!/Y<U_.,g\u000e")
public class Auth0M2MOnBehalfOfSecurityContext<F, U>
implements SecurityContext<F, OauthAuthenticatedApplication, U>,
UnsecurityOps<F> {
    private final Function1<OauthAuthenticatedApplication, F> lookup;
    private final String issuer;
    private final String audience;
    private final JwkProvider jwkProvider;
    private final Sync<F> evidence$1;
    private final Logger log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public Directive<F, OauthAuthenticatedApplication> authenticate() {
        return this.request().path(this.evidence$1).flatMap((Function1 & Serializable)attemptedPath -> this.requestAuthBearerToken().flatMap((Function1 & Serializable)bearerRequestAuthToken -> this.decodedJWT((String)bearerRequestAuthToken).flatMap((Function1 & Serializable)bearerDecodedJWT -> this.jwtHeader((DecodedJWT)bearerDecodedJWT).map((Function1 & Serializable)bearerJwtHeader -> {
            RSAPublicKey bearerPublicKey = (RSAPublicKey)$this.jwkProvider.get(bearerJwtHeader.kid()).getPublicKey();
            Algorithm bearerAlg = Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(bearerPublicKey));
            return new Tuple3(bearerJwtHeader, (Object)bearerPublicKey, (Object)bearerAlg);
        }).flatMap((Function1 & Serializable)x$4 -> {
            Tuple3 tuple3 = x$4;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Algorithm bearerAlg = (Algorithm)tuple3._3();
            Directive directive = this.verifyAccessToken(bearerAlg, (String)bearerRequestAuthToken, (String)attemptedPath).flatMap((Function1 & Serializable)bearerVerifiedToken -> this.jwtToken((DecodedJWT)bearerVerifiedToken).flatMap((Function1 & Serializable)bearerJwtToken -> this.checkExpiration((JwtToken)bearerJwtToken).flatMap((Function1 & Serializable)x$3 -> {
                String string = x$3;
                Directive directive = this.requestAuthOnBehalfOfToken().flatMap((Function1 & Serializable)behalfOfRequestAuthToken -> this.decodedJWT((String)behalfOfRequestAuthToken).flatMap((Function1 & Serializable)behalfOfDecodedJWT -> this.jwtHeader((DecodedJWT)behalfOfDecodedJWT).map((Function1 & Serializable)behalfOfJwtHeader -> {
                    RSAPublicKey behalfOfPublicKey = (RSAPublicKey)$this.jwkProvider.get(behalfOfJwtHeader.kid()).getPublicKey();
                    Algorithm behalfOfAlg = Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(behalfOfPublicKey));
                    return new Tuple3(behalfOfJwtHeader, (Object)behalfOfPublicKey, (Object)behalfOfAlg);
                }).flatMap((Function1 & Serializable)x$2 -> {
                    Tuple3 tuple3 = x$2;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Algorithm behalfOfAlg = (Algorithm)tuple3._3();
                    Directive directive = this.verifyAccessToken(behalfOfAlg, (String)behalfOfRequestAuthToken, (String)attemptedPath).flatMap((Function1 & Serializable)behalfOfVerifiedToken -> this.jwtToken((DecodedJWT)behalfOfVerifiedToken).flatMap((Function1 & Serializable)behalfOfJwtToken -> this.checkExpiration((JwtToken)behalfOfJwtToken).flatMap((Function1 & Serializable)x$1 -> {
                        String string = x$1;
                        Directive directive = this.extractProfile((JwtToken)behalfOfJwtToken, (String)behalfOfRequestAuthToken).map((Function1 & Serializable)userProfile -> userProfile);
                        return directive;
                    })));
                    return directive;
                })));
                return directive;
            })));
            return directive;
        }))));
    }

    public Directive<F, String> xsrfCheck() {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> "", this.evidence$1);
    }

    public F transformUser(OauthAuthenticatedApplication rawUser) {
        return (F)this.lookup.apply((Object)rawUser);
    }

    public Directive<F, String> requestAuthBearerToken() {
        return this.request().headers(this.evidence$1).map((Function1 & Serializable)x$5 -> Headers$.MODULE$.toList$extension(((Headers)x$5).org$http4s$Headers$$headers())).map((Function1 & Serializable)x$6 -> x$6.find((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)Auth0M2MOnBehalfOfSecurityContext.$anonfun$requestAuthBearerToken$3(h)))).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])header.value().split(" ")))), (Monad)$this.evidence$1).toSuccess(this.Unauthorized("Authorization header not found. Please log in", $this.evidence$1)).map((Function1 & Serializable)token -> token));
    }

    public Directive<F, String> requestAuthOnBehalfOfToken() {
        return this.request().headers(this.evidence$1).map((Function1 & Serializable)x$7 -> Headers$.MODULE$.toList$extension(((Headers)x$7).org$http4s$Headers$$headers())).map((Function1 & Serializable)x$8 -> x$8.find((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)Auth0M2MOnBehalfOfSecurityContext.$anonfun$requestAuthOnBehalfOfToken$3(h)))).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])header.value().split(" ")))), (Monad)$this.evidence$1).toSuccess(this.Unauthorized("Missing Authorization header with scheme On-Behalf-Of ", $this.evidence$1)).map((Function1 & Serializable)token -> token));
    }

    private Directive<F, DecodedJWT> decodedJWT(String token) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            $this.log.warn("Could not extract token from request", throwable);
            return this.Unauthorized("Could not extract token from request", $this.evidence$1);
        });
    }

    private Directive<F, Jwt.JwtHeader> jwtHeader(DecodedJWT jwtToken) {
        return this.decodeBase64(jwtToken.getHeader()).flatMap((Function1 & Serializable)decodedHeaderString -> this.EitherDirectives((Either)package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)error -> {
            $this.log.warn("Could not decode jwt header", (Throwable)error);
            return this.Unauthorized("Could not decode jwt header", $this.evidence$1);
        }).map((Function1 & Serializable)header -> header));
    }

    private Directive<F, String> decodeBase64(String value) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> ByteString.decodeBase64((String)value).utf8(), this.evidence$1);
    }

    private RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(null, publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    private Directive<F, DecodedJWT> verifyAccessToken(Algorithm alg, String accessToken, String attemptedPath) {
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{this.issuer}).withAudience(new String[]{this.audience}).build();
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> verifier.verify(accessToken)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(33).append("Could not verify token for path: ").append(attemptedPath).toString(), throwable);
            }
            return this.Unauthorized("Could not verify token", $this.evidence$1);
        });
    }

    private Directive<F, JwtToken> jwtToken(DecodedJWT verifiedToken) {
        return this.decodeBase64(verifiedToken.getPayload()).flatMap((Function1 & Serializable)base64Token -> this.EitherDirectives((Either)package$.MODULE$.decode(base64Token, JwtToken$.MODULE$.jwtTokenDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)decodeError -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(30).append("Unable to decode JWT payload: ").append(decodeError).toString());
            }
            return this.Unauthorized("Unable to decode JWT payload", $this.evidence$1);
        }).map((Function1 & Serializable)jwtToken -> jwtToken));
    }

    private Directive<F, String> checkExpiration(JwtToken jwtToken) {
        OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(jwtToken.exp()).atOffset(ZoneOffset.UTC));
        OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
        return now.isAfter(expirationTime) ? this.Unauthorized(new StringBuilder(44).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).toString(), this.evidence$1) : Directive$.MODULE$.success((Function0 & Serializable)() -> "Valid token", this.evidence$1);
    }

    private Directive<F, OauthAuthenticatedApplication> extractProfile(JwtToken jwtToken, String rawToken) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> new OauthAuthenticatedApplication(jwtToken.sub(), jwtToken.scopes(), rawToken), this.evidence$1);
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0M2MOnBehalfOfSecurityContext auth0M2MOnBehalfOfSecurityContext = this;
        synchronized (auth0M2MOnBehalfOfSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0M2MOnBehalfOfSecurityContext auth0M2MOnBehalfOfSecurityContext = this;
        synchronized (auth0M2MOnBehalfOfSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0M2MOnBehalfOfSecurityContext auth0M2MOnBehalfOfSecurityContext = this;
        synchronized (auth0M2MOnBehalfOfSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$requestAuthBearerToken$3(Header h) {
        return h.is((HeaderKey)Authorization$.MODULE$) && h.value().toLowerCase().contains("bearer");
    }

    public static final /* synthetic */ boolean $anonfun$requestAuthOnBehalfOfToken$3(Header h) {
        return h.is((HeaderKey)Authorization$.MODULE$) && h.value().toLowerCase().contains("on-behalf-of");
    }

    public Auth0M2MOnBehalfOfSecurityContext(Function1<OauthAuthenticatedApplication, F> lookup, String issuer, String audience, JwkProvider jwkProvider, Sync<F> evidence$1) {
        this.lookup = lookup;
        this.issuer = issuer;
        this.audience = audience;
        this.jwkProvider = jwkProvider;
        this.evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.log = LoggerFactory.getLogger((String)"io.unsecurity.auth.auth0.m2m.Auth0M2MOnBehalfOfSecurityContext");
    }
}

