/*
 * Decompiled with CFR 0.152.
 */
package io.unsecurity.auth.auth0.m2m;

import cats.Monad;
import cats.data.EitherT;
import cats.data.OptionT;
import cats.effect.Sync;
import cats.kernel.Eq;
import com.auth0.jwk.JwkProvider;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import io.circe.Encoder;
import io.circe.parser.package$;
import io.unsecurity.SecurityContext;
import io.unsecurity.UnsecurityOps;
import io.unsecurity.UnsecurityOps$StreamResponse$;
import io.unsecurity.UnsecurityOps$responses$;
import io.unsecurity.auth.auth0.m2m.JwtToken;
import io.unsecurity.auth.auth0.m2m.JwtToken$;
import io.unsecurity.auth.auth0.m2m.OauthAuthenticatedApplication;
import io.unsecurity.auth.auth0.oidc.Jwt;
import io.unsecurity.auth.auth0.oidc.Jwt$JwtHeader$;
import io.unsecurity.hlinx.ParamConverter;
import java.io.Serializable;
import java.net.URI;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import no.scalabin.http4s.directives.Directive;
import no.scalabin.http4s.directives.Directive$;
import no.scalabin.http4s.directives.DirectiveOps;
import no.scalabin.http4s.directives.RequestDirectives;
import no.scalabin.http4s.directives.RequestDirectives$request$;
import no.scalabin.http4s.directives.WhenOps;
import no.scalabin.http4s.directives.when;
import okio.ByteString;
import org.http4s.Header;
import org.http4s.HeaderKey;
import org.http4s.Method;
import org.http4s.Request;
import org.http4s.RequestCookie;
import org.http4s.Response;
import org.http4s.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001\u0002\u000b\u0016\u0001\u0001B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"A\u0001\f\u0001B\u0001B\u0003%Q\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003[\u0011!\u0019\u0007AaA!\u0002\u0017!\u0007\"\u00027\u0001\t\u0003i\u0007BB;\u0001A\u0003%a\u000fC\u0003\u007f\u0001\u0011\u0005s\u0010C\u0004\u0002\u001a\u0001!\t%a\u0007\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\"!9\u0011q\u0005\u0001\u0005\n\u0005m\u0001bBA\u0015\u0001\u0011%\u00111\u0006\u0005\b\u0003\u0007\u0002A\u0011BA#\u0011\u001d\t\u0019\b\u0001C\u0005\u0003kBq!a\u001f\u0001\t\u0013\ti\bC\u0004\u0002\u001c\u0002!I!!(\t\u000f\u0005E\u0004\u0001\"\u0003\u00028\"9\u0011Q\u0019\u0001\u0005\n\u0005\u001d\u0007bBAf\u0001\u0011%\u0011Q\u001a\u0002\u0018\u0003V$\b\u000eM'3\u001bN+7-\u001e:jif\u001cuN\u001c;fqRT!AF\f\u0002\u00075\u0014TN\u0003\u0002\u00193\u0005)\u0011-\u001e;ia)\u0011!dG\u0001\u0005CV$\bN\u0003\u0002\u001d;\u0005QQO\\:fGV\u0014\u0018\u000e^=\u000b\u0003y\t!![8\u0004\u0001U\u0019\u0011EL \u0014\t\u0001\u0011\u0003&\u0011\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u000b%RCF\u000f \u000e\u0003mI!aK\u000e\u0003\u001fM+7-\u001e:jif\u001cuN\u001c;fqR\u0004\"!\f\u0018\r\u0001\u0011)q\u0006\u0001b\u0001a\t\ta)\u0006\u00022qE\u0011!'\u000e\t\u0003GMJ!\u0001\u000e\u0013\u0003\u000f9{G\u000f[5oOB\u00111EN\u0005\u0003o\u0011\u00121!\u00118z\t\u0015IdF1\u00012\u0005\u0005y\u0006CA\u001e=\u001b\u0005)\u0012BA\u001f\u0016\u0005uy\u0015-\u001e;i\u0003V$\b.\u001a8uS\u000e\fG/\u001a3BaBd\u0017nY1uS>t\u0007CA\u0017@\t\u0015\u0001\u0005A1\u00012\u0005\u0005)\u0006cA\u0015CY%\u00111i\u0007\u0002\u000e+:\u001cXmY;sSRLx\n]:\u0002\r1|wn[;q!\u0011\u0019cI\u000f%\n\u0005\u001d##!\u0003$v]\u000e$\u0018n\u001c82!\ric&\u0013\t\u0004G)s\u0014BA&%\u0005\u0019y\u0005\u000f^5p]\u00061\u0011n]:vKJ\u0004\"AT+\u000f\u0005=\u001b\u0006C\u0001)%\u001b\u0005\t&B\u0001* \u0003\u0019a$o\\8u}%\u0011A\u000bJ\u0001\u0007!J,G-\u001a4\n\u0005Y;&AB*ue&twM\u0003\u0002UI\u0005A\u0011-\u001e3jK:\u001cW-A\u0006ko.\u0004&o\u001c<jI\u0016\u0014\bCA.b\u001b\u0005a&BA/_\u0003\rQwo\u001b\u0006\u00031}S\u0011\u0001Y\u0001\u0004G>l\u0017B\u00012]\u0005-Quo\u001b)s_ZLG-\u001a:\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002fU2j\u0011A\u001a\u0006\u0003O\"\fa!\u001a4gK\u000e$(\"A5\u0002\t\r\fGo]\u0005\u0003W\u001a\u0014AaU=oG\u00061A(\u001b8jiz\"RA\\9sgR$\"a\u001c9\u0011\tm\u0002AF\u0010\u0005\u0006G\u001a\u0001\u001d\u0001\u001a\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006\u0019\u001a\u0001\r!\u0014\u0005\u00061\u001a\u0001\r!\u0014\u0005\u00063\u001a\u0001\rAW\u0001\u0004Y><\u0007CA<}\u001b\u0005A(BA={\u0003\u0015awn\u001a\u001bt\u0015\u0005Y\u0018aA8sO&\u0011Q\u0010\u001f\u0002\u0007\u0019><w-\u001a:\u0002\u0019\u0005,H\u000f[3oi&\u001c\u0017\r^3\u0016\u0005\u0005\u0005\u0001CBA\u0002\u0003+a#(\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003)!\u0017N]3di&4Xm\u001d\u0006\u0005\u0003\u0017\ti!\u0001\u0004iiR\u0004Hg\u001d\u0006\u0005\u0003\u001f\t\t\"\u0001\u0005tG\u0006d\u0017MY5o\u0015\t\t\u0019\"\u0001\u0002o_&!\u0011qCA\u0003\u0005%!\u0015N]3di&4X-A\u0005ygJ47\t[3dWV\u0011\u0011Q\u0004\t\u0007\u0003\u0007\t)\u0002L'\u0002\u001bQ\u0014\u0018M\\:g_JlWk]3s)\rA\u00151\u0005\u0005\u0007\u0003KQ\u0001\u0019\u0001\u001e\u0002\u000fI\fw/V:fe\u0006\u0001\"/Z9vKN$\u0018)\u001e;i)>\\WM\\\u0001\u000bI\u0016\u001cw\u000eZ3e\u0015^#F\u0003BA\u0017\u0003\u007f\u0001r!a\u0001\u0002\u00161\ny\u0003\u0005\u0003\u00022\u0005mRBAA\u001a\u0015\u0011\t)$a\u000e\u0002\u0015%tG/\u001a:gC\u000e,7OC\u0002\u0002:y\u000b1A[<u\u0013\u0011\ti$a\r\u0003\u0015\u0011+7m\u001c3fI*;F\u000b\u0003\u0004\u0002B1\u0001\r!T\u0001\u0006i>\\WM\\\u0001\nU^$\b*Z1eKJ$B!a\u0012\u0002pA9\u00111AA\u000bY\u0005%\u0003\u0003BA&\u0003SrA!!\u0014\u0002d9!\u0011qJA0\u001d\u0011\t\t&!\u0018\u000f\t\u0005M\u00131\f\b\u0005\u0003+\nIFD\u0002Q\u0003/J\u0011AH\u0005\u00039uI!AG\u000e\n\u0005aI\u0012bAA1/\u0005!q.\u001b3d\u0013\u0011\t)'a\u001a\u0002\u0007);HOC\u0002\u0002b]IA!a\u001b\u0002n\tI!j\u001e;IK\u0006$WM\u001d\u0006\u0005\u0003K\n9\u0007C\u0004\u0002r5\u0001\r!a\f\u0002\u0011)<H\u000fV8lK:\fA\u0002Z3d_\u0012,')Y:fmQ\"B!!\b\u0002x!1\u0011\u0011\u0010\bA\u00025\u000bQA^1mk\u0016\fqc\u0019:fCR,\u0007+\u001e2mS\u000e\\U-\u001f)s_ZLG-\u001a:\u0015\t\u0005}\u0014Q\u0011\t\u0005\u0003c\t\t)\u0003\u0003\u0002\u0004\u0006M\"A\u0004*T\u0003.+\u0017\u0010\u0015:pm&$WM\u001d\u0005\b\u0003\u000f{\u0001\u0019AAE\u0003%\u0001XO\u00197jG.+\u0017\u0010\u0005\u0003\u0002\f\u0006]UBAAG\u0015\u0011\t)$a$\u000b\t\u0005E\u00151S\u0001\tg\u0016\u001cWO]5us*\u0011\u0011QS\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001a\u00065%\u0001\u0004*T\u0003B+(\r\\5d\u0017\u0016L\u0018!\u0005<fe&4\u00170Q2dKN\u001cHk\\6f]RA\u0011QFAP\u0003_\u000b\u0019\fC\u0004\u0002\"B\u0001\r!a)\u0002\u0007\u0005dw\r\u0005\u0003\u0002&\u0006-VBAAT\u0015\u0011\tI+a\u000e\u0002\u0015\u0005dwm\u001c:ji\"l7/\u0003\u0003\u0002.\u0006\u001d&!C!mO>\u0014\u0018\u000e\u001e5n\u0011\u0019\t\t\f\u0005a\u0001\u001b\u0006Y\u0011mY2fgN$vn[3o\u0011\u0019\t)\f\u0005a\u0001\u001b\u0006i\u0011\r\u001e;f[B$X\r\u001a)bi\"$B!!/\u0002BB9\u00111AA\u000bY\u0005m\u0006cA\u001e\u0002>&\u0019\u0011qX\u000b\u0003\u0011);H\u000fV8lK:Dq!a1\u0012\u0001\u0004\ty#A\u0007wKJLg-[3e)>\\WM\\\u0001\u0010G\",7m[#ya&\u0014\u0018\r^5p]R!\u0011QDAe\u0011\u001d\t\tH\u0005a\u0001\u0003w\u000ba\"\u001a=ue\u0006\u001cG\u000f\u0015:pM&dW\r\u0006\u0003\u0002\u0002\u0005=\u0007bBA9'\u0001\u0007\u00111\u0018")
public class Auth0M2MSecurityContext<F, U>
implements SecurityContext<F, OauthAuthenticatedApplication, U>,
UnsecurityOps<F> {
    private final Function1<OauthAuthenticatedApplication, F> lookup;
    private final String issuer;
    private final String audience;
    private final JwkProvider jwkProvider;
    private final Sync<F> evidence$1;
    private final Logger log;
    private volatile UnsecurityOps$StreamResponse$ StreamResponse$module;
    private volatile UnsecurityOps$responses$ responses$module;
    private volatile RequestDirectives$request$ request$module;

    public <E, A> Directive<F, A> eitherToDirective(Either<E, A> either, Function1<E, Response<F>> failure, Monad<F> F) {
        return UnsecurityOps.eitherToDirective$((UnsecurityOps)this, either, failure, F);
    }

    public <A> UnsecurityOps.TryDirectives<A> TryDirectives(Try<A> t, Sync<F> S) {
        return UnsecurityOps.TryDirectives$((UnsecurityOps)this, t, S);
    }

    public UnsecurityOps.BooleanDirectives BooleanDirectives(boolean b, Sync<F> S) {
        return UnsecurityOps.BooleanDirectives$((UnsecurityOps)this, (boolean)b, S);
    }

    public Directive<F, RequestCookie> cookie(String cookieName, Sync<F> sync) {
        return UnsecurityOps.cookie$((UnsecurityOps)this, (String)cookieName, sync);
    }

    public Directive<F, List<RequestCookie>> requestCookies(Sync<F> sync) {
        return UnsecurityOps.requestCookies$((UnsecurityOps)this, sync);
    }

    public <A> Directive<F, Option<A>> queryParamAs(String name, ParamConverter<A> evidence$1, Sync<F> sync) {
        return UnsecurityOps.queryParamAs$((UnsecurityOps)this, (String)name, evidence$1, sync);
    }

    public Directive<F, String> requiredQueryParam(String name, Sync<F> syncEvidence) {
        return UnsecurityOps.requiredQueryParam$((UnsecurityOps)this, (String)name, syncEvidence);
    }

    public <A> Directive<F, A> requiredQueryParamAs(String name, ParamConverter<A> evidence$2, Sync<F> sync) {
        return UnsecurityOps.requiredQueryParamAs$((UnsecurityOps)this, (String)name, evidence$2, sync);
    }

    public Response<F> Redirect(Uri uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (Uri)uri, sync);
    }

    public Response<F> Redirect(String uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (String)uri, sync);
    }

    public Response<F> Redirect(URI uri, Sync<F> sync) {
        return UnsecurityOps.Redirect$((UnsecurityOps)this, (URI)uri, sync);
    }

    public <B> Directive<F, B> BadRequest(String detail, Sync<F> sync) {
        return UnsecurityOps.BadRequest$((UnsecurityOps)this, (String)detail, sync);
    }

    public <A> Directive<F, A> NotFound(Sync<F> sync) {
        return UnsecurityOps.NotFound$((UnsecurityOps)this, sync);
    }

    public <B> Directive<F, B> Unauthorized(String details, Sync<F> sync) {
        return UnsecurityOps.Unauthorized$((UnsecurityOps)this, (String)details, sync);
    }

    public <A> Directive<F, A> Forbidden(Sync<F> syncEvidence) {
        return UnsecurityOps.Forbidden$((UnsecurityOps)this, syncEvidence);
    }

    public <B> Directive<F, B> InternalServerError(String title, Option<String> detail, Sync<F> syncEvidence) {
        return UnsecurityOps.InternalServerError$((UnsecurityOps)this, (String)title, detail, syncEvidence);
    }

    public <B> Option<String> InternalServerError$default$2() {
        return UnsecurityOps.InternalServerError$default$2$((UnsecurityOps)this);
    }

    public <A> Directive<F, Response<F>> Ok(A a, Encoder<A> evidence$3, Sync<F> syncEvidence) {
        return UnsecurityOps.Ok$((UnsecurityOps)this, a, evidence$3, syncEvidence);
    }

    public <A> Directive<F, Response<F>> Accepted(A a, Encoder<A> evidence$4, Sync<F> syncEvidence) {
        return UnsecurityOps.Accepted$((UnsecurityOps)this, a, evidence$4, syncEvidence);
    }

    public Directive<F, Method> MethodDirective(Method M, Eq<Method> eq, Monad<F> sync) {
        return RequestDirectives.MethodDirective$((RequestDirectives)this, (Method)M, eq, sync);
    }

    public <KEY extends HeaderKey> Directive<F, Option<Header>> liftHeaderDirective(KEY K, Monad<F> sync) {
        return RequestDirectives.liftHeaderDirective$((RequestDirectives)this, K, sync);
    }

    public <KEY extends HeaderKey> RequestDirectives.HeaderDirective<KEY> HeaderDirective(KEY key, Monad<F> sync) {
        return RequestDirectives.HeaderDirective$((RequestDirectives)this, key, sync);
    }

    public <A> when<F, A> when(PartialFunction<Request<F>, A> pf, Monad<F> F) {
        return WhenOps.when$((WhenOps)this, pf, F);
    }

    public DirectiveOps.DirectiveResponseOps DirectiveResponseOps(Directive<F, Response<F>> dir, Monad<F> F) {
        return DirectiveOps.DirectiveResponseOps$((DirectiveOps)this, dir, F);
    }

    public DirectiveOps.FilterSyntax FilterSyntax(boolean b) {
        return DirectiveOps.FilterSyntax$((DirectiveOps)this, (boolean)b);
    }

    public <X> DirectiveOps.MonadDecorator<X> MonadDecorator(F f, Monad<F> sync) {
        return DirectiveOps.MonadDecorator$((DirectiveOps)this, f, sync);
    }

    public <A> DirectiveOps.OptionDirectives<A> OptionDirectives(Option<A> opt, Monad<F> S) {
        return DirectiveOps.OptionDirectives$((DirectiveOps)this, opt, S);
    }

    public <E, A> DirectiveOps.EitherDirectives<E, A> EitherDirectives(Either<E, A> either, Monad<F> S) {
        return DirectiveOps.EitherDirectives$((DirectiveOps)this, either, S);
    }

    public <E, A> DirectiveOps.EitherTDirectives<E, A> EitherTDirectives(EitherT<F, E, A> monad, Monad<F> S) {
        return DirectiveOps.EitherTDirectives$((DirectiveOps)this, monad, S);
    }

    public <A> DirectiveOps.OptionTDirectives<A> OptionTDirectives(OptionT<F, A> monad, Monad<F> S) {
        return DirectiveOps.OptionTDirectives$((DirectiveOps)this, monad, S);
    }

    public UnsecurityOps$StreamResponse$ StreamResponse() {
        if (this.StreamResponse$module == null) {
            this.StreamResponse$lzycompute$1();
        }
        return this.StreamResponse$module;
    }

    public UnsecurityOps$responses$ responses() {
        if (this.responses$module == null) {
            this.responses$lzycompute$1();
        }
        return this.responses$module;
    }

    public RequestDirectives$request$ request() {
        if (this.request$module == null) {
            this.request$lzycompute$1();
        }
        return this.request$module;
    }

    public Directive<F, OauthAuthenticatedApplication> authenticate() {
        return this.request().path(this.evidence$1).flatMap((Function1 & Serializable)attemptedPath -> this.requestAuthToken().flatMap((Function1 & Serializable)requestAuthToken -> this.decodedJWT((String)requestAuthToken).flatMap((Function1 & Serializable)decodedJWT -> this.jwtHeader((DecodedJWT)decodedJWT).map((Function1 & Serializable)jwtHeader -> {
            RSAPublicKey publicKey = (RSAPublicKey)$this.jwkProvider.get(jwtHeader.kid()).getPublicKey();
            Algorithm alg = Algorithm.RSA256((RSAKeyProvider)this.createPublicKeyProvider(publicKey));
            return new Tuple3(jwtHeader, (Object)publicKey, (Object)alg);
        }).flatMap((Function1 & Serializable)x$2 -> {
            Tuple3 tuple3 = x$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Algorithm alg = (Algorithm)tuple3._3();
            Directive directive = this.verifyAccessToken(alg, (String)requestAuthToken, (String)attemptedPath).flatMap((Function1 & Serializable)verifiedToken -> this.jwtToken((DecodedJWT)verifiedToken).flatMap((Function1 & Serializable)jwtToken -> this.checkExpiration((JwtToken)jwtToken).flatMap((Function1 & Serializable)x$1 -> {
                String string = x$1;
                Directive directive = this.extractProfile((JwtToken)jwtToken).map((Function1 & Serializable)userProfile -> userProfile);
                return directive;
            })));
            return directive;
        }))));
    }

    public Directive<F, String> xsrfCheck() {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> "", this.evidence$1);
    }

    public F transformUser(OauthAuthenticatedApplication rawUser) {
        return (F)this.lookup.apply((Object)rawUser);
    }

    private Directive<F, String> requestAuthToken() {
        return this.request().header("authorization", this.evidence$1).flatMap((Function1 & Serializable)authHeader -> this.OptionDirectives((Option)authHeader.map((Function1 & Serializable)header -> (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])header.value().split(" ")))), (Monad)$this.evidence$1).toSuccess(this.Unauthorized("Authorization header not found. Please log in", $this.evidence$1)).map((Function1 & Serializable)token -> token));
    }

    private Directive<F, DecodedJWT> decodedJWT(String token) {
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> JWT.decode((String)token)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            $this.log.warn("Could not extract token from request", throwable);
            return this.Unauthorized("Could not extract token from request", $this.evidence$1);
        });
    }

    private Directive<F, Jwt.JwtHeader> jwtHeader(DecodedJWT jwtToken) {
        return this.decodeBase64(jwtToken.getHeader()).flatMap((Function1 & Serializable)decodedHeaderString -> this.EitherDirectives((Either)package$.MODULE$.decode(decodedHeaderString, Jwt$JwtHeader$.MODULE$.jwtDeaderDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)error -> {
            $this.log.warn("Could not decode jwt header", (Throwable)error);
            return this.Unauthorized("Could not decode jwt header", $this.evidence$1);
        }).map((Function1 & Serializable)header -> header));
    }

    private Directive<F, String> decodeBase64(String value) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> ByteString.decodeBase64((String)value).utf8(), this.evidence$1);
    }

    private RSAKeyProvider createPublicKeyProvider(RSAPublicKey publicKey) {
        return new RSAKeyProvider(null, publicKey){
            private final RSAPublicKey publicKey$1;

            public Nothing$ getPrivateKeyId() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }

            public RSAPublicKey getPublicKeyById(String keyId) {
                return this.publicKey$1;
            }

            public RSAPrivateKey getPrivateKey() {
                throw new UnsupportedOperationException("The private key is stored at the IdP and should never hit our app. Use this KeyProvider only for verification, not signing!");
            }
            {
                this.publicKey$1 = publicKey$1;
            }
        };
    }

    private Directive<F, DecodedJWT> verifyAccessToken(Algorithm alg, String accessToken, String attemptedPath) {
        JWTVerifier verifier = JWT.require((Algorithm)alg).withIssuer(new String[]{this.issuer}).withAudience(new String[]{this.audience}).build();
        return this.TryDirectives(Try$.MODULE$.apply((Function0 & Serializable)() -> verifier.verify(accessToken)), this.evidence$1).toSuccess((Function1 & Serializable)throwable -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(33).append("Could not verify token for path: ").append(attemptedPath).toString(), throwable);
            }
            return this.Unauthorized("Could not verify token", $this.evidence$1);
        });
    }

    private Directive<F, JwtToken> jwtToken(DecodedJWT verifiedToken) {
        return this.decodeBase64(verifiedToken.getPayload()).flatMap((Function1 & Serializable)base64Token -> this.EitherDirectives((Either)package$.MODULE$.decode(base64Token, JwtToken$.MODULE$.jwtTokenDecoder()), (Monad)$this.evidence$1).toSuccess((Function1 & Serializable)decodeError -> {
            block0: {
                if (!$this.log.isWarnEnabled()) break block0;
                $this.log.warn(new StringBuilder(30).append("Unable to decode JWT payload: ").append(decodeError).toString());
            }
            return this.Unauthorized("Unable to decode JWT payload", $this.evidence$1);
        }).map((Function1 & Serializable)jwtToken -> jwtToken));
    }

    private Directive<F, String> checkExpiration(JwtToken jwtToken) {
        OffsetDateTime expirationTime = OffsetDateTime.from(Instant.ofEpochSecond(jwtToken.exp()).atOffset(ZoneOffset.UTC));
        OffsetDateTime now = OffsetDateTime.now(ZoneId.from(ZoneOffset.UTC));
        return now.isAfter(expirationTime) ? this.Unauthorized(new StringBuilder(44).append("Token is expired! ").append(now).append(" is after expirationTime: ").append(expirationTime).toString(), this.evidence$1) : Directive$.MODULE$.success((Function0 & Serializable)() -> "Valid token", this.evidence$1);
    }

    private Directive<F, OauthAuthenticatedApplication> extractProfile(JwtToken jwtToken) {
        return Directive$.MODULE$.success((Function0 & Serializable)() -> new OauthAuthenticatedApplication(jwtToken.sub(), jwtToken.scopes()), this.evidence$1);
    }

    private final void StreamResponse$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.StreamResponse$module == null) {
                this.StreamResponse$module = new UnsecurityOps$StreamResponse$((UnsecurityOps)this);
            }
        }
    }

    private final void responses$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.responses$module == null) {
                this.responses$module = new UnsecurityOps$responses$((UnsecurityOps)this);
            }
        }
    }

    private final void request$lzycompute$1() {
        Auth0M2MSecurityContext auth0M2MSecurityContext = this;
        synchronized (auth0M2MSecurityContext) {
            if (this.request$module == null) {
                this.request$module = new RequestDirectives$request$((RequestDirectives)this);
            }
        }
    }

    public Auth0M2MSecurityContext(Function1<OauthAuthenticatedApplication, F> lookup, String issuer, String audience, JwkProvider jwkProvider, Sync<F> evidence$1) {
        this.lookup = lookup;
        this.issuer = issuer;
        this.audience = audience;
        this.jwkProvider = jwkProvider;
        this.evidence$1 = evidence$1;
        DirectiveOps.$init$((DirectiveOps)this);
        WhenOps.$init$((WhenOps)this);
        RequestDirectives.$init$((RequestDirectives)this);
        UnsecurityOps.$init$((UnsecurityOps)this);
        this.log = LoggerFactory.getLogger((String)"io.unsecurity.auth.auth0.m2m.Auth0M2MSecurityContext");
    }
}

