/*
 * Decompiled with CFR 0.152.
 */
package io.unmock.core;

import io.unmock.core.Save;
import io.unmock.core.logger.Logger;
import io.unmock.core.logger.SilentLogger;
import io.unmock.core.persistence.Persistence;
import io.unmock.core.persistence.SilentPersistence;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UnmockOptions {
    private static final String DEFAULT_UNMOCK_HOST = "api.unmock.io";
    private static final int DEFAULT_UNMOCK_PORT = 443;
    private static final boolean DEFAULT_USE_IN_PRODUCTION = false;
    @NotNull
    public final Logger logger;
    @NotNull
    public final Persistence persistence;
    @NotNull
    public final Save save;
    @NotNull
    public final String unmockHost;
    @NotNull
    public final int unmockPort;
    @NotNull
    public final boolean useInProduction;
    @Nullable
    public final String ignore;
    @Nullable
    public final String signature;
    @Nullable
    public final String token;
    @Nullable
    public final Collection<String> whitelist;

    private UnmockOptions(@NotNull Logger logger, @NotNull Persistence persistence, @NotNull Save save, @NotNull String unmockHost, @NotNull int unmockPort, @NotNull boolean useInProduction, @Nullable String ignore, @Nullable String signature, @Nullable String token, @Nullable Collection<String> whitelist) {
        this.logger = logger;
        this.persistence = persistence;
        this.save = save;
        this.unmockHost = unmockHost;
        this.unmockPort = unmockPort;
        this.useInProduction = useInProduction;
        this.ignore = ignore;
        this.signature = signature;
        this.token = token;
        this.whitelist = whitelist;
    }

    public static class Builder {
        @Nullable
        public Logger logger = null;
        @Nullable
        public Persistence persistence = null;
        @Nullable
        public Save save = null;
        @Nullable
        public String unmockHost = null;
        @Nullable
        public Integer unmockPort = null;
        @Nullable
        public Boolean useInProduction = null;
        @Nullable
        public String ignore = null;
        @Nullable
        public String signature = null;
        @Nullable
        public String token = null;
        @Nullable
        public Collection<String> whitelist = null;

        public Builder() {
        }

        private Builder(Builder builder) {
            this.logger = builder.logger;
            this.persistence = builder.persistence;
            this.save = builder.save;
            this.unmockHost = builder.unmockHost;
            this.unmockPort = builder.unmockPort;
            this.useInProduction = builder.useInProduction;
            this.ignore = builder.ignore;
            this.signature = builder.signature;
            this.token = builder.token;
            this.whitelist = builder.whitelist;
        }

        @NotNull
        public Builder logger(@NotNull Logger logger) {
            Builder out = new Builder(this);
            out.logger = logger;
            return out;
        }

        @NotNull
        public Builder persistence(@NotNull Persistence persistence) {
            Builder out = new Builder(this);
            out.persistence = persistence;
            return out;
        }

        @NotNull
        public Builder save(@NotNull Save save) {
            Builder out = new Builder(this);
            out.save = save;
            return out;
        }

        @NotNull
        public Builder unmockHost(@NotNull String unmockHost) {
            Builder out = new Builder(this);
            out.unmockHost = unmockHost;
            return out;
        }

        @NotNull
        public Builder unmockPort(@NotNull Integer unmockPort) {
            Builder out = new Builder(this);
            out.unmockPort = unmockPort;
            return out;
        }

        @NotNull
        public Builder useInProduction(@NotNull Boolean useInProduction) {
            Builder out = new Builder(this);
            out.useInProduction = useInProduction;
            return out;
        }

        @NotNull
        public Builder ignore(@NotNull String ignore) {
            Builder out = new Builder(this);
            out.ignore = ignore;
            return out;
        }

        @NotNull
        public Builder signature(@NotNull String signature) {
            Builder out = new Builder(this);
            out.signature = signature;
            return out;
        }

        @NotNull
        public Builder token(@NotNull String token) {
            Builder out = new Builder(this);
            out.token = token;
            return out;
        }

        @NotNull
        public Builder whitelist(@NotNull Collection<String> whitelist) {
            Builder out = new Builder(this);
            out.whitelist = whitelist;
            return out;
        }

        @NotNull
        public UnmockOptions build() {
            return new UnmockOptions(this.logger != null ? this.logger : new SilentLogger(), this.persistence != null ? this.persistence : new SilentPersistence(), this.save != null ? this.save : Save.ofBoolean(false), this.unmockHost != null ? this.unmockHost : UnmockOptions.DEFAULT_UNMOCK_HOST, this.unmockPort != null ? this.unmockPort : 443, this.useInProduction != null ? this.useInProduction : false, this.ignore, this.signature, this.token, this.whitelist);
        }
    }
}

