/*
 * Decompiled with CFR 0.152.
 */
package io.unmock.core;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import io.unmock.core.persistence.Persistence;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Token {
    private static boolean PINGABLE = false;

    private static void makeHeader(@NotNull HttpURLConnection connection, @NotNull String token) {
        connection.setRequestProperty("Authorization", "Bearer " + token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static boolean canPingWithAccessToken(@NotNull String accessToken, @NotNull String unmockHost, @NotNull int unmockPort) {
        HttpURLConnection connection = null;
        Integer response = null;
        try {
            URL url = new URL("https", unmockHost, unmockPort, "/ping");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            Token.makeHeader(connection, accessToken);
            connection.setUseCaches(false);
            response = connection.getResponseCode();
        }
        catch (IOException iOException) {
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response == 200;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static String exchangeRefreshTokenForAccessToken(@NotNull String refreshToken, @NotNull String unmockHost, @NotNull int unmockPort) throws IOException {
        HttpURLConnection connection = null;
        String token = null;
        String urlParameters = "{\"refreshToken\":\"" + refreshToken + "\"}";
        try {
            String line;
            URL url = new URL("https", unmockHost, unmockPort, "/token/access");
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setUseCaches(false);
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Content-Length", Integer.toString(urlParameters.getBytes().length));
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(urlParameters);
            wr.close();
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuffer response = new StringBuffer();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\n');
            }
            rd.close();
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Map myMap = (Map)new Gson().fromJson(response.toString(), type);
            token = (String)myMap.get("accessToken");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static String getAccessToken(@NotNull Persistence persistence, @NotNull String unmockHost, @NotNull int unmockPort) throws IOException {
        String accessToken = persistence.loadAuth();
        if (accessToken != null && !PINGABLE && !(PINGABLE = Token.canPingWithAccessToken(accessToken, unmockHost, unmockPort))) {
            accessToken = null;
        }
        if (accessToken == null) {
            String refreshToken = persistence.loadToken();
            if (refreshToken == null) return null;
            accessToken = Token.exchangeRefreshTokenForAccessToken(refreshToken, unmockHost, unmockPort);
            if (accessToken == null) throw new IOException("Incorrect server response: did not get accessToken");
            persistence.saveAuth(accessToken);
        }
        if (PINGABLE || accessToken == null || (PINGABLE = Token.canPingWithAccessToken(accessToken, unmockHost, unmockPort))) return accessToken;
        throw new IOException("Internal authorization error");
    }
}

