/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.bukkit.object;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class TypeDef {
    private final Class<?> javaClass;
    private final List<TypeDef> typeParameters;
    public static final TypeDef object = new TypeDef(Object.class, Collections.emptyList());
    public static final TypeDef empty = new TypeDef(Void.class, Collections.emptyList());

    public static Optional<TypeDef> from(Type type) {
        TypeDef baseType;
        if (type instanceof ParameterizedType && (baseType = (TypeDef)TypeDef.from(((ParameterizedType)type).getRawType()).orElse(null)) != null) {
            List<TypeDef> typeParams = Arrays.stream(((ParameterizedType)type).getActualTypeArguments()).flatMap(a -> TypeDef.from(a).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
            return Optional.of(new TypeDef(baseType.getJavaClass(), typeParams));
        }
        if (type instanceof Class) {
            return Optional.of(new TypeDef((Class)type, Collections.emptyList()));
        }
        return Optional.empty();
    }

    public TypeDef(Class<?> javaClass, List<TypeDef> typeParameters) {
        this.javaClass = javaClass;
        this.typeParameters = typeParameters;
    }

    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    public List<TypeDef> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TypeDef)) {
            return false;
        }
        TypeDef other = (TypeDef)o;
        Class<?> this$javaClass = this.getJavaClass();
        Class<?> other$javaClass = other.getJavaClass();
        if (this$javaClass == null ? other$javaClass != null : !this$javaClass.equals(other$javaClass)) {
            return false;
        }
        List<TypeDef> this$typeParameters = this.getTypeParameters();
        List<TypeDef> other$typeParameters = other.getTypeParameters();
        return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $javaClass = this.getJavaClass();
        result = result * 59 + ($javaClass == null ? 43 : $javaClass.hashCode());
        List<TypeDef> $typeParameters = this.getTypeParameters();
        result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
        return result;
    }

    public String toString() {
        return "TypeDef(javaClass=" + this.getJavaClass() + ", typeParameters=" + this.getTypeParameters() + ")";
    }
}

