/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.bukkit.object;

import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Result<A> {
    public static <A> Result<A> success(A a) {
        return new Success(a);
    }

    public static <A> Result<A> failure(Throwable failure) {
        return new Failure(failure);
    }

    public static <A> Result<A> fromOptional(Optional<A> opt, Supplier<Throwable> f) {
        A a = opt.orElse(null);
        if (a != null) {
            return Result.success(a);
        }
        return Result.failure(f.get());
    }

    default public A get() {
        if (this instanceof Success) {
            Success succ = (Success)this;
            return succ.getValue();
        }
        return null;
    }

    default public A getOrElse(A elseValue) {
        return this.asOptional().orElse(elseValue);
    }

    default public A getOrThrow() {
        Throwable failure = this.getFailure().orElse(null);
        if (failure != null) {
            throw new IllegalStateException(failure);
        }
        return this.get();
    }

    default public <B> Result<B> map(Function<A, B> f) {
        if (this instanceof Success) {
            Success succ = (Success)this;
            return new Success(f.apply(succ.get()));
        }
        if (this instanceof Failure) {
            Failure failure = (Failure)this;
            return new Failure(failure.getThrowable());
        }
        throw new UnsupportedOperationException();
    }

    default public <B> Result<B> flatMap(Function<A, Result<B>> f) {
        if (this instanceof Success) {
            Success succ = (Success)this;
            return f.apply(succ.get());
        }
        if (this instanceof Failure) {
            Failure failure = (Failure)this;
            return new Failure(failure.getThrowable());
        }
        throw new UnsupportedOperationException();
    }

    default public Optional<Throwable> getFailure() {
        if (this instanceof Failure) {
            Failure failure = (Failure)this;
            return Optional.of(failure.getThrowable());
        }
        return Optional.empty();
    }

    default public boolean isSuccess() {
        return this.get() != null;
    }

    default public Optional<A> asOptional() {
        return Optional.ofNullable(this.get());
    }

    public static final class Failure<A>
    implements Result<A> {
        private final Throwable throwable;

        private Failure(Throwable throwable) {
            this.throwable = throwable;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Failure)) {
                return false;
            }
            Failure other = (Failure)o;
            Throwable this$throwable = this.getThrowable();
            Throwable other$throwable = other.getThrowable();
            return !(this$throwable == null ? other$throwable != null : !this$throwable.equals(other$throwable));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Throwable $throwable = this.getThrowable();
            result = result * 59 + ($throwable == null ? 43 : $throwable.hashCode());
            return result;
        }

        public String toString() {
            return "Result.Failure(throwable=" + this.getThrowable() + ")";
        }
    }

    public static final class Success<A>
    implements Result<A> {
        private final A value;

        private Success(A value) {
            this.value = value;
        }

        public A getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Success)) {
                return false;
            }
            Success other = (Success)o;
            A this$value = this.getValue();
            A other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            A $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "Result.Success(value=" + this.getValue() + ")";
        }
    }
}

