/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.bukkit.object;

import io.typecraft.bukkit.object.FieldDef;
import io.typecraft.bukkit.object.FieldValue;
import io.typecraft.bukkit.object.ObjectDef;
import io.typecraft.bukkit.object.Reflections;
import io.typecraft.bukkit.object.Result;
import io.typecraft.bukkit.object.TypeDef;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class BukkitObjectMapper {
    private final Map<String, ObjectDef> objectDefMap = new HashMap<String, ObjectDef>();

    public Result<Map<String, Object>> encode(Object x) {
        return this.encodeObject(x).map(a -> a instanceof Map ? (Map)a : Collections.emptyMap());
    }

    public <A> Result<A> decode(Map<String, Object> xs, Class<A> clazz) {
        return ConfigurationSerializable.class.isAssignableFrom(clazz) ? Result.fromOptional(this.decodeBukkitObject(xs).flatMap(a -> clazz.isInstance(a) ? Optional.of(clazz.cast(a)) : Optional.empty()), IllegalStateException::new) : this.decodeLombokObject(xs, clazz);
    }

    private <A> Result<A> decodeLombokObject(Map<String, Object> xs, Class<A> clazz) {
        ObjectDef def = this.objectDefMap.computeIfAbsent(clazz.getTypeName(), k -> ObjectDef.from(clazz));
        if (def.isEmpty()) {
            return Result.failure(new IllegalArgumentException("Unknown object: " + clazz.getName()));
        }
        try {
            Constructor<?> constructor = def.getBuilderClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object builderInstance = constructor.newInstance(new Object[0]);
            for (FieldDef field : def.getFields()) {
                Object x = xs.get(field.getName());
                if (x == null) continue;
                Result<Object> result = this.decodeObject(x, field.getFieldType());
                Throwable failure = result.getFailure().orElse(null);
                if (failure == null) {
                    Object subValue = result.get();
                    FieldValue subFieldValue = FieldValue.of(field.getFieldType(), subValue);
                    Reflections.invokeMethod(builderInstance, field.getName(), subFieldValue);
                    continue;
                }
                return Result.failure(failure);
            }
            Object value = Reflections.invokeMethod(builderInstance, "build", new FieldValue[0]).orElse(null);
            return clazz.isInstance(value) ? Result.success(clazz.cast(value)) : Result.failure(new IllegalArgumentException(String.format("Expected %s, but %s.", clazz.getName(), value)));
        }
        catch (Exception e) {
            return Result.failure(e);
        }
    }

    private Result<Object> decodeObject(Object x, TypeDef typeDef) {
        Class<?> fieldClass;
        ObjectDef objectDef;
        if (x instanceof ConfigurationSection && !ConfigurationSection.class.isAssignableFrom(typeDef.getJavaClass())) {
            x = ((ConfigurationSection)x).getValues(false);
        }
        if (!(objectDef = this.objectDefMap.computeIfAbsent((fieldClass = typeDef.getJavaClass()).getTypeName(), k -> ObjectDef.from(fieldClass))).isEmpty()) {
            return this.decode((Map)x, objectDef.getObjectType().getJavaClass()).map(a -> a);
        }
        List<TypeDef> typeParams = typeDef.getTypeParameters();
        if (x instanceof Map) {
            TypeDef kType = typeParams.size() >= 1 ? typeParams.get(0) : TypeDef.object;
            TypeDef vType = typeParams.size() >= 2 ? typeParams.get(1) : TypeDef.object;
            Map xs = (Map)x;
            HashMap<Object, Object> ret = new HashMap<Object, Object>(xs.size());
            for (Map.Entry pair : xs.entrySet()) {
                Result<Object> keyResult = this.decodeObject(pair.getKey(), kType);
                Result<Object> valueResult = this.decodeObject(pair.getValue(), vType);
                Throwable keyFailure = keyResult.getFailure().orElse(null);
                Throwable valueFailure = valueResult.getFailure().orElse(null);
                if (keyFailure != null) {
                    return keyResult;
                }
                if (valueFailure != null) {
                    return valueResult;
                }
                ret.put(keyResult.get(), valueResult.get());
            }
            return Result.success(ret);
        }
        if (x instanceof Collection) {
            TypeDef vType = typeParams.size() >= 1 ? typeParams.get(0) : TypeDef.object;
            Collection xs = (Collection)x;
            AbstractCollection ret = Set.class.isAssignableFrom(typeDef.getJavaClass()) ? new HashSet(xs.size()) : new ArrayList(xs.size());
            for (Object a2 : xs) {
                Result<Object> result = this.decodeObject(a2, vType);
                Throwable failure = result.getFailure().orElse(null);
                if (failure == null) {
                    ret.add(result.get());
                    continue;
                }
                return result;
            }
            return Result.success(ret);
        }
        if (fieldClass == UUID.class) {
            return Result.success(UUID.fromString(x.toString()));
        }
        if (fieldClass == Map.class && x instanceof ConfigurationSection) {
            return Result.success(((ConfigurationSection)x).getValues(false));
        }
        if (Enum.class.isAssignableFrom(fieldClass)) {
            try {
                return Result.success(Enum.valueOf(fieldClass, x.toString()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (fieldClass == LocalDateTime.class) {
                return Result.success(LocalDateTime.parse(x.toString()));
            }
            if (fieldClass == LocalDate.class) {
                return Result.success(LocalDate.parse(x.toString()));
            }
            if (fieldClass == LocalTime.class) {
                return Result.success(LocalTime.parse(x.toString()));
            }
            if (fieldClass == Duration.class) {
                return Result.success(Duration.parse(x.toString()));
            }
        }
        Function<String, Optional<Object>> parser = Reflections.parserByPrimitives.get(fieldClass);
        Object finalX = x;
        return parser != null ? Result.fromOptional(parser.apply(x.toString()), () -> new IllegalArgumentException(String.format("Expected %s, but %s.", fieldClass, finalX))) : Result.success(x);
    }

    private Optional<ConfigurationSerializable> decodeBukkitObject(Map<String, Object> xs) {
        return Optional.ofNullable(ConfigurationSerialization.deserializeObject(xs));
    }

    private Result<Object> encodeObject(Object x) {
        if (x instanceof ConfigurationSerializable) {
            return this.encodeBukkitObject((ConfigurationSerializable)x).map(a -> a);
        }
        if (x instanceof Collection) {
            Collection xs = (Collection)x;
            ArrayList<Object> ret = new ArrayList<Object>(xs.size());
            for (Object a2 : xs) {
                Result<Object> result = this.encodeObject(a2);
                Throwable failure = result.getFailure().orElse(null);
                if (failure == null) {
                    ret.add(result.get());
                    continue;
                }
                return Result.failure(failure);
            }
            return Result.success(ret);
        }
        if (x instanceof Map) {
            Map map = (Map)x;
            HashMap<String, Object> ret = new HashMap<String, Object>(map.size());
            for (Map.Entry pair : map.entrySet()) {
                Result<Object> result = this.encodeObject(pair.getValue());
                Throwable failure = result.getFailure().orElse(null);
                if (failure == null) {
                    ret.put(pair.getKey().toString(), result.get());
                    continue;
                }
                return Result.failure(failure);
            }
            return Result.success(ret);
        }
        return this.encodeLombokObject(x);
    }

    private Result<Object> encodeLombokObject(Object x) {
        if (Reflections.checkPrimitive(x.getClass()) || x instanceof ConfigurationSection) {
            return Result.success(x);
        }
        if (x instanceof UUID) {
            return Result.success(x.toString());
        }
        if (x instanceof Enum) {
            return Result.success(((Enum)x).name());
        }
        if (x instanceof LocalDateTime || x instanceof LocalDate || x instanceof LocalTime || x instanceof Duration) {
            return Result.success(x.toString());
        }
        Class<?> clazz = x.getClass();
        ObjectDef info = this.objectDefMap.computeIfAbsent(clazz.getTypeName(), k -> ObjectDef.from(clazz));
        if (info.getFields().isEmpty()) {
            return Result.failure(new IllegalArgumentException("Unknown object: " + x.getClass().getName()));
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (FieldDef field : info.getFields()) {
            Object value = Reflections.invokeMethod(x, field.getGetterName(), new FieldValue[0]).orElse(null);
            if (value == null) continue;
            Result<Object> result = this.encodeObject(value);
            Throwable failure = result.getFailure().orElse(null);
            if (failure == null) {
                ret.put(field.getName(), result.get());
                continue;
            }
            return result;
        }
        return Result.success(ret);
    }

    private Result<Map<String, Object>> encodeBukkitObject(ConfigurationSerializable x) {
        Map serialized = x.serialize();
        HashMap ret = new HashMap(serialized.size());
        for (Map.Entry pair : serialized.entrySet()) {
            Result<Object> result = this.encodeObject(pair.getValue());
            Throwable failure = result.getFailure().orElse(null);
            if (failure == null) {
                ret.put(pair.getKey(), result.get());
                continue;
            }
            return Result.failure(failure);
        }
        ret.put("==", ConfigurationSerialization.getAlias(x.getClass()));
        return Result.success(ret);
    }
}

