/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.bukkit.object;

import io.typecraft.bukkit.object.FieldDef;
import io.typecraft.bukkit.object.Reflections;
import io.typecraft.bukkit.object.TypeDef;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ObjectDef {
    private final Set<FieldDef> fields;
    private final TypeDef objectType;
    private final Class<?> builderClass;
    public static final ObjectDef empty = new ObjectDef(Collections.emptySet(), TypeDef.empty, Void.class);

    public boolean isEmpty() {
        return this.builderClass == Void.class;
    }

    public static ObjectDef from(Class<?> clazz) {
        Class builderclass = Reflections.findClass(String.format("%s$%sBuilder", clazz.getName(), clazz.getSimpleName())).orElse(null);
        TypeDef objectType = TypeDef.from(clazz).orElse(null);
        if (builderclass == null || objectType == null) {
            return empty;
        }
        HashSet<FieldDef> fields = new HashSet<FieldDef>();
        for (Method method : clazz.getDeclaredMethods()) {
            String name = method.getName();
            if (!name.startsWith("get") || name.length() < 4) continue;
            String fieldName = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            TypeDef fieldType = TypeDef.from(method.getGenericReturnType()).orElse(null);
            if (fieldType == null) continue;
            fields.add(FieldDef.of(fieldName, fieldType, name));
        }
        return new ObjectDef(fields, objectType, builderclass);
    }

    private ObjectDef(Set<FieldDef> fields, TypeDef objectType, Class<?> builderClass) {
        this.fields = fields;
        this.objectType = objectType;
        this.builderClass = builderClass;
    }

    public static ObjectDef of(Set<FieldDef> fields, TypeDef objectType, Class<?> builderClass) {
        return new ObjectDef(fields, objectType, builderClass);
    }

    public Set<FieldDef> getFields() {
        return this.fields;
    }

    public TypeDef getObjectType() {
        return this.objectType;
    }

    public Class<?> getBuilderClass() {
        return this.builderClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectDef)) {
            return false;
        }
        ObjectDef other = (ObjectDef)o;
        Set<FieldDef> this$fields = this.getFields();
        Set<FieldDef> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        TypeDef this$objectType = this.getObjectType();
        TypeDef other$objectType = other.getObjectType();
        if (this$objectType == null ? other$objectType != null : !((Object)this$objectType).equals(other$objectType)) {
            return false;
        }
        Class<?> this$builderClass = this.getBuilderClass();
        Class<?> other$builderClass = other.getBuilderClass();
        return !(this$builderClass == null ? other$builderClass != null : !this$builderClass.equals(other$builderClass));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<FieldDef> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        TypeDef $objectType = this.getObjectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)$objectType).hashCode());
        Class<?> $builderClass = this.getBuilderClass();
        result = result * 59 + ($builderClass == null ? 43 : $builderClass.hashCode());
        return result;
    }

    public String toString() {
        return "ObjectDef(fields=" + this.getFields() + ", objectType=" + this.getObjectType() + ", builderClass=" + this.getBuilderClass() + ")";
    }

    public ObjectDef withFields(Set<FieldDef> fields) {
        return this.fields == fields ? this : new ObjectDef(fields, this.objectType, this.builderClass);
    }

    public ObjectDef withObjectType(TypeDef objectType) {
        return this.objectType == objectType ? this : new ObjectDef(this.fields, objectType, this.builderClass);
    }

    public ObjectDef withBuilderClass(Class<?> builderClass) {
        return this.builderClass == builderClass ? this : new ObjectDef(this.fields, this.objectType, builderClass);
    }
}

