/*
 * Decompiled with CFR 0.152.
 */
package io.typecraft.bukkit.object;

import io.typecraft.bukkit.object.FieldDef;
import io.typecraft.bukkit.object.FieldValue;
import io.typecraft.bukkit.object.ObjectDef;
import io.typecraft.bukkit.object.Reflections;
import io.typecraft.bukkit.object.TypeDef;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.ConfigurationSerialization;

public class BukkitObjectMapper {
    private final Map<String, ObjectDef> objectDefMap = new HashMap<String, ObjectDef>();

    public Map<String, Object> encode(Object x) {
        Object object = this.encodeObject(x);
        return object instanceof Map ? (Map)object : Collections.emptyMap();
    }

    public <A> Optional<A> decode(Map<String, Object> xs, Class<A> clazz) {
        return ConfigurationSerializable.class.isAssignableFrom(clazz) ? this.decodeBukkitObject(xs).flatMap(a -> clazz.isInstance(a) ? Optional.of(clazz.cast(a)) : Optional.empty()) : this.decodeLombokObject(xs, clazz);
    }

    private <A> Optional<A> decodeLombokObject(Map<String, Object> xs, Class<A> clazz) {
        ObjectDef def = this.objectDefMap.computeIfAbsent(clazz.getTypeName(), k -> ObjectDef.from(clazz));
        if (def.isEmpty()) {
            return Optional.empty();
        }
        try {
            Constructor<?> constructor = def.getBuilderClass().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            Object builderInstance = constructor.newInstance(new Object[0]);
            for (FieldDef field : def.getFields()) {
                Object x = xs.get(field.getName());
                if (x == null) continue;
                Object subValue = this.decodeObject(x, field.getFieldType());
                FieldValue subFieldValue = FieldValue.of(field.getFieldType(), subValue);
                Reflections.invokeMethod(builderInstance, field.getName(), subFieldValue);
            }
            Object value = Reflections.invokeMethod(builderInstance, "build", new FieldValue[0]).orElse(null);
            return clazz.isInstance(value) ? Optional.of(clazz.cast(value)) : Optional.empty();
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Object decodeObject(Object x, TypeDef typeDef) {
        Function<String, Optional<Object>> parser;
        Class<?> fieldClass;
        ObjectDef objectDef;
        if (x instanceof ConfigurationSection && !ConfigurationSection.class.isAssignableFrom(typeDef.getJavaClass())) {
            x = ((ConfigurationSection)x).getValues(false);
        }
        if (!(objectDef = this.objectDefMap.computeIfAbsent((fieldClass = typeDef.getJavaClass()).getTypeName(), k -> ObjectDef.from(fieldClass))).isEmpty()) {
            return this.decode((Map)x, objectDef.getObjectType().getJavaClass()).orElse(null);
        }
        List<TypeDef> typeParams = typeDef.getTypeParameters();
        if (x instanceof Map) {
            TypeDef kType = typeParams.size() >= 1 ? typeParams.get(0) : TypeDef.object;
            TypeDef vType = typeParams.size() >= 2 ? typeParams.get(1) : TypeDef.object;
            return ((Map)x).entrySet().stream().map(pair -> new AbstractMap.SimpleEntry<Object, Object>(this.decodeObject(pair.getKey(), kType), this.decodeObject(pair.getValue(), vType))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (x instanceof Collection) {
            TypeDef vType = typeParams.size() >= 1 ? typeParams.get(0) : TypeDef.object;
            Collector collector = Set.class.isAssignableFrom(typeDef.getJavaClass()) ? Collectors.toSet() : Collectors.toList();
            return ((Collection)x).stream().map(a -> this.decodeObject(a, vType)).collect(collector);
        }
        if (fieldClass == UUID.class) {
            return UUID.fromString(x.toString());
        }
        if (fieldClass == Map.class && x instanceof ConfigurationSection) {
            return ((ConfigurationSection)x).getValues(false);
        }
        if (Enum.class.isAssignableFrom(fieldClass)) {
            try {
                return Enum.valueOf(fieldClass, x.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return (parser = Reflections.parserByPrimitives.get(fieldClass)) != null ? parser.apply(x.toString()).orElse(null) : x;
    }

    private Optional<ConfigurationSerializable> decodeBukkitObject(Map<String, Object> xs) {
        return Optional.ofNullable(ConfigurationSerialization.deserializeObject(xs));
    }

    private Object encodeObject(Object x) {
        if (x instanceof ConfigurationSerializable) {
            return this.encodeBukkitObject((ConfigurationSerializable)x);
        }
        if (x instanceof Collection) {
            return ((Collection)x).stream().map(this::encodeObject).collect(Collectors.toList());
        }
        if (x instanceof Map) {
            return ((Map)x).entrySet().stream().map(pair -> new AbstractMap.SimpleEntry<String, Object>(pair.getKey().toString(), this.encodeObject(pair.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return this.encodeLombokObject(x);
    }

    private Object encodeLombokObject(Object x) {
        if (Reflections.checkPrimitive(x.getClass()) || x instanceof ConfigurationSection) {
            return x;
        }
        if (x instanceof UUID) {
            return x.toString();
        }
        if (x instanceof Enum) {
            return ((Enum)x).name();
        }
        Class<?> clazz = x.getClass();
        ObjectDef info = this.objectDefMap.computeIfAbsent(clazz.getTypeName(), k -> ObjectDef.from(clazz));
        if (info.getFields().isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (FieldDef field : info.getFields()) {
            Object value = Reflections.invokeMethod(x, field.getGetterName(), new FieldValue[0]).orElse(null);
            Object encoded = value != null ? this.encodeObject(value) : null;
            if (encoded == null) continue;
            ret.put(field.getName(), encoded);
        }
        return ret;
    }

    private Map<String, Object> encodeBukkitObject(ConfigurationSerializable x) {
        Map serialized = x.serialize();
        HashMap<String, Object> ret = new HashMap<String, Object>(serialized.size());
        for (Map.Entry pair : serialized.entrySet()) {
            ret.put((String)pair.getKey(), this.encodeObject(pair.getValue()));
        }
        ret.put("==", ConfigurationSerialization.getAlias(x.getClass()));
        return ret;
    }
}

