/*
 * Decompiled with CFR 0.152.
 */
package io.trygvis.appsh.booter.jetty;

import io.trygvis.appsh.booter.jetty.Main;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyWebServer {
    private File basedir = new File("").getAbsoluteFile();
    private int httpPort = 8080;
    List<Context> contexts = new ArrayList<Context>();

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public Context addContext(Context context) throws Exception {
        this.contexts.add(context);
        return context;
    }

    public void run() throws Exception {
        File tmp = new File(this.basedir, "tmp/jetty-booter");
        if (!tmp.isDirectory() && !tmp.mkdirs()) {
            throw new IOException("Could not create temp directory: " + tmp);
        }
        File extraClasspath = new File(this.basedir, "etc");
        if (!extraClasspath.isDirectory()) {
            extraClasspath = null;
        }
        System.setProperty("org.mortbay.log.class", StdErrLog.class.getName());
        Server server = new Server();
        if (this.httpPort != 0) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.httpPort);
            connector.setForwarded(true);
            server.addConnector((Connector)connector);
        }
        ContextHandlerCollection handler = new ContextHandlerCollection();
        server.setHandler((Handler)handler);
        ServerSettings settings = new ServerSettings(tmp, extraClasspath != null ? extraClasspath.getAbsolutePath() : null);
        for (Context context : this.contexts) {
            handler.addHandler((Handler)context.toJetty(settings));
        }
        server.start();
        server.join();
    }

    public static class ClasspathContext
    extends Context {
        private final String prefix;

        public ClasspathContext(String contextPath, String prefix) {
            super(contextPath);
            this.prefix = prefix;
        }

        protected ContextHandler toJetty(ServerSettings settings) throws IOException {
            Enumeration<URL> enumeration;
            String prefix = this.prefix;
            String tmpName = this.contextPath.length() == 1 ? "ROOT-web" : this.contextPath.substring(1).replace('/', '_');
            File war = new File(settings.tmp, tmpName);
            if (war.isDirectory()) {
                IO.delete((File)war);
            }
            if (!war.mkdirs()) {
                System.err.println("Could not create directory: " + war);
                System.exit(-1);
            }
            if (prefix.startsWith("/")) {
                prefix = prefix.substring(1);
            }
            if (!(enumeration = Main.class.getClassLoader().getResources(prefix)).hasMoreElements()) {
                System.err.println("Could not look up classpath resource: '" + prefix + "'.");
                System.exit(-1);
            }
            while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                try {
                    Resource resource = Resource.newResource((URL)url);
                    resource.copyTo(war);
                }
                catch (IOException e) {
                    System.err.println("Unable to extract " + url.toExternalForm() + " to " + war + ": " + e.getMessage());
                    System.exit(-1);
                }
            }
            return WarContext.warContext(settings, this.contextPath, war);
        }
    }

    public static class WarContext
    extends Context {
        private final File webapp;

        public WarContext(String contextPath, File webapp) throws IOException {
            super(contextPath);
            this.webapp = webapp;
            if (!webapp.exists()) {
                throw new IOException("File has to exist: " + webapp);
            }
        }

        protected ContextHandler toJetty(ServerSettings settings) {
            return WarContext.warContext(settings, this.contextPath, this.webapp);
        }

        public static ContextHandler warContext(ServerSettings settings, String contextPath, File webapp) {
            WebAppContext context = new WebAppContext();
            context.setInitParameter("org.eclipse.jetty.servlet.Default.useFileMappedBuffer", "false");
            context.setContextPath(contextPath);
            context.setWar(webapp.getAbsolutePath());
            if (settings.extraClasspath != null) {
                context.setExtraClasspath(settings.extraClasspath);
            }
            context.setExtractWAR(true);
            String dir = contextPath.substring(1);
            if (dir.length() == 0) {
                dir = "ROOT-tmp";
            }
            context.setTempDirectory(new File(settings.tmp, dir));
            return context;
        }
    }

    private static abstract class Context {
        public final String contextPath;

        protected Context(String contextPath) {
            if (!contextPath.startsWith("/")) {
                throw new RuntimeException("The context path has to start with '/'.");
            }
            this.contextPath = contextPath;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        protected abstract ContextHandler toJetty(ServerSettings var1) throws IOException;
    }

    public static class ServerSettings {
        public final File tmp;
        public final String extraClasspath;

        public ServerSettings(File tmp, String extraClasspath) {
            this.tmp = tmp;
            this.extraClasspath = extraClasspath;
        }
    }
}

