/*
 * Decompiled with CFR 0.152.
 */
package io.trygvis.appsh.booter.jetty;

import io.trygvis.appsh.booter.jetty.JettyWebServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jetty.util.IO;

public class Main {
    public static final String PROPERTIES_FILE = "etc/booter.properties";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) throws Exception {
        JettyWebServer server;
        File basedir = new File(System.getProperty("basedir", new File("").getAbsolutePath()));
        File booterPropertiesFile = new File(basedir, PROPERTIES_FILE);
        Properties properties = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(booterPropertiesFile);
            properties.load(new InputStreamReader((InputStream)is, "utf-8"));
        }
        catch (FileNotFoundException e) {
            System.err.println("Can't read: " + booterPropertiesFile);
            System.exit(1);
            IO.close((InputStream)is);
        }
        catch (IOException e2) {
            System.err.println("Error reading: " + booterPropertiesFile);
            System.exit(1);
            {
                catch (Throwable throwable) {
                    IO.close(is);
                    throw throwable;
                }
            }
            IO.close((InputStream)is);
        }
        IO.close((InputStream)is);
        Main.setStreams(basedir, properties);
        try {
            server = new JettyWebServer();
            server.setBasedir(basedir);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = entry.getKey().toString();
                String value = entry.getValue().toString();
                if (!key.startsWith("context.")) continue;
                server.addContext(key.substring(8), new File(basedir, value));
            }
            String httpPort = properties.getProperty("httpPort", System.getenv("httpPort"));
            if (httpPort != null) {
                server.setHttpPort(Integer.parseInt(httpPort));
            }
        }
        catch (Exception e) {
            System.err.println("Error while configuring Jetty.");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            server.run();
        }
        catch (Exception e) {
            System.err.println("Error while starting Jetty.");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void setStreams(File basedir, Properties properties) throws IOException {
        String logS = properties.getProperty("log");
        if (logS == null) {
            return;
        }
        File log = new File(basedir, logS);
        if (!log.getParentFile().isDirectory() && !log.getParentFile().mkdirs()) {
            System.err.println("Unable to create directory: " + log.getAbsolutePath());
            System.exit(1);
        }
        PrintStream writer = new PrintStream(new FileOutputStream(log));
        System.setOut(writer);
        System.setErr(writer);
    }
}

