/*
 * Decompiled with CFR 0.152.
 */
package io.trygvis.appsh.booter.jetty;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyWebServer {
    private File basedir = new File("").getAbsoluteFile();
    private File tmp;
    private File extraClasspath;
    private int httpPort = 8080;
    List<Context> contexts = new ArrayList<Context>();

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setHttpPort(int port) {
        this.httpPort = port;
    }

    public Context addContext(String contextPath, File webapp) throws Exception {
        Context context = new Context();
        context.setContextPath(contextPath);
        context.setWebapp(webapp);
        this.contexts.add(context);
        return context;
    }

    public void run() throws Exception {
        this.tmp = new File(this.basedir, "tmp");
        if (!this.tmp.isDirectory() && !this.tmp.mkdirs()) {
            throw new IOException("Could not create temp directory: " + this.tmp);
        }
        this.extraClasspath = new File(this.basedir, "etc");
        if (!this.extraClasspath.isDirectory()) {
            this.extraClasspath = null;
        }
        System.setProperty("org.mortbay.log.class", StdErrLog.class.getName());
        Server server = new Server();
        if (this.httpPort != 0) {
            SelectChannelConnector connector = new SelectChannelConnector();
            connector.setPort(this.httpPort);
            connector.setForwarded(true);
            server.addConnector((Connector)connector);
        }
        ContextHandlerCollection handler = new ContextHandlerCollection();
        server.setHandler((Handler)handler);
        for (Context context : this.contexts) {
            handler.addHandler((Handler)context.toJetty());
        }
        server.start();
        server.join();
    }

    public class Context {
        private File webapp;
        private String contextPath;

        public void setWebapp(File webapp) throws IOException {
            if (!webapp.exists()) {
                throw new IOException("File has to exist: " + webapp);
            }
            this.webapp = webapp;
        }

        public void setContextPath(String contextPath) {
            if (!contextPath.startsWith("/")) {
                throw new RuntimeException("The context path has to start with '/'.");
            }
            this.contextPath = contextPath;
        }

        public ContextHandler toJetty() {
            WebAppContext context = new WebAppContext();
            context.setContextPath(this.contextPath);
            context.setWar(this.webapp.getAbsolutePath());
            if (JettyWebServer.this.extraClasspath != null) {
                context.setExtraClasspath(JettyWebServer.this.extraClasspath.getAbsolutePath());
            }
            context.setExtractWAR(true);
            String dir = this.contextPath.substring(1);
            if (dir.length() == 0) {
                dir = "ROOT";
            }
            context.setTempDirectory(new File(JettyWebServer.this.tmp, dir));
            return context;
        }
    }
}

