/*
 * Decompiled with CFR 0.152.
 */
package io.tronalddump.client;

import io.tronalddump.client.Page;
import io.tronalddump.client.Pageable;
import io.tronalddump.client.Quote;
import io.tronalddump.client.TronaldException;
import io.tronalddump.client.TronaldHttpException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class TronaldClient {
    public static final String BASE_URL = "https://api.tronalddump.io";
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public List<String> getTags() throws TronaldException {
        try {
            HttpURLConnection conn = this.createConnection("https://api.tronalddump.io/tags");
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                ArrayList<String> tags = new ArrayList<String>();
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                JSONArray jsonTags = jsonObject.getJSONArray("_embedded");
                for (int i = 0; i < jsonTags.length(); ++i) {
                    tags.add(jsonTags.getString(i));
                }
                return tags;
            }
            TronaldHttpException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new TronaldException("Error retrieving tags", e);
        }
    }

    public Quote getQuote(String id) throws TronaldException {
        Objects.requireNonNull(id, "'id' must not be null");
        try {
            HttpURLConnection conn = this.createConnection("https://api.tronalddump.io/quote/" + this.urlEncode(id));
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                return this.parseQuote(jsonObject);
            }
            TronaldHttpException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new TronaldException("Error retrieving quote", e);
        }
    }

    public Quote getRandomQuote() throws TronaldException {
        return this.getRandomQuote(null);
    }

    public Quote getRandomQuote(String tag) throws TronaldException {
        try {
            HttpURLConnection conn = tag == null ? this.createConnection("https://api.tronalddump.io/random/quote") : this.createConnection("https://api.tronalddump.io/random/quote?tag=" + this.urlEncode(tag));
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                return this.parseQuote(jsonObject);
            }
            TronaldHttpException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new TronaldException("Error retrieving random quote", e);
        }
    }

    public Page<Quote> search(String query) throws TronaldException {
        return this.search(query, Pageable.PageableBuilder.aPageable().build());
    }

    public Page<Quote> search(String query, int size) throws TronaldException {
        return this.search(query, Pageable.PageableBuilder.aPageable().withSize(size).build());
    }

    public Page<Quote> search(String query, int page, int size) throws TronaldException {
        return this.search(query, Pageable.PageableBuilder.aPageable().withPage(page).withSize(size).build());
    }

    public Page<Quote> search(String query, Pageable pageable) throws TronaldException {
        Objects.requireNonNull(query, "'query' must not be null");
        Objects.requireNonNull(pageable, "'pageable' must not be null");
        try {
            StringBuilder sb = new StringBuilder().append("https://api.tronalddump.io/search/quote").append("?query=").append(this.urlEncode(query)).append("&page=").append(pageable.getPage()).append("&size=").append(pageable.getSize());
            HttpURLConnection conn = this.createConnection(sb.toString());
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                JSONArray jsonQuotes;
                JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getInputStream()));
                long total = jsonObject.optLong("total");
                ArrayList<Quote> content = new ArrayList<Quote>();
                JSONObject jsonEmbedded = jsonObject.optJSONObject("_embedded");
                if (jsonEmbedded != null && (jsonQuotes = jsonEmbedded.optJSONArray("quotes")) != null && jsonQuotes.length() > 0) {
                    for (int i = 0; i < jsonQuotes.length(); ++i) {
                        JSONObject jsonQuote = jsonQuotes.optJSONObject(i);
                        Quote quote = this.parseQuote(jsonQuote);
                        content.add(quote);
                    }
                }
                return new Page<Quote>(content, pageable, total);
            }
            TronaldHttpException e = this.createException(conn);
            throw e;
        }
        catch (IOException e) {
            throw new TronaldException("Error searching quotes", e);
        }
    }

    private String getVersion() {
        Package pkg = TronaldClient.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    private String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TronaldException("Unable to url encode string: " + s, e);
        }
    }

    private HttpURLConnection createConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setRequestProperty("User-Agent", "tronalddump-io/client-java-" + this.getVersion());
        return conn;
    }

    private TronaldHttpException createException(HttpURLConnection conn) throws IOException {
        JSONObject jsonObject = new JSONObject(new JSONTokener(conn.getErrorStream()));
        int status = jsonObject.optInt("status");
        String message = jsonObject.optString("message");
        return new TronaldHttpException(status, message);
    }

    private Quote parseQuote(JSONObject jsonObject) {
        JSONArray jsonTags;
        String appearedAt;
        JSONArray jsonSources;
        Quote quote = new Quote();
        quote.setId(jsonObject.optString("quote_id"));
        quote.setValue(jsonObject.optString("value"));
        JSONObject jsonEmbedded = jsonObject.optJSONObject("_embedded");
        if (jsonEmbedded != null && (jsonSources = jsonEmbedded.optJSONArray("source")) != null && jsonSources.length() > 0) {
            JSONObject jsonSource = jsonSources.optJSONObject(0);
            quote.setSourceUrl(jsonSource.optString("url"));
        }
        if ((appearedAt = jsonObject.optString("appeared_at")) != null && appearedAt.length() > 0) {
            try {
                quote.setDate(DATE_FORMAT.parse(appearedAt));
            }
            catch (ParseException jsonSource) {
                // empty catch block
            }
        }
        if ((jsonTags = jsonObject.optJSONArray("tags")) != null) {
            for (int i = 0; i < jsonTags.length(); ++i) {
                quote.addTag(jsonTags.getString(i));
            }
        }
        return quote;
    }
}

