/*
 * Decompiled with CFR 0.152.
 */
package io.tronalddump.client;

import java.io.Serializable;

public class Pageable
implements Serializable {
    private static final long serialVersionUID = -6728660557581983504L;
    private int page;
    private int size;

    public Pageable(int page, int size) {
        if (page < 1) {
            throw new IllegalArgumentException("'page' must not be less than 1");
        }
        if (size < 1) {
            throw new IllegalArgumentException("'size' must not be less than 1");
        }
        this.page = page;
        this.size = size;
    }

    public int getPage() {
        return this.page;
    }

    public int getSize() {
        return this.size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pageable other = (Pageable)o;
        if (this.page != other.page) {
            return false;
        }
        return this.size == other.size;
    }

    public int hashCode() {
        int result = this.page;
        result = 31 * result + this.size;
        return result;
    }

    public String toString() {
        return "Pageable{page=" + this.page + ", size=" + this.size + '}';
    }

    public static final class PageableBuilder {
        private int page = 1;
        private int size = 25;

        private PageableBuilder() {
        }

        public static PageableBuilder aPageable() {
            return new PageableBuilder();
        }

        public PageableBuilder withPage(int page) {
            this.page = page;
            return this;
        }

        public PageableBuilder withSize(int size) {
            this.size = size;
            return this;
        }

        public Pageable build() {
            Pageable pageable = new Pageable(this.page, this.size);
            return pageable;
        }
    }
}

