/*
 * Decompiled with CFR 0.152.
 */
package io.tronalddump.client;

import io.tronalddump.client.Pageable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class Page<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = -2555433043215957877L;
    private List<T> content = new ArrayList<T>();
    private Pageable pageable;
    private long total;

    public Page(List<T> content, Pageable pageable, long total) {
        this.content = Objects.requireNonNull(content, "'content' must not be null");
        this.pageable = Objects.requireNonNull(pageable, "'pageable' must not be null");
        if (total < 0L) {
            throw new IllegalArgumentException("'total' must not be less than 0");
        }
        this.total = total;
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    public List<T> getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public int getNumber() {
        return this.pageable.getPage();
    }

    public int getSize() {
        return this.pageable.getSize();
    }

    public int getNumberOfElements() {
        return this.content.size();
    }

    public int getTotalPages() {
        int val = (int)Math.ceil((double)this.total / (double)this.getSize());
        return val == 0 ? 1 : val;
    }

    public long getTotalElements() {
        return this.total;
    }

    public boolean hasNext() {
        return this.getNumber() + 1 < this.getTotalPages();
    }

    public boolean hasPrevious() {
        return this.getNumber() > 1;
    }

    public boolean isFirst() {
        return !this.hasPrevious();
    }

    public boolean isLast() {
        return !this.hasNext();
    }

    public Pageable nextPageable() {
        if (this.hasNext()) {
            return new Pageable(this.pageable.getPage() + 1, this.pageable.getSize());
        }
        return null;
    }

    public Pageable previousPageable() {
        if (this.hasPrevious()) {
            return new Pageable(this.pageable.getPage() - 1, this.pageable.getSize());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page other = (Page)o;
        if (this.total != other.total) {
            return false;
        }
        if (this.content != null ? !this.content.equals(other.content) : other.content != null) {
            return false;
        }
        return this.pageable != null ? this.pageable.equals(other.pageable) : other.pageable == null;
    }

    public int hashCode() {
        int result = this.content != null ? this.content.hashCode() : 0;
        result = 31 * result + (this.pageable != null ? this.pageable.hashCode() : 0);
        result = 31 * result + (int)(this.total ^ this.total >>> 32);
        return result;
    }

    public String toString() {
        return "Page{content=" + this.content + ", pageable=" + this.pageable + ", total=" + this.total + '}';
    }
}

