/*
 * Decompiled with CFR 0.152.
 */
package io.trakerr.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import io.trakerr.model.CustomData;
import io.trakerr.model.Stacktrace;
import java.util.Objects;

public class AppEvent {
    @SerializedName(value="apiKey")
    private String apiKey = null;
    @SerializedName(value="classification")
    private String classification = null;
    @SerializedName(value="eventType")
    private String eventType = null;
    @SerializedName(value="eventMessage")
    private String eventMessage = null;
    @SerializedName(value="eventTime")
    private Long eventTime = null;
    @SerializedName(value="eventStacktrace")
    private Stacktrace eventStacktrace = null;
    @SerializedName(value="eventUser")
    private String eventUser = null;
    @SerializedName(value="eventSession")
    private String eventSession = null;
    @SerializedName(value="contextAppVersion")
    private String contextAppVersion = null;
    @SerializedName(value="contextEnvName")
    private String contextEnvName = null;
    @SerializedName(value="contextEnvVersion")
    private String contextEnvVersion = null;
    @SerializedName(value="contextEnvHostname")
    private String contextEnvHostname = null;
    @SerializedName(value="contextAppBrowser")
    private String contextAppBrowser = null;
    @SerializedName(value="contextAppBrowserVersion")
    private String contextAppBrowserVersion = null;
    @SerializedName(value="contextAppOS")
    private String contextAppOS = null;
    @SerializedName(value="contextAppOSVersion")
    private String contextAppOSVersion = null;
    @SerializedName(value="contextDataCenter")
    private String contextDataCenter = null;
    @SerializedName(value="contextDataCenterRegion")
    private String contextDataCenterRegion = null;
    @SerializedName(value="customProperties")
    private CustomData customProperties = null;
    @SerializedName(value="customSegments")
    private CustomData customSegments = null;

    public AppEvent apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="API key generated for the application")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public AppEvent classification(String classification) {
        this.classification = classification;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="one of 'debug','info','warning','error' or a custom string")
    public String getClassification() {
        return this.classification;
    }

    public void setClassification(String classification) {
        this.classification = classification;
    }

    public AppEvent eventType(String eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="type or event or error (eg. NullPointerException)")
    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public AppEvent eventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="message containing details of the event or error")
    public String getEventMessage() {
        return this.eventMessage;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = eventMessage;
    }

    public AppEvent eventTime(Long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) event time in ms since epoch")
    public Long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Long eventTime) {
        this.eventTime = eventTime;
    }

    public AppEvent eventStacktrace(Stacktrace eventStacktrace) {
        this.eventStacktrace = eventStacktrace;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public Stacktrace getEventStacktrace() {
        return this.eventStacktrace;
    }

    public void setEventStacktrace(Stacktrace eventStacktrace) {
        this.eventStacktrace = eventStacktrace;
    }

    public AppEvent eventUser(String eventUser) {
        this.eventUser = eventUser;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) event user identifying a user")
    public String getEventUser() {
        return this.eventUser;
    }

    public void setEventUser(String eventUser) {
        this.eventUser = eventUser;
    }

    public AppEvent eventSession(String eventSession) {
        this.eventSession = eventSession;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) session identification")
    public String getEventSession() {
        return this.eventSession;
    }

    public void setEventSession(String eventSession) {
        this.eventSession = eventSession;
    }

    public AppEvent contextAppVersion(String contextAppVersion) {
        this.contextAppVersion = contextAppVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) application version information")
    public String getContextAppVersion() {
        return this.contextAppVersion;
    }

    public void setContextAppVersion(String contextAppVersion) {
        this.contextAppVersion = contextAppVersion;
    }

    public AppEvent contextEnvName(String contextEnvName) {
        this.contextEnvName = contextEnvName;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) one of 'development','staging','production' or a custom string")
    public String getContextEnvName() {
        return this.contextEnvName;
    }

    public void setContextEnvName(String contextEnvName) {
        this.contextEnvName = contextEnvName;
    }

    public AppEvent contextEnvVersion(String contextEnvVersion) {
        this.contextEnvVersion = contextEnvVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) version of environment")
    public String getContextEnvVersion() {
        return this.contextEnvVersion;
    }

    public void setContextEnvVersion(String contextEnvVersion) {
        this.contextEnvVersion = contextEnvVersion;
    }

    public AppEvent contextEnvHostname(String contextEnvHostname) {
        this.contextEnvHostname = contextEnvHostname;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) hostname or ID of environment")
    public String getContextEnvHostname() {
        return this.contextEnvHostname;
    }

    public void setContextEnvHostname(String contextEnvHostname) {
        this.contextEnvHostname = contextEnvHostname;
    }

    public AppEvent contextAppBrowser(String contextAppBrowser) {
        this.contextAppBrowser = contextAppBrowser;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) browser name if running in a browser (eg. Chrome)")
    public String getContextAppBrowser() {
        return this.contextAppBrowser;
    }

    public void setContextAppBrowser(String contextAppBrowser) {
        this.contextAppBrowser = contextAppBrowser;
    }

    public AppEvent contextAppBrowserVersion(String contextAppBrowserVersion) {
        this.contextAppBrowserVersion = contextAppBrowserVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) browser version if running in a browser")
    public String getContextAppBrowserVersion() {
        return this.contextAppBrowserVersion;
    }

    public void setContextAppBrowserVersion(String contextAppBrowserVersion) {
        this.contextAppBrowserVersion = contextAppBrowserVersion;
    }

    public AppEvent contextAppOS(String contextAppOS) {
        this.contextAppOS = contextAppOS;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) OS the application is running on")
    public String getContextAppOS() {
        return this.contextAppOS;
    }

    public void setContextAppOS(String contextAppOS) {
        this.contextAppOS = contextAppOS;
    }

    public AppEvent contextAppOSVersion(String contextAppOSVersion) {
        this.contextAppOSVersion = contextAppOSVersion;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) OS version the application is running on")
    public String getContextAppOSVersion() {
        return this.contextAppOSVersion;
    }

    public void setContextAppOSVersion(String contextAppOSVersion) {
        this.contextAppOSVersion = contextAppOSVersion;
    }

    public AppEvent contextDataCenter(String contextDataCenter) {
        this.contextDataCenter = contextDataCenter;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) Data center the application is running on or connected to")
    public String getContextDataCenter() {
        return this.contextDataCenter;
    }

    public void setContextDataCenter(String contextDataCenter) {
        this.contextDataCenter = contextDataCenter;
    }

    public AppEvent contextDataCenterRegion(String contextDataCenterRegion) {
        this.contextDataCenterRegion = contextDataCenterRegion;
        return this;
    }

    @ApiModelProperty(example="null", value="(optional) Data center region")
    public String getContextDataCenterRegion() {
        return this.contextDataCenterRegion;
    }

    public void setContextDataCenterRegion(String contextDataCenterRegion) {
        this.contextDataCenterRegion = contextDataCenterRegion;
    }

    public AppEvent customProperties(CustomData customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CustomData getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(CustomData customProperties) {
        this.customProperties = customProperties;
    }

    public AppEvent customSegments(CustomData customSegments) {
        this.customSegments = customSegments;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CustomData getCustomSegments() {
        return this.customSegments;
    }

    public void setCustomSegments(CustomData customSegments) {
        this.customSegments = customSegments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppEvent appEvent = (AppEvent)o;
        return Objects.equals(this.apiKey, appEvent.apiKey) && Objects.equals(this.classification, appEvent.classification) && Objects.equals(this.eventType, appEvent.eventType) && Objects.equals(this.eventMessage, appEvent.eventMessage) && Objects.equals(this.eventTime, appEvent.eventTime) && Objects.equals(this.eventStacktrace, appEvent.eventStacktrace) && Objects.equals(this.eventUser, appEvent.eventUser) && Objects.equals(this.eventSession, appEvent.eventSession) && Objects.equals(this.contextAppVersion, appEvent.contextAppVersion) && Objects.equals(this.contextEnvName, appEvent.contextEnvName) && Objects.equals(this.contextEnvVersion, appEvent.contextEnvVersion) && Objects.equals(this.contextEnvHostname, appEvent.contextEnvHostname) && Objects.equals(this.contextAppBrowser, appEvent.contextAppBrowser) && Objects.equals(this.contextAppBrowserVersion, appEvent.contextAppBrowserVersion) && Objects.equals(this.contextAppOS, appEvent.contextAppOS) && Objects.equals(this.contextAppOSVersion, appEvent.contextAppOSVersion) && Objects.equals(this.contextDataCenter, appEvent.contextDataCenter) && Objects.equals(this.contextDataCenterRegion, appEvent.contextDataCenterRegion) && Objects.equals(this.customProperties, appEvent.customProperties) && Objects.equals(this.customSegments, appEvent.customSegments);
    }

    public int hashCode() {
        return Objects.hash(this.apiKey, this.classification, this.eventType, this.eventMessage, this.eventTime, this.eventStacktrace, this.eventUser, this.eventSession, this.contextAppVersion, this.contextEnvName, this.contextEnvVersion, this.contextEnvHostname, this.contextAppBrowser, this.contextAppBrowserVersion, this.contextAppOS, this.contextAppOSVersion, this.contextDataCenter, this.contextDataCenterRegion, this.customProperties, this.customSegments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppEvent {\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    classification: ").append(this.toIndentedString(this.classification)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString(this.eventType)).append("\n");
        sb.append("    eventMessage: ").append(this.toIndentedString(this.eventMessage)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventStacktrace: ").append(this.toIndentedString(this.eventStacktrace)).append("\n");
        sb.append("    eventUser: ").append(this.toIndentedString(this.eventUser)).append("\n");
        sb.append("    eventSession: ").append(this.toIndentedString(this.eventSession)).append("\n");
        sb.append("    contextAppVersion: ").append(this.toIndentedString(this.contextAppVersion)).append("\n");
        sb.append("    contextEnvName: ").append(this.toIndentedString(this.contextEnvName)).append("\n");
        sb.append("    contextEnvVersion: ").append(this.toIndentedString(this.contextEnvVersion)).append("\n");
        sb.append("    contextEnvHostname: ").append(this.toIndentedString(this.contextEnvHostname)).append("\n");
        sb.append("    contextAppBrowser: ").append(this.toIndentedString(this.contextAppBrowser)).append("\n");
        sb.append("    contextAppBrowserVersion: ").append(this.toIndentedString(this.contextAppBrowserVersion)).append("\n");
        sb.append("    contextAppOS: ").append(this.toIndentedString(this.contextAppOS)).append("\n");
        sb.append("    contextAppOSVersion: ").append(this.toIndentedString(this.contextAppOSVersion)).append("\n");
        sb.append("    contextDataCenter: ").append(this.toIndentedString(this.contextDataCenter)).append("\n");
        sb.append("    contextDataCenterRegion: ").append(this.toIndentedString(this.contextDataCenterRegion)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("    customSegments: ").append(this.toIndentedString(this.customSegments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

