package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mopub.common.LifecycleListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;

import java.util.Map;

import io.tpmn.suezx.SuezXError;
import io.tpmn.suezx.SuezXInterstitialAd;

import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.CLICKED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.LOAD_FAILED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.LOAD_SUCCESS;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.SHOW_ATTEMPTED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.SHOW_FAILED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.SHOW_SUCCESS;
import static com.mopub.mobileads.SuezXAdapterConfiguration.fetchGdprAppliance;
import static com.mopub.mobileads.SuezXAdapterConfiguration.fetchGdprConsent;

public class SuezXInterstitial extends BaseAd {

    private static final String ADAPTER_NAME = SuezXInterstitial.class.getSimpleName();
    public static final String PUBLISHER_ID_KEY = "pi";
    public static final String INVENTORY_ID_KEY = "ii";
    public static final String YOB_KEY = "yob";
    public static final String GENDER_KEY = "gender";

    private String publisherId = "";
    private String inventoryId = "";

    private SuezXInterstitialAd suezXInterstitialAd;


    @Override
    protected boolean checkAndInitializeSdk(@NonNull final Activity launcherActivity, @NonNull final AdData adData) {
//        Log.d(ADAPTER_NAME, "checkAndInitializeSdk");

        return false;
    }

    @Override
    protected void load(@NonNull final Context context, @NonNull final AdData adData) {
//        Log.d(ADAPTER_NAME, "load");

        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(adData);

        final Map<String, String> extras = adData.getExtras();
        publisherId = extras.get(PUBLISHER_ID_KEY);
        inventoryId = extras.get(INVENTORY_ID_KEY);

        /*Activity activity = getActivityFromContext(context);
        if (activity == null) {
            MoPubLog.log(CUSTOM, ADAPTER_NAME, "ironSource load interstitial must be called from an " + "Activity context");
            MoPubLog.log(getAdNetworkId(), LOAD_FAILED, ADAPTER_NAME, MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR.getIntCode(), MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
        }
        suezXInterstitialAd = new SuezXInterstitialAd(activity);*/
        suezXInterstitialAd = new SuezXInterstitialAd(getActivityFromContext(context));
        suezXInterstitialAd.setPublisherId(publisherId);
        suezXInterstitialAd.setInventoryId(inventoryId);
        suezXInterstitialAd.setFullSize(true);
        suezXInterstitialAd.setInterstitialListener(new SuezXInterstitialAd.SuezXInterstitialListener() {
            @Override
            public void onInterstitialLoaded() {
                if (mLoadListener != null) {
                    mLoadListener.onAdLoaded();
                    MoPubLog.log(getAdNetworkId(), LOAD_SUCCESS, ADAPTER_NAME);
                }
            }

            @Override
            public void onInterstitialFailed(SuezXError suezXError) {
                MoPubErrorCode moPubErrorCode = getMoPubErrorCode(suezXError);

                MoPubLog.log(getAdNetworkId(), LOAD_FAILED, ADAPTER_NAME, moPubErrorCode.getIntCode(), moPubErrorCode);

                if (mInteractionListener == null && mLoadListener != null) {
                    mLoadListener.onAdLoadFailed(moPubErrorCode);
                }
                else if (mInteractionListener != null) {
                    mInteractionListener.onAdFailed(moPubErrorCode);
                }
            }

            @Override
            public void onInterstitialShown() {
                MoPubLog.log(getAdNetworkId(), SHOW_SUCCESS, ADAPTER_NAME);

                if (mInteractionListener != null) {
                    mInteractionListener.onAdShown();
                }
            }

            @Override
            public void onInterstitialClicked() {
                if (mInteractionListener != null) {
                    mInteractionListener.onAdClicked();
                }

                MoPubLog.log(getAdNetworkId(), CLICKED, ADAPTER_NAME);
            }

            @Override
            public void onInterstitialDismissed() {
                if (mInteractionListener != null) {
                    mInteractionListener.onAdDismissed();
                }
            }
        });
        suezXInterstitialAd.setGdpr(fetchGdprAppliance());
        suezXInterstitialAd.setGdprConsent(fetchGdprConsent());
        suezXInterstitialAd.setYob(extras.get(YOB_KEY));
        suezXInterstitialAd.setGender(extras.get(GENDER_KEY));
        suezXInterstitialAd.loadAd();
    }

    @Override
    protected void show() {
//        Log.d(ADAPTER_NAME, "show");

        MoPubLog.log(getAdNetworkId(), SHOW_ATTEMPTED, ADAPTER_NAME);

        if (suezXInterstitialAd != null) {
            suezXInterstitialAd.showAd();
        }
        else {
            MoPubLog.log(getAdNetworkId(), SHOW_FAILED, ADAPTER_NAME,
                    MoPubErrorCode.NETWORK_NO_FILL.getIntCode(),
                    MoPubErrorCode.NETWORK_NO_FILL);
            if (mInteractionListener != null) {
                mInteractionListener.onAdFailed(MoPubErrorCode.NETWORK_NO_FILL);
            }
        }
    }

    @NonNull
    public String getAdNetworkId() {
//        Log.d(ADAPTER_NAME, "getAdNetworkId");

        return publisherId + " " + inventoryId;
    }

    @Nullable
    @Override
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    @Override
    protected void onInvalidate() {
        if (suezXInterstitialAd != null) {
            suezXInterstitialAd.setInterstitialListener(null);
            suezXInterstitialAd = null;
        }
    }

    public Activity getActivityFromContext(Context context) {
        if (context == null) {
            return null;
        }
        else if (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity) context;
            }
            else {
                return getActivityFromContext(((ContextWrapper) context).getBaseContext());
            }
        }
        return null;
    }

    private MoPubErrorCode getMoPubErrorCode(SuezXError suezXError) {
        switch (suezXError) {
            case PERMISSION_DENIED:
            case INTERNAL_ERROR:
                return MoPubErrorCode.INTERNAL_ERROR;
            case SERVER_ERROR:
                return MoPubErrorCode.NETWORK_INVALID_STATE;
            case INVALID_ID:
                return MoPubErrorCode.MISSING_AD_UNIT_ID;
            case NETWORK_ERROR: // TODO
                return MoPubErrorCode.NO_CONNECTION;
            case NO_FILL:
                return MoPubErrorCode.NETWORK_NO_FILL;
            case INTERSTITIAL_LOAD_ERROR:
                return MoPubErrorCode.FULLSCREEN_LOAD_ERROR;
            case INTERSTITIAL_SHOW_ERROR:
                return MoPubErrorCode.FULLSCREEN_SHOW_ERROR;
            default:
                return MoPubErrorCode.UNSPECIFIED;
        }
    }
}