package com.mopub.mobileads;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mopub.common.LifecycleListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;
import com.mopub.common.util.Views;

import java.util.Map;

import io.tpmn.suezx.SuezXBannerAd;
import io.tpmn.suezx.SuezXError;

import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.CLICKED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.CUSTOM;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.LOAD_FAILED;
import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.LOAD_SUCCESS;
import static com.mopub.mobileads.SuezXAdapterConfiguration.fetchGdprAppliance;
import static com.mopub.mobileads.SuezXAdapterConfiguration.fetchGdprConsent;

public class SuezXBanner extends BaseAd {

    private static final String ADAPTER_NAME = SuezXBanner.class.getSimpleName();
    public static final String PUBLISHER_ID_KEY = "pi";
    public static final String INVENTORY_ID_KEY = "ii";
    public static final String YOB_KEY = "yob";
    public static final String GENDER_KEY = "gender";

    private String publisherId = "";
    private String inventoryId = "";

    private SuezXBannerAd suezXBannerAd;

    @Override
    protected boolean checkAndInitializeSdk(@NonNull final Activity launcherActivity, @NonNull final AdData adData) {
//        Log.d(ADAPTER_NAME, "checkAndInitializeSdk");

        return false;
    }

    @Override
    protected void load(@NonNull final Context context, @NonNull final AdData adData) {
//        Log.d(ADAPTER_NAME, "load");

        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(adData);

        final Map<String, String> extras = adData.getExtras();
        publisherId = extras.get(PUBLISHER_ID_KEY);
        inventoryId = extras.get(INVENTORY_ID_KEY);

        suezXBannerAd = new SuezXBannerAd(context);
        suezXBannerAd.setPublisherId(publisherId);
        suezXBannerAd.setInventoryId(inventoryId);
        suezXBannerAd.setUseCache(true);
        suezXBannerAd.setRefreshInterval(30);
        suezXBannerAd.setAdHeight(adData.getAdHeight());
        suezXBannerAd.setBannerListener(new SuezXBannerAd.SuezXBannerListener() {
            @Override
            public void onBannerLoaded() {
                MoPubLog.log(getAdNetworkId(), CUSTOM, ADAPTER_NAME, "SuezX banner ad loaded " + "successfully. Showing ad...");
                if (mLoadListener != null) {
                    mLoadListener.onAdLoaded();
                    MoPubLog.log(getAdNetworkId(), LOAD_SUCCESS, ADAPTER_NAME);
                }
            }
            @Override
            public void onBannerFailed(SuezXError suezXError) {
                MoPubLog.log(getAdNetworkId(), CUSTOM, ADAPTER_NAME, "SuezX banner ad failed " + "to load.");

                MoPubErrorCode moPubErrorCode = getMoPubErrorCode(suezXError);

                MoPubLog.log(getAdNetworkId(), LOAD_FAILED, ADAPTER_NAME, moPubErrorCode.getIntCode(), moPubErrorCode);

                if (mInteractionListener == null && mLoadListener != null) {
                    mLoadListener.onAdLoadFailed(moPubErrorCode);
                }
                else if (mInteractionListener != null) {
                    mInteractionListener.onAdFailed(moPubErrorCode);
                }
            }
            @Override
            public void onBannerClicked() {
                if (mInteractionListener != null) {
                    mInteractionListener.onAdClicked();
                }

                MoPubLog.log(getAdNetworkId(), CLICKED, ADAPTER_NAME);
            }
            @Override
            public void onBannerClosed() {
                if (mInteractionListener != null) {
                    mInteractionListener.onAdCollapsed();
                }
            }
        });
        suezXBannerAd.setGdpr(fetchGdprAppliance());
        suezXBannerAd.setGdprConsent(fetchGdprConsent());
        suezXBannerAd.setYob(extras.get(YOB_KEY));
        suezXBannerAd.setGender(extras.get(GENDER_KEY));
        suezXBannerAd.loadAd();
    }

    @Override
    public View getAdView() {
//        Log.d(ADAPTER_NAME, "getAdView");

        return suezXBannerAd;
    }

    @NonNull
    public String getAdNetworkId() {
//        Log.d(ADAPTER_NAME, "getAdNetworkId");

        return publisherId + " " + inventoryId;
    }

    @Nullable
    @Override
    protected LifecycleListener getLifecycleListener() {
        return null;
    }

    @Override
    protected void onInvalidate() {
        Views.removeFromParent(suezXBannerAd);

        if (suezXBannerAd != null) {
            suezXBannerAd.setBannerListener(null);
            suezXBannerAd.destroy();
            suezXBannerAd = null;
        }
    }

    private MoPubErrorCode getMoPubErrorCode(SuezXError suezXError) {
        switch (suezXError) {
            case PERMISSION_DENIED:
            case INTERNAL_ERROR:
                return MoPubErrorCode.INTERNAL_ERROR;
            case SERVER_ERROR:
                return MoPubErrorCode.NETWORK_INVALID_STATE;
            case INVALID_ID:
                return MoPubErrorCode.MISSING_AD_UNIT_ID;
            case NETWORK_ERROR: // TODO
                return MoPubErrorCode.NO_CONNECTION;
            case NO_FILL:
                return MoPubErrorCode.NETWORK_NO_FILL;
            default:
                return MoPubErrorCode.UNSPECIFIED;
        }
    }
}