package com.mopub.mobileads;

import android.content.Context;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.mopub.common.BaseAdapterConfiguration;
import com.mopub.common.MoPub;
import com.mopub.common.OnNetworkInitializationFinishedListener;
import com.mopub.common.Preconditions;
import com.mopub.common.logging.MoPubLog;

import java.util.Map;

import static com.mopub.common.logging.MoPubLog.AdapterLogEvent.CUSTOM_WITH_THROWABLE;

public class SuezXAdapterConfiguration extends BaseAdapterConfiguration {

    private static final String TAG = SuezXAdapterConfiguration.class.getSimpleName();
    // 4-digit versioning scheme, of which the leftmost 3 digits correspond to the network SDK version, and the last digit denotes the minor version number referring to an adapter release
    private static final String ADAPTER_VERSION = BuildConfig.VERSION_NAME;
    // lowercase String that represents your ad network name TODO
    private static final String MOPUB_NETWORK_NAME = "suezx";
    private static final String SDK_VERSION = io.tpmn.suezx.BuildConfig.VERSION_NAME;


    @NonNull
    @Override
    public String getAdapterVersion() {
//        Log.d(TAG, "getAdapterVersion");

        return ADAPTER_VERSION;
    }

    @Nullable
    @Override
    public String getBiddingToken(@NonNull final Context context) {
        return null;
    }

    @NonNull
    @Override
    public String getMoPubNetworkName() {
//        Log.d(TAG, "getMoPubNetworkName");

        return MOPUB_NETWORK_NAME;
    }

    @NonNull
    @Override
    public String getNetworkSdkVersion() {
//        Log.d(TAG, "getNetworkSdkVersion");

        return SDK_VERSION;
    }

    @Override
    public void initializeNetwork(@NonNull Context context, @Nullable Map<String, String> configuration, @NonNull OnNetworkInitializationFinishedListener listener) {
//        Log.d(TAG, "initializeNetwork");

        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(listener);

        boolean networkInitializationSucceeded = false;

        synchronized (SuezXAdapterConfiguration.class) {
            try {
                // TODO: Initialize SuezX SDK
                networkInitializationSucceeded = true;
            } catch (Exception e) {
                MoPubLog.log(CUSTOM_WITH_THROWABLE, "Initializing SuezX has encountered " + "an exception.", e);
            }
        }

        if (networkInitializationSucceeded) {
            listener.onNetworkInitializationFinished(SuezXAdapterConfiguration.class,
                    MoPubErrorCode.ADAPTER_INITIALIZATION_SUCCESS);
        }
        else {
            listener.onNetworkInitializationFinished(SuezXAdapterConfiguration.class,
                    MoPubErrorCode.ADAPTER_CONFIGURATION_ERROR);
        }
    }


    public static String fetchGdprAppliance() {
        Boolean applies = MoPub.getPersonalInformationManager().gdprApplies();
        return applies == null ? "0" : applies ? "1" : "0";
    }

    public static String fetchGdprConsent() {
        switch (MoPub.getPersonalInformationManager().getPersonalInfoConsentStatus()) {
            case EXPLICIT_YES:
                return "1";
            default:
                return "0";
        }
    }
}