/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Error;
import io.toolsplus.atlassian.jwt.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.JwtExpiredError;
import io.toolsplus.atlassian.jwt.JwtInvalidClaimError;
import io.toolsplus.atlassian.jwt.JwtParser$;
import io.toolsplus.atlassian.jwt.JwtReader$;
import io.toolsplus.atlassian.jwt.JwtSignatureMismatchError;
import io.toolsplus.atlassian.jwt.JwtTooEarlyError;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Eh\u0001B\u0012%\u00016B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u000b\")a\n\u0001C\u0001\u001f\"91\u000b\u0001b\u0001\n\u001b!\u0006BB0\u0001A\u00035Q\u000bC\u0003a\u0001\u0011\u0005\u0011\rC\u0003o\u0001\u0011%q\u000eC\u0003x\u0001\u0011%\u0001\u0010\u0003\u0004\u0000\u0001\u0011%\u0011\u0011\u0001\u0005\b\u0003'\u0001A\u0011BA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\b\u0001\t\u0013\t\t\u0003C\u0004\u0002:\u0001!I!a\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003\"CA)\u0001\u0005\u0005I\u0011AA*\u0011%\t9\u0006AI\u0001\n\u0003\tI\u0006C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r!I\u0011Q\u0010\u0001\u0002\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u000f\u0003\u0011\u0011!C\u0001\u0003\u0013C\u0011\"!&\u0001\u0003\u0003%\t%a&\t\u0013\u0005\u0015\u0006!!A\u0005\u0002\u0005\u001d\u0006\"CAV\u0001\u0005\u0005I\u0011IAW\u0011%\t\t\fAA\u0001\n\u0003\n\u0019\fC\u0005\u00026\u0002\t\t\u0011\"\u0011\u00028\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00131X\u0004\b\u0003\u007f#\u0003\u0012AAa\r\u0019\u0019C\u0005#\u0001\u0002D\"1a\n\bC\u0001\u0003\u001bD\u0011\"a4\u001d\u0005\u0004%I!a \t\u0011\u0005EG\u0004)A\u0005\u0003\u0003C\u0011\"a5\u001d\u0003\u0003%\t)!6\t\u0013\u0005eG$!A\u0005\u0002\u0006m\u0007\"CAt9\u0005\u0005I\u0011BAu\u0005%Qu\u000f\u001e*fC\u0012,'O\u0003\u0002&M\u0005\u0019!n\u001e;\u000b\u0005\u001dB\u0013!C1uY\u0006\u001c8/[1o\u0015\tI#&A\u0005u_>d7\u000f\u001d7vg*\t1&\u0001\u0002j_\u000e\u00011\u0003\u0002\u0001/i]\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u0012a!\u00118z%\u00164\u0007CA\u00186\u0013\t1\u0004GA\u0004Qe>$Wo\u0019;\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\taD&\u0001\u0004=e>|GOP\u0005\u0002c%\u0011q\bM\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%I\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002@a\u0005a1\u000f[1sK\u0012\u001cVm\u0019:fiV\tQ\t\u0005\u0002G\u0015:\u0011q\t\u0013\t\u0003uAJ!!\u0013\u0019\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013B\nQb\u001d5be\u0016$7+Z2sKR\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002Q%B\u0011\u0011\u000bA\u0007\u0002I!)1i\u0001a\u0001\u000b\u0006Aa/\u001a:jM&,'/F\u0001V!\t1V,D\u0001X\u0015\tA\u0016,\u0001\u0003k_N,'B\u0001.\\\u0003!q\u0017.\u001c2vg\u0012\u001c(\"\u0001/\u0002\u0007\r|W.\u0003\u0002_/\nY!jV*WKJLg-[3s\u0003%1XM]5gS\u0016\u0014\b%A\u0007sK\u0006$\u0017I\u001c3WKJLg-\u001f\u000b\u0004E.d\u0007\u0003\u0002\u001ddK\"L!\u0001\u001a\"\u0003\r\u0015KG\u000f[3s!\t\tf-\u0003\u0002hI\t)QI\u001d:peB\u0011\u0011+[\u0005\u0003U\u0012\u00121AS<u\u0011\u0015)c\u00011\u0001F\u0011\u0015ig\u00011\u0001F\u0003=\tX/\u001a:z'R\u0014\u0018N\\4ICND\u0017\u0001\u0002:fC\u0012$BA\u00199re\")Qe\u0002a\u0001\u000b\")Qn\u0002a\u0001\u000b\")1o\u0002a\u0001i\u0006)2\u000f[8vY\u00124VM]5gsNKwM\\1ukJ,\u0007CA\u0018v\u0013\t1\bGA\u0004C_>dW-\u00198\u0002\u0015Y,'/\u001b4z%\u0016\u001cH\u000fF\u0002cszDQA\u001f\u0005A\u0002m\f\u0011B[<t\u001f\nTWm\u0019;\u0011\u0005Yc\u0018BA?X\u0005%QukU(cU\u0016\u001cG\u000fC\u0003n\u0011\u0001\u0007Q)\u0001\u000bwKJLg-_*uC:$\u0017M\u001d3DY\u0006LWn\u001d\u000b\u0005\u0003\u0007\ty\u0001E\u00039G\u0016\f)\u0001\u0005\u0003\u0002\b\u0005-QBAA\u0005\u0015\t)\u0013,\u0003\u0003\u0002\u000e\u0005%!\u0001\u0004&X)\u000ec\u0017-[7t'\u0016$\bbBA\t\u0013\u0001\u0007\u0011QA\u0001\u0007G2\f\u0017.\\:\u0002KY\fG.\u001b3bi\u0016D\u0015m]%tgV,G+[7f\u0003:$W\t\u001f9je\u0006$\u0018n\u001c8US6,G\u0003BA\u0002\u0003/Aq!!\u0005\u000b\u0001\u0004\t)!\u0001\u0014wC2LG-\u0019;f\u000bb\u0004\u0018N]1uS>tG+[7f\u0013N\fe\r^3s\u001d>$()\u001a4pe\u0016$B!a\u0001\u0002\u001e!9\u0011\u0011C\u0006A\u0002\u0005\u0015\u0011a\u0007<bY&$\u0017\r^3O_^L5/\u00114uKJtu\u000e\u001e\"fM>\u0014X\r\u0006\u0004\u0002\u0004\u0005\r\u0012q\u0007\u0005\b\u0003Ka\u0001\u0019AA\u0014\u0003\rqwn\u001e\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011!\u0018.\\3\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006LA!!\u000e\u0002,\t9\u0011J\\:uC:$\bbBA\t\u0019\u0001\u0007\u0011QA\u0001\"m\u0006d\u0017\u000eZ1uK:{w/S:CK\u001a|'/Z#ya&\u0014\u0018\r^5p]RKW.\u001a\u000b\u0007\u0003\u0007\ti$a\u0010\t\u000f\u0005\u0015R\u00021\u0001\u0002(!9\u0011\u0011C\u0007A\u0002\u0005\u0015\u0011!\u0006<fe&4\u00170U;fef\u001cFO]5oO\"\u000b7\u000f\u001b\u000b\u0007\u0003\u0007\t)%a\u0012\t\u000f\u0005Ea\u00021\u0001\u0002\u0006!)QN\u0004a\u0001\u000b\u0006ya/\u001a:jMf\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0003\u0002N\u0005=\u0003\u0003\u0002\u001ddKnDQA_\bA\u0002m\fAaY8qsR\u0019\u0001+!\u0016\t\u000f\r\u0003\u0002\u0013!a\u0001\u000b\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA.U\r)\u0015QL\u0016\u0003\u0003?\u0002B!!\u0019\u0002l5\u0011\u00111\r\u0006\u0005\u0003K\n9'A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u000e\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002n\u0005\r$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u001d\u0011\t\u0005U\u00141P\u0007\u0003\u0003oRA!!\u001f\u00020\u0005!A.\u00198h\u0013\rY\u0015qO\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003\u0003\u00032aLAB\u0013\r\t)\t\r\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\u000b\t\nE\u00020\u0003\u001bK1!a$1\u0005\r\te.\u001f\u0005\n\u0003'#\u0012\u0011!a\u0001\u0003\u0003\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAM!\u0019\tY*!)\u0002\f6\u0011\u0011Q\u0014\u0006\u0004\u0003?\u0003\u0014AC2pY2,7\r^5p]&!\u00111UAO\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Q\fI\u000bC\u0005\u0002\u0014Z\t\t\u00111\u0001\u0002\f\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\t\u0019(a,\t\u0013\u0005Mu#!AA\u0002\u0005\u0005\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\u0005\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005M\u0014AB3rk\u0006d7\u000fF\u0002u\u0003{C\u0011\"a%\u001b\u0003\u0003\u0005\r!a#\u0002\u0013);HOU3bI\u0016\u0014\bCA)\u001d'\u0011ab&!2\u0011\t\u0005\u001d\u00171Z\u0007\u0003\u0003\u0013T1aKA\u0018\u0013\r\t\u0015\u0011\u001a\u000b\u0003\u0003\u0003\fa\u0003V5nK\u000ec\u0017-[7MK\u0016<\u0018-_*fG>tGm]\u0001\u0018)&lWm\u00117bS6dU-Z<bsN+7m\u001c8eg\u0002\nQ!\u00199qYf$2\u0001UAl\u0011\u0015\u0019\u0005\u00051\u0001F\u0003\u001d)h.\u00199qYf$B!!8\u0002dB!q&a8F\u0013\r\t\t\u000f\r\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005\u0015\u0018%!AA\u0002A\u000b1\u0001\u001f\u00131\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\tY\u000f\u0005\u0003\u0002v\u00055\u0018\u0002BAx\u0003o\u0012aa\u00142kK\u000e$\b")
public class JwtReader
implements Product,
Serializable {
    private final String sharedSecret;
    private final JWSVerifier verifier;

    public static Option<String> unapply(JwtReader jwtReader) {
        return JwtReader$.MODULE$.unapply(jwtReader);
    }

    public static JwtReader apply(String string) {
        return JwtReader$.MODULE$.apply(string);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String sharedSecret() {
        return this.sharedSecret;
    }

    private final JWSVerifier verifier() {
        return this.verifier;
    }

    public Either<Error, Jwt> readAndVerify(String jwt, String queryStringHash) {
        return this.read(jwt, queryStringHash, true);
    }

    private Either<Error, Jwt> read(String jwt, String queryStringHash, boolean shouldVerifySignature) {
        Either<Error, Jwt> either;
        Either<ParsingFailure, JWSObject> either2 = JwtParser$.MODULE$.parseJWSObject(jwt);
        if (either2 instanceof Right) {
            Either<Error, Jwt> either3;
            Right right = (Right)either2;
            JWSObject jwsObject = (JWSObject)right.value();
            if (shouldVerifySignature) {
                Left left;
                Either<Error, JWSObject> either4 = this.verifySignature(jwsObject);
                if (either4 instanceof Right) {
                    left = this.verifyRest(jwsObject, queryStringHash);
                } else if (either4 instanceof Left) {
                    Left left2;
                    left = left2 = (Left)either4;
                } else {
                    throw new MatchError(either4);
                }
                either3 = left;
            } else {
                either3 = this.verifyRest(jwsObject, queryStringHash);
            }
            either = either3;
        } else if (either2 instanceof Left) {
            Either<Error, Jwt> either5;
            either = either5 = (Either<Error, Jwt>)either2;
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    private Either<Error, Jwt> verifyRest(JWSObject jwsObject, String queryStringHash) {
        Left left;
        Either<ParsingFailure, JWTClaimsSet> either = JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject());
        if (either instanceof Right) {
            Left left2;
            Right right = (Right)either;
            JWTClaimsSet claims = (JWTClaimsSet)right.value();
            Either<Error, JWTClaimsSet> either2 = this.verifyStandardClaims(claims);
            if (either2 instanceof Right) {
                Right right2;
                Either<Error, JWTClaimsSet> either3 = this.verifyQueryStringHash(claims, queryStringHash);
                if (either3 instanceof Right) {
                    right2 = package$.MODULE$.Right().apply((Object)new Jwt(jwsObject, claims));
                } else if (either3 instanceof Left) {
                    Left left3 = (Left)either3;
                    right2 = left3;
                } else {
                    throw new MatchError(either3);
                }
                left2 = right2;
            } else if (either2 instanceof Left) {
                Left left4;
                left2 = left4 = (Left)either2;
            } else {
                throw new MatchError(either2);
            }
            left = left2;
        } else if (either instanceof Left) {
            Left left5;
            left = left5 = (Left)either;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<Error, JWTClaimsSet> verifyStandardClaims(JWTClaimsSet claims) {
        return this.validateHasIssueTimeAndExpirationTime(claims).map((Function1 & Serializable)x$1 -> {
            Instant now = Instant.now();
            return new Tuple2(x$1, (Object)now);
        }).flatMap((Function1 & Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Instant now = (Instant)tuple2._2();
            Either either = this.validateExpirationTimeIsAfterNotBefore(claims).flatMap((Function1 & Serializable)x$4 -> {
                JWTClaimsSet jWTClaimsSet = x$4;
                Either either = this.validateNowIsAfterNotBefore(now, claims).flatMap((Function1 & Serializable)x$3 -> {
                    JWTClaimsSet jWTClaimsSet = x$3;
                    Either either = this.validateNowIsBeforeExpirationTime(now, claims).map((Function1 & Serializable)x$2 -> {
                        JWTClaimsSet jWTClaimsSet = x$2;
                        JWTClaimsSet jWTClaimsSet2 = claims;
                        return jWTClaimsSet2;
                    });
                    return either;
                });
                return either;
            });
            return either;
        });
    }

    private Either<Error, JWTClaimsSet> validateHasIssueTimeAndExpirationTime(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getIssueTime()).isEmpty() || Option$.MODULE$.apply((Object)claims.getExpirationTime()).isEmpty() ? new Left((Object)new JwtInvalidClaimError("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.")) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateExpirationTimeIsAfterNotBefore(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && !claims.getExpirationTime().after(claims.getNotBeforeTime()) ? new Left((Object)new JwtInvalidClaimError(new StringBuilder(71).append("The expiration time must be after the not-before time but exp=").append(claims.getExpirationTime()).append(" and nbf=").append(claims.getNotBeforeTime()).toString())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateNowIsAfterNotBefore(Instant now, JWTClaimsSet claims) {
        Instant nowPlusLeeway = now.plusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && claims.getNotBeforeTime().toInstant().isAfter(nowPlusLeeway) ? new Left((Object)new JwtTooEarlyError(claims.getNotBeforeTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateNowIsBeforeExpirationTime(Instant now, JWTClaimsSet claims) {
        Instant nowMinusLeeway = now.minusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return claims.getExpirationTime().toInstant().isBefore(nowMinusLeeway) ? new Left((Object)new JwtExpiredError(claims.getExpirationTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> verifyQueryStringHash(JWTClaimsSet claims, String queryStringHash) {
        Right right;
        Option maybeExtractedQueryStringHash = Option$.MODULE$.apply(claims.getClaim(HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName()));
        Option option = maybeExtractedQueryStringHash;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object extractedQueryStringHash = some.value();
            String string = queryStringHash;
            Object object = extractedQueryStringHash;
            right = (string == null ? object != null : !string.equals(object)) ? new Left((Object)new JwtInvalidClaimError(new StringBuilder(67).append("Expecting claim '").append(HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName()).append("' to have value '").append(queryStringHash).append("' but instead it has the value '").append(maybeExtractedQueryStringHash).append("'").toString())) : package$.MODULE$.Right().apply((Object)claims);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply((Object)claims);
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    private Either<Error, JWSObject> verifySignature(JWSObject jwsObject) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> jwsObject.verify(this.verifier()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean isValid = BoxesRunTime.unboxToBoolean((Object)success.value());
            left = isValid ? package$.MODULE$.Right().apply((Object)jwsObject) : new Left((Object)new JwtSignatureMismatchError(jwsObject.getParsedString()));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            left = new Left((Object)new JwtSignatureMismatchError(exception.getMessage()));
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public JwtReader copy(String sharedSecret) {
        return new JwtReader(sharedSecret);
    }

    public String copy$default$1() {
        return this.sharedSecret();
    }

    public String productPrefix() {
        return "JwtReader";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.sharedSecret();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JwtReader;
    }

    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "sharedSecret";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JwtReader)) return false;
        boolean bl = true;
        if (!bl) return false;
        JwtReader jwtReader = (JwtReader)x$1;
        String string = this.sharedSecret();
        String string2 = jwtReader.sharedSecret();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!jwtReader.canEqual(this)) return false;
        return true;
    }

    public JwtReader(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        Product.$init$((Product)this);
        this.verifier = new MACVerifier(sharedSecret);
    }
}

