/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.io.Serializable;
import net.minidev.json.JSONObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JwtParser$ {
    public static final JwtParser$ MODULE$ = new JwtParser$();
    private static final String UnexpectedTypeMessagePrefix = "Unexpected type of JSON object member with key ";
    private static final Set<String> NumericClaimNames = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"exp", "iat", "nbf"}));

    public final Either<ParsingFailure, Jwt> parse(String input) {
        return this.parseJWSObject(input).flatMap((Function1 & Serializable)jwsObject -> MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject()).map((Function1 & Serializable)claims -> new Jwt((JWSObject)jwsObject, (JWTClaimsSet)claims)));
    }

    public final Either<ParsingFailure, JWSObject> parseJWSObject(String input) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> JWSObject.parse((String)input));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JWSObject jwsObject = (JWSObject)success.value();
            right = package$.MODULE$.Right().apply((Object)jwsObject);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            String message = (String)Option$.MODULE$.apply((Object)exception.getMessage()).getOrElse((Function0 & Serializable)() -> "Parsing JWS object failed");
            right = package$.MODULE$.Left().apply((Object)new ParsingFailure(message, exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public final Either<ParsingFailure, JWTClaimsSet> parseJWTClaimsSet(JSONObject json) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> JWTClaimsSet.parse((JSONObject)json));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JWTClaimsSet claims = (JWTClaimsSet)success.value();
            right = package$.MODULE$.Right().apply((Object)claims);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ParsingFailure(this.claimParsingFailureDetails(exception), exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public final String claimParsingFailureDetails(Throwable exception) {
        return (String)Option$.MODULE$.apply((Object)exception.getMessage()).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(JwtParser$.MODULE$.UnexpectedTypeMessagePrefix()))).map((Function1 & Serializable)message -> JwtParser$.failureDetails$1(JwtParser$.toClaimName$1(message), exception)).getOrElse((Function0 & Serializable)() -> "Parsing claims failed");
    }

    private String UnexpectedTypeMessagePrefix() {
        return UnexpectedTypeMessagePrefix;
    }

    private Set<String> NumericClaimNames() {
        return NumericClaimNames;
    }

    private static final String toClaimName$1(String message) {
        return message.replace(MODULE$.UnexpectedTypeMessagePrefix(), "").replaceAll("\"", "");
    }

    private static final String failureDetails$1(String claimName, Throwable exception$1) {
        return MODULE$.NumericClaimNames().contains((Object)claimName) ? new StringBuilder(51).append("Expecting claim '").append(claimName).append("' to be numeric but it is a string").toString() : new StringBuilder(80).append("Perhaps a claim is of the wrong type (e.g. expecting integer but found string): ").append(exception$1.getMessage()).toString();
    }

    private JwtParser$() {
    }
}

