/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import io.toolsplus.atlassian.jwt.JwtJsonBuilder;
import io.toolsplus.atlassian.jwt.JwtSigningError;
import io.toolsplus.atlassian.jwt.JwtWriter;
import java.time.Duration;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc\u0001\u0002\t\u0012\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\u0006U\u0001!\ta\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019!\u0004\u0001)A\u0005c!)Q\u0007\u0001C\u0001m!)A\t\u0001C\u0001\u000b\")\u0001\n\u0001C\u0001\u0013\")Q\u000b\u0001C\u0001-\")A\f\u0001C\u0001;\")\u0001\r\u0001C\u0001C\")A\r\u0001C\u0001K\")\u0001\u000e\u0001C\u0001S\")a\u000e\u0001C\u0001_\"I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011q\u0006\u0005\b\u0003\u000b\u0002A\u0011BA$\u0005)Qu\u000f\u001e\"vS2$WM\u001d\u0006\u0003%M\t1A[<u\u0015\t!R#A\u0005bi2\f7o]5b]*\u0011acF\u0001\ni>|Gn\u001d9mkNT\u0011\u0001G\u0001\u0003S>\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t1\u0011I\\=SK\u001a\f1\"\u001a=qSJ,\u0017I\u001a;feB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005i&lWMC\u0001(\u0003\u0011Q\u0017M^1\n\u0005%\"#\u0001\u0003#ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\tac\u0006\u0005\u0002.\u00015\t\u0011\u0003C\u0003\"\u0005\u0001\u0007!%\u0001\bkoRT5o\u001c8Ck&dG-\u001a:\u0016\u0003E\u0002\"!\f\u001a\n\u0005M\n\"A\u0004&xi*\u001bxN\u001c\"vS2$WM]\u0001\u0010U^$(j]8o\u0005VLG\u000eZ3sA\u0005Qq/\u001b;i\u0013N\u001cX/\u001a:\u0015\u00051:\u0004\"\u0002\u001d\u0006\u0001\u0004I\u0014aA5tgB\u0011!(\u0011\b\u0003w}\u0002\"\u0001P\u000f\u000e\u0003uR!AP\r\u0002\rq\u0012xn\u001c;?\u0013\t\u0001U$\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!\u001e\u0003-9\u0018\u000e\u001e5Tk\nTWm\u0019;\u0015\u000512\u0005\"B$\u0007\u0001\u0004I\u0014aA:vE\u0006aq/\u001b;i\u0003V$\u0017.\u001a8dKR\u0011AF\u0013\u0005\u0006\u0017\u001e\u0001\r\u0001T\u0001\u0004CV$\u0007cA'Ss9\u0011a\n\u0015\b\u0003y=K\u0011AH\u0005\u0003#v\tq\u0001]1dW\u0006<W-\u0003\u0002T)\n\u00191+Z9\u000b\u0005Ek\u0012AE<ji\",\u0005\u0010]5sCRLwN\u001c+j[\u0016$\"\u0001L,\t\u000baC\u0001\u0019A-\u0002\u0007\u0015D\b\u000f\u0005\u0002\u001d5&\u00111,\b\u0002\u0005\u0019>tw-A\u0007xSRDgj\u001c;CK\u001a|'/\u001a\u000b\u0003YyCQaX\u0005A\u0002e\u000b1A\u001c2g\u000319\u0018\u000e\u001e5JgN,X\rZ!u)\ta#\rC\u0003d\u0015\u0001\u0007\u0011,A\u0002jCR\fQb^5uQF+XM]=ICNDGC\u0001\u0017g\u0011\u001597\u00021\u0001:\u0003%\tX/\u001a:z\u0011\u0006\u001c\b.A\u0005xSRD7\t\\1j[R\u0019AF\u001b7\t\u000b-d\u0001\u0019A\u001d\u0002\t9\fW.\u001a\u0005\u0006[2\u0001\raG\u0001\u0006m\u0006dW/Z\u0001\u0006EVLG\u000e\u001a\u000b\u0006a\u0006E\u0011Q\u0003\t\u0005\u001bF\u001ch/\u0003\u0002s)\n1Q)\u001b;iKJ\u0004\"!\f;\n\u0005U\f\"a\u0004&xiNKwM\\5oO\u0016\u0013(o\u001c:\u0011\u0007]\fYAD\u0002y\u0003\u000fq1!_A\u0002\u001d\rQ\u0018\u0011\u0001\b\u0003w~t!\u0001 @\u000f\u0005qj\u0018\"\u0001\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t\u00112#C\u0002\u0002\u0006E\t1!\u00199j\u0013\r\u0001\u0015\u0011\u0002\u0006\u0004\u0003\u000b\t\u0012\u0002BA\u0007\u0003\u001f\u0011aAU1x\u0015^$(b\u0001!\u0002\n!1\u00111C\u0007A\u0002e\nAb\u001d5be\u0016$7+Z2sKRD\u0011\"a\u0006\u000e!\u0003\u0005\r!!\u0007\u0002\u0013\u0005dwm\u001c:ji\"l\u0007\u0003BA\u000e\u0003Si!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005U>\u001cXM\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00038j[\n,8\u000fZ:\u000b\u0005\u0005\u001d\u0012aA2p[&!\u00111FA\u000f\u00051QukU!mO>\u0014\u0018\u000e\u001e5n\u0003=\u0011W/\u001b7eI\u0011,g-Y;mi\u0012\u0012TCAA\u0019U\u0011\tI\"a\r,\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0010\u001e\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0007\nIDA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqb\u0019:fCR,'j\u001e;Xe&$XM\u001d\u000b\u0007\u0003\u0013\ny%!\u0015\u0011\u00075\nY%C\u0002\u0002NE\u0011\u0011BS<u/JLG/\u001a:\t\r\u0005Mq\u00021\u0001:\u0011\u001d\t9b\u0004a\u0001\u00033\u0001")
public class JwtBuilder {
    private final JwtJsonBuilder jwtJsonBuilder;

    private JwtJsonBuilder jwtJsonBuilder() {
        return this.jwtJsonBuilder;
    }

    public JwtBuilder withIssuer(String iss) {
        this.jwtJsonBuilder().withIssuer(iss);
        return this;
    }

    public JwtBuilder withSubject(String sub) {
        this.jwtJsonBuilder().withSubject(sub);
        return this;
    }

    public JwtBuilder withAudience(Seq<String> aud) {
        this.jwtJsonBuilder().withAudience(aud);
        return this;
    }

    public JwtBuilder withExpirationTime(long exp) {
        this.jwtJsonBuilder().withExpirationTime(exp);
        return this;
    }

    public JwtBuilder withNotBefore(long nbf) {
        this.jwtJsonBuilder().withNotBefore(nbf);
        return this;
    }

    public JwtBuilder withIssuedAt(long iat) {
        this.jwtJsonBuilder().withIssuedAt(iat);
        return this;
    }

    public JwtBuilder withQueryHash(String queryHash) {
        this.jwtJsonBuilder().withQueryHash(queryHash);
        return this;
    }

    public JwtBuilder withClaim(String name, Object value) {
        this.jwtJsonBuilder().withClaim(name, value);
        return this;
    }

    public Either<JwtSigningError, String> build(String sharedSecret, JWSAlgorithm algorithm) {
        String jwtPayload = this.jwtJsonBuilder().build();
        return this.createJwtWriter(sharedSecret, algorithm).jsonToJwt(jwtPayload);
    }

    public JWSAlgorithm build$default$2() {
        return JWSAlgorithm.HS256;
    }

    private JwtWriter createJwtWriter(String sharedSecret, JWSAlgorithm algorithm) {
        return new JwtWriter(algorithm, (JWSSigner)new MACSigner(sharedSecret));
    }

    public JwtBuilder(Duration expireAfter) {
        this.jwtJsonBuilder = new JwtJsonBuilder(expireAfter);
    }
}

