/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import io.toolsplus.atlassian.jwt.api.CanonicalHttpRequest;
import java.io.Serializable;
import java.net.URLEncoder;
import java.security.MessageDigest;
import org.bouncycastle.util.encoders.Hex;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class HttpRequestCanonicalizer$ {
    public static final HttpRequestCanonicalizer$ MODULE$ = new HttpRequestCanonicalizer$();
    private static final String QueryStringHashClaimName = "qsh";
    private static final String JwtParamName = "jwt";
    private static final char QueryParamsSeparator = (char)38;
    private static final String EncodedParamValueSeparator = ",";
    private static final char CanonicalRequestPartSeparator = (char)38;

    public String QueryStringHashClaimName() {
        return QueryStringHashClaimName;
    }

    private String JwtParamName() {
        return JwtParamName;
    }

    private char QueryParamsSeparator() {
        return QueryParamsSeparator;
    }

    private String EncodedParamValueSeparator() {
        return EncodedParamValueSeparator;
    }

    public char CanonicalRequestPartSeparator() {
        return CanonicalRequestPartSeparator;
    }

    public String canonicalize(CanonicalHttpRequest request) {
        return new StringBuilder(0).append(new StringBuilder(0).append(this.canonicalizeMethod(request)).append(this.CanonicalRequestPartSeparator()).toString()).append(new StringBuilder(0).append(this.canonicalizeUri(request)).append(this.CanonicalRequestPartSeparator()).toString()).append(String.valueOf(this.canonicalizeQueryParameters(request))).toString();
    }

    public String computeCanonicalRequestHash(CanonicalHttpRequest request) {
        return this.computeSha256Hash(this.canonicalize(request));
    }

    private String computeSha256Hash(String hashInput) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashInputBytes = hashInput.getBytes();
        digest.update(hashInputBytes, 0, hashInputBytes.length);
        return new String(Hex.encode((byte[])digest.digest()));
    }

    public String canonicalizeMethod(CanonicalHttpRequest request) {
        return request.method().toUpperCase();
    }

    public String canonicalizeUri(CanonicalHttpRequest request) {
        String relativeRequestPath = request.relativePath();
        String pathWithoutTrailingSlash = relativeRequestPath.endsWith("/") ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(relativeRequestPath), 1) : relativeRequestPath;
        String path = pathWithoutTrailingSlash.isEmpty() ? "/" : pathWithoutTrailingSlash;
        String separatorAsString = ((Object)BoxesRunTime.boxToCharacter((char)this.CanonicalRequestPartSeparator())).toString();
        String encodedPath = path.replaceAll(separatorAsString, this.percentEncode(separatorAsString));
        return encodedPath.startsWith("/") ? encodedPath : new StringBuilder(1).append("/").append(encodedPath).toString();
    }

    public String canonicalizeQueryParameters(CanonicalHttpRequest request) {
        return ((IterableOnceOps)((IterableOps)request.parameterMap().$minus((Object)this.JwtParamName()).toSeq().sortBy((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            String string = new StringBuilder(1).append(MODULE$.percentEncode(key)).append(" ").append(MODULE$.percentEncode(values.mkString(","))).toString();
            return string;
        }, (Ordering)Ordering.String$.MODULE$)).map(((Function2 & Serializable)(Function2 & Serializable)(key, values) -> MODULE$.percentEncodePair((String)key, (Seq<String>)values)).tupled())).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.QueryParamsSeparator())).toString());
    }

    private String percentEncodePair(String key, Seq<String> values) {
        String encKey = this.percentEncode(key);
        String encVal = ((IterableOnceOps)values.map((Function1 & Serializable)value -> MODULE$.percentEncode((String)value))).mkString(this.EncodedParamValueSeparator());
        return new StringBuilder(1).append(encKey).append("=").append(encVal).toString();
    }

    private String percentEncode(String value) {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private HttpRequestCanonicalizer$() {
    }
}

