/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.MACSigner;
import io.toolsplus.atlassian.jwt.JwtJsonBuilder;
import io.toolsplus.atlassian.jwt.JwtSigningError;
import io.toolsplus.atlassian.jwt.JwtWriter;
import java.time.Duration;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001-\u0011!BS<u\u0005VLG\u000eZ3s\u0015\t\u0019A!A\u0002koRT!!\u0002\u0004\u0002\u0013\u0005$H.Y:tS\u0006t'BA\u0004\t\u0003%!xn\u001c7ta2,8OC\u0001\n\u0003\tIwn\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0003\u0005\u0014\u0001\t\u0005\t\u0015!\u0003\u0015\u0003-)\u0007\u0010]5sK\u00063G/\u001a:\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012\u0001\u0002;j[\u0016T\u0011!G\u0001\u0005U\u00064\u0018-\u0003\u0002\u001c-\tAA)\u001e:bi&|g\u000eC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0003?\u0005\u0002\"\u0001\t\u0001\u000e\u0003\tAQa\u0005\u000fA\u0002QAqa\t\u0001C\u0002\u0013%A%\u0001\bkoRT5o\u001c8Ck&dG-\u001a:\u0016\u0003\u0015\u0002\"\u0001\t\u0014\n\u0005\u001d\u0012!A\u0004&xi*\u001bxN\u001c\"vS2$WM\u001d\u0005\u0007S\u0001\u0001\u000b\u0011B\u0013\u0002\u001f)<HOS:p]\n+\u0018\u000e\u001c3fe\u0002BQa\u000b\u0001\u0005\u00021\n!b^5uQ&\u001b8/^3s)\tyR\u0006C\u0003/U\u0001\u0007q&A\u0002jgN\u0004\"\u0001M\u001c\u000f\u0005E*\u0004C\u0001\u001a\u000f\u001b\u0005\u0019$B\u0001\u001b\u000b\u0003\u0019a$o\\8u}%\u0011aGD\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027\u001d!)1\b\u0001C\u0001y\u0005Yq/\u001b;i'V\u0014'.Z2u)\tyR\bC\u0003?u\u0001\u0007q&A\u0002tk\nDQ\u0001\u0011\u0001\u0005\u0002\u0005\u000bAb^5uQ\u0006+H-[3oG\u0016$\"a\b\"\t\u000b\r{\u0004\u0019\u0001#\u0002\u0007\u0005,H\rE\u0002F\u0015>r!A\u0012%\u000f\u0005I:\u0015\"A\b\n\u0005%s\u0011a\u00029bG.\fw-Z\u0005\u0003\u00172\u00131aU3r\u0015\tIe\u0002C\u0003O\u0001\u0011\u0005q*\u0001\nxSRDW\t\u001f9je\u0006$\u0018n\u001c8US6,GCA\u0010Q\u0011\u0015\tV\n1\u0001S\u0003\r)\u0007\u0010\u001d\t\u0003\u001bMK!\u0001\u0016\b\u0003\t1{gn\u001a\u0005\u0006-\u0002!\taV\u0001\u000eo&$\bNT8u\u0005\u00164wN]3\u0015\u0005}A\u0006\"B-V\u0001\u0004\u0011\u0016a\u00018cM\")1\f\u0001C\u00019\u0006aq/\u001b;i\u0013N\u001cX/\u001a3BiR\u0011q$\u0018\u0005\u0006=j\u0003\rAU\u0001\u0004S\u0006$\b\"\u00021\u0001\t\u0003\t\u0017!D<ji\"\fV/\u001a:z\u0011\u0006\u001c\b\u000e\u0006\u0002 E\")1m\u0018a\u0001_\u0005I\u0011/^3ss\"\u000b7\u000f\u001b\u0005\u0006K\u0002!\tAZ\u0001\no&$\bn\u00117bS6$2aH4j\u0011\u0015AG\r1\u00010\u0003\u0011q\u0017-\\3\t\u000b)$\u0007\u0019\u0001\u0007\u0002\u000bY\fG.^3\t\u000b1\u0004A\u0011A7\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u000b9\fi!!\u0005\u0011\t\u0015{\u0017\u000f^\u0005\u0003a2\u0013a!R5uQ\u0016\u0014\bC\u0001\u0011s\u0013\t\u0019(AA\bKoR\u001c\u0016n\u001a8j]\u001e,%O]8s!\r)\u0018q\u0001\b\u0004m\u0006\raBA<\u0000\u001d\tAhP\u0004\u0002z{:\u0011!\u0010 \b\u0003emL\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005\r!\u0011bAA\u0001\u0005\u0005\u0019\u0011\r]5\n\u0007Y\n)AC\u0002\u0002\u0002\tIA!!\u0003\u0002\f\t1!+Y<KoRT1ANA\u0003\u0011\u0019\tya\u001ba\u0001_\u0005a1\u000f[1sK\u0012\u001cVm\u0019:fi\"I\u00111C6\u0011\u0002\u0003\u0007\u0011QC\u0001\nC2<wN]5uQ6\u0004B!a\u0006\u0002&5\u0011\u0011\u0011\u0004\u0006\u0005\u00037\ti\"\u0001\u0003k_N,'\u0002BA\u0010\u0003C\t\u0001B\\5nEV\u001cHm\u001d\u0006\u0003\u0003G\t1aY8n\u0013\u0011\t9#!\u0007\u0003\u0019);6+\u00117h_JLG\u000f[7\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.\u0005y1M]3bi\u0016Tu\u000f^,sSR,'\u000f\u0006\u0004\u00020\u0005U\u0012q\u0007\t\u0004A\u0005E\u0012bAA\u001a\u0005\tI!j\u001e;Xe&$XM\u001d\u0005\b\u0003\u001f\tI\u00031\u00010\u0011!\t\u0019\"!\u000bA\u0002\u0005U\u0001\"CA\u001e\u0001E\u0005I\u0011AA\u001f\u0003=\u0011W/\u001b7eI\u0011,g-Y;mi\u0012\u0012TCAA U\u0011\t)\"!\u0011,\u0005\u0005\r\u0003\u0003BA#\u0003\u001fj!!a\u0012\u000b\t\u0005%\u00131J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0014\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003#\n9EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class JwtBuilder {
    private final JwtJsonBuilder jwtJsonBuilder;

    private JwtJsonBuilder jwtJsonBuilder() {
        return this.jwtJsonBuilder;
    }

    public JwtBuilder withIssuer(String iss) {
        this.jwtJsonBuilder().withIssuer(iss);
        return this;
    }

    public JwtBuilder withSubject(String sub) {
        this.jwtJsonBuilder().withSubject(sub);
        return this;
    }

    public JwtBuilder withAudience(Seq<String> aud) {
        this.jwtJsonBuilder().withAudience(aud);
        return this;
    }

    public JwtBuilder withExpirationTime(long exp) {
        this.jwtJsonBuilder().withExpirationTime(exp);
        return this;
    }

    public JwtBuilder withNotBefore(long nbf) {
        this.jwtJsonBuilder().withNotBefore(nbf);
        return this;
    }

    public JwtBuilder withIssuedAt(long iat) {
        this.jwtJsonBuilder().withIssuedAt(iat);
        return this;
    }

    public JwtBuilder withQueryHash(String queryHash) {
        this.jwtJsonBuilder().withQueryHash(queryHash);
        return this;
    }

    public JwtBuilder withClaim(String name, Object value) {
        this.jwtJsonBuilder().withClaim(name, value);
        return this;
    }

    public Either<JwtSigningError, String> build(String sharedSecret, JWSAlgorithm algorithm) {
        String jwtPayload = this.jwtJsonBuilder().build();
        return this.createJwtWriter(sharedSecret, algorithm).jsonToJwt(jwtPayload);
    }

    public JWSAlgorithm build$default$2() {
        return JWSAlgorithm.HS256;
    }

    private JwtWriter createJwtWriter(String sharedSecret, JWSAlgorithm algorithm) {
        return new JwtWriter(algorithm, (JWSSigner)new MACSigner(sharedSecret));
    }

    public JwtBuilder(Duration expireAfter) {
        this.jwtJsonBuilder = new JwtJsonBuilder(expireAfter);
    }
}

