/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Error;
import io.toolsplus.atlassian.jwt.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.JwtExpiredError;
import io.toolsplus.atlassian.jwt.JwtInvalidClaimError;
import io.toolsplus.atlassian.jwt.JwtParser$;
import io.toolsplus.atlassian.jwt.JwtReader$;
import io.toolsplus.atlassian.jwt.JwtSignatureMismatchError;
import io.toolsplus.atlassian.jwt.JwtTooEarlyError;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.io.Serializable;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0001.\u0011\u0011BS<u%\u0016\fG-\u001a:\u000b\u0005\r!\u0011a\u00016xi*\u0011QAB\u0001\nCRd\u0017m]:jC:T!a\u0002\u0005\u0002\u0013Q|w\u000e\\:qYV\u001c(\"A\u0005\u0002\u0005%|7\u0001A\n\u0005\u00011\u0011R\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBF\u0005\u0003/9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\rg\"\f'/\u001a3TK\u000e\u0014X\r^\u000b\u00027A\u0011Ad\t\b\u0003;\u0005\u0002\"A\b\b\u000e\u0003}Q!\u0001\t\u0006\u0002\rq\u0012xn\u001c;?\u0013\t\u0011c\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003I\u0015\u0012aa\u0015;sS:<'B\u0001\u0012\u000f\u0011!9\u0003A!E!\u0002\u0013Y\u0012!D:iCJ,GmU3de\u0016$\b\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0003W5\u0002\"\u0001\f\u0001\u000e\u0003\tAQ!\u0007\u0015A\u0002mAqa\f\u0001C\u0002\u00135\u0001'\u0001\u0005wKJLg-[3s+\u0005\t\u0004C\u0001\u001a:\u001b\u0005\u0019$B\u0001\u001b6\u0003\u0011Qwn]3\u000b\u0005Y:\u0014\u0001\u00038j[\n,8\u000fZ:\u000b\u0003a\n1aY8n\u0013\tQ4GA\u0006K/N3VM]5gS\u0016\u0014\bB\u0002\u001f\u0001A\u00035\u0011'A\u0005wKJLg-[3sA!)a\b\u0001C\u0001\u007f\u0005i!/Z1e\u0003:$g+\u001a:jMf$2\u0001Q(Q!\u0011\te)\u0013'\u000f\u0005\t#eB\u0001\u0010D\u0013\u0005y\u0011BA#\u000f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\r\u0015KG\u000f[3s\u0015\t)e\u0002\u0005\u0002-\u0015&\u00111J\u0001\u0002\u0006\u000bJ\u0014xN\u001d\t\u0003Y5K!A\u0014\u0002\u0003\u0007);H\u000fC\u0003\u0004{\u0001\u00071\u0004C\u0003R{\u0001\u00071$A\brk\u0016\u0014\u0018p\u0015;sS:<\u0007*Y:i\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0003\u0011\u0011X-\u00193\u0015\t\u0001+fk\u0016\u0005\u0006\u0007I\u0003\ra\u0007\u0005\u0006#J\u0003\ra\u0007\u0005\u00061J\u0003\r!W\u0001\u0016g\"|W\u000f\u001c3WKJLg-_*jO:\fG/\u001e:f!\ti!,\u0003\u0002\\\u001d\t9!i\\8mK\u0006t\u0007\"B/\u0001\t\u0013q\u0016A\u0003<fe&4\u0017PU3tiR\u0019\u0001i\u00183\t\u000b\u0001d\u0006\u0019A1\u0002\u0013)<8o\u00142kK\u000e$\bC\u0001\u001ac\u0013\t\u00197GA\u0005K/N{%M[3di\")\u0011\u000b\u0018a\u00017!)a\r\u0001C\u0005O\u0006!b/\u001a:jMf\u001cF/\u00198eCJ$7\t\\1j[N$\"\u0001\u001b8\u0011\t\u00053\u0015*\u001b\t\u0003U2l\u0011a\u001b\u0006\u0003\u0007UJ!!\\6\u0003\u0019);Fk\u00117bS6\u001c8+\u001a;\t\u000b=,\u0007\u0019A5\u0002\r\rd\u0017-[7t\u0011\u0015\t\b\u0001\"\u0003s\u0003\u00152\u0018\r\\5eCR,\u0007*Y:JgN,X\rV5nK\u0006sG-\u0012=qSJ\fG/[8o)&lW\r\u0006\u0002ig\")q\u000e\u001da\u0001S\")Q\u000f\u0001C\u0005m\u00061c/\u00197jI\u0006$X-\u0012=qSJ\fG/[8o)&lW-S:BMR,'OT8u\u0005\u00164wN]3\u0015\u0005!<\b\"B8u\u0001\u0004I\u0007\"B=\u0001\t\u0013Q\u0018a\u0007<bY&$\u0017\r^3O_^L5/\u00114uKJtu\u000e\u001e\"fM>\u0014X\r\u0006\u0003iw\u0006-\u0001\"\u0002?y\u0001\u0004i\u0018a\u00018poB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005!A/[7f\u0015\t\t)!\u0001\u0003kCZ\f\u0017bAA\u0005\u007f\n9\u0011J\\:uC:$\b\"B8y\u0001\u0004I\u0007bBA\b\u0001\u0011%\u0011\u0011C\u0001\"m\u0006d\u0017\u000eZ1uK:{w/S:CK\u001a|'/Z#ya&\u0014\u0018\r^5p]RKW.\u001a\u000b\u0006Q\u0006M\u0011Q\u0003\u0005\u0007y\u00065\u0001\u0019A?\t\r=\fi\u00011\u0001j\u0011\u001d\tI\u0002\u0001C\u0005\u00037\tQC^3sS\u001aL\u0018+^3ssN#(/\u001b8h\u0011\u0006\u001c\b\u000eF\u0003i\u0003;\ty\u0002\u0003\u0004p\u0003/\u0001\r!\u001b\u0005\u0007#\u0006]\u0001\u0019A\u000e\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&\u0005ya/\u001a:jMf\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0003\u0002(\u0005%\u0002\u0003B!G\u0013\u0006Da\u0001YA\u0011\u0001\u0004\t\u0007\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0003\u0011\u0019w\u000e]=\u0015\u0007-\n\t\u0004\u0003\u0005\u001a\u0003W\u0001\n\u00111\u0001\u001c\u0011%\t)\u0004AI\u0001\n\u0003\t9$\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e\"fA\u000e\u0002<-\u0012\u0011Q\b\t\u0005\u0003\u007f\tI%\u0004\u0002\u0002B)!\u00111IA#\u0003%)hn\u00195fG.,GMC\u0002\u0002H9\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY%!\u0011\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/RA!!\u0017\u0002\u0004\u0005!A.\u00198h\u0013\r!\u0013q\u000b\u0005\n\u0003?\u0002\u0011\u0011!C\u0001\u0003C\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0019\u0011\u00075\t)'C\u0002\u0002h9\u00111!\u00138u\u0011%\tY\u0007AA\u0001\n\u0003\ti'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0014Q\u000f\t\u0004\u001b\u0005E\u0014bAA:\u001d\t\u0019\u0011I\\=\t\u0015\u0005]\u0014\u0011NA\u0001\u0002\u0004\t\u0019'A\u0002yIEB\u0011\"a\u001f\u0001\u0003\u0003%\t%! \u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a \u0011\r\u0005\u0005\u0015qQA8\u001b\t\t\u0019IC\u0002\u0002\u0006:\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI)a!\u0003\u0011%#XM]1u_JD\u0011\"!$\u0001\u0003\u0003%\t!a$\u0002\u0011\r\fg.R9vC2$2!WAI\u0011)\t9(a#\u0002\u0002\u0003\u0007\u0011q\u000e\u0005\n\u0003+\u0003\u0011\u0011!C!\u0003/\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003GB\u0011\"a'\u0001\u0003\u0003%\t%!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0015\t\u0013\u0005\u0005\u0006!!A\u0005B\u0005\r\u0016AB3rk\u0006d7\u000fF\u0002Z\u0003KC!\"a\u001e\u0002 \u0006\u0005\t\u0019AA8\u000f\u001d\tIK\u0001E\u0001\u0003W\u000b\u0011BS<u%\u0016\fG-\u001a:\u0011\u00071\niK\u0002\u0004\u0002\u0005!\u0005\u0011qV\n\u0005\u0003[cQ\u0003C\u0004*\u0003[#\t!a-\u0015\u0005\u0005-\u0006BCA\\\u0003[\u0013\r\u0011\"\u0003\u0002b\u00051B+[7f\u00072\f\u0017.\u001c'fK^\f\u0017pU3d_:$7\u000fC\u0005\u0002<\u00065\u0006\u0015!\u0003\u0002d\u00059B+[7f\u00072\f\u0017.\u001c'fK^\f\u0017pU3d_:$7\u000f\t\u0005\u000b\u0003\u007f\u000bi+!A\u0005\u0002\u0006\u0005\u0017!B1qa2LHcA\u0016\u0002D\"1\u0011$!0A\u0002mA!\"a2\u0002.\u0006\u0005I\u0011QAe\u0003\u001d)h.\u00199qYf$B!a3\u0002RB!Q\"!4\u001c\u0013\r\tyM\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005M\u0017QYA\u0001\u0002\u0004Y\u0013a\u0001=%a!Q\u0011q[AW\u0003\u0003%I!!7\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u00037\u0004B!!\u0016\u0002^&!\u0011q\\A,\u0005\u0019y%M[3di\u0002")
public class JwtReader
implements Product,
scala.Serializable {
    private final String sharedSecret;
    private final JWSVerifier verifier;

    public static Option<String> unapply(JwtReader jwtReader) {
        return JwtReader$.MODULE$.unapply(jwtReader);
    }

    public static JwtReader apply(String string) {
        return JwtReader$.MODULE$.apply(string);
    }

    public String sharedSecret() {
        return this.sharedSecret;
    }

    private final JWSVerifier verifier() {
        return this.verifier;
    }

    public Either<Error, Jwt> readAndVerify(String jwt, String queryStringHash) {
        return this.read(jwt, queryStringHash, true);
    }

    private Either<Error, Jwt> read(String jwt, String queryStringHash, boolean shouldVerifySignature) {
        Either<Error, Jwt> either;
        Either<ParsingFailure, JWSObject> either2 = JwtParser$.MODULE$.parseJWSObject(jwt);
        if (either2 instanceof Right) {
            Either<Error, Jwt> either3;
            Right right = (Right)either2;
            JWSObject jwsObject = (JWSObject)right.value();
            if (shouldVerifySignature) {
                Left left;
                Either<Error, JWSObject> either4 = this.verifySignature(jwsObject);
                if (either4 instanceof Right) {
                    left = this.verifyRest(jwsObject, queryStringHash);
                } else if (either4 instanceof Left) {
                    Left left2;
                    left = left2 = (Left)either4;
                } else {
                    throw new MatchError(either4);
                }
                either3 = left;
            } else {
                either3 = this.verifyRest(jwsObject, queryStringHash);
            }
            either = either3;
        } else if (either2 instanceof Left) {
            Either<Error, Jwt> either5;
            either = either5 = (Either<Error, Jwt>)either2;
        } else {
            throw new MatchError(either2);
        }
        return either;
    }

    private Either<Error, Jwt> verifyRest(JWSObject jwsObject, String queryStringHash) {
        Left left;
        Either<ParsingFailure, JWTClaimsSet> either = JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject());
        if (either instanceof Right) {
            Left left2;
            Right right = (Right)either;
            JWTClaimsSet claims = (JWTClaimsSet)right.value();
            Either<Error, JWTClaimsSet> either2 = this.verifyStandardClaims(claims);
            if (either2 instanceof Right) {
                Right right2;
                Either<Error, JWTClaimsSet> either3 = this.verifyQueryStringHash(claims, queryStringHash);
                if (either3 instanceof Right) {
                    right2 = package$.MODULE$.Right().apply((Object)new Jwt(jwsObject, claims));
                } else if (either3 instanceof Left) {
                    Left left3 = (Left)either3;
                    right2 = left3;
                } else {
                    throw new MatchError(either3);
                }
                left2 = right2;
            } else if (either2 instanceof Left) {
                Left left4;
                left2 = left4 = (Left)either2;
            } else {
                throw new MatchError(either2);
            }
            left = left2;
        } else if (either instanceof Left) {
            Left left5;
            left = left5 = (Left)either;
        } else {
            throw new MatchError(either);
        }
        return left;
    }

    private Either<Error, JWTClaimsSet> verifyStandardClaims(JWTClaimsSet claims) {
        return this.validateHasIssueTimeAndExpirationTime(claims).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            Instant now = Instant.now();
            return new Tuple2(x$1, (Object)now);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Instant now = (Instant)tuple2._2();
            Either either = this.validateExpirationTimeIsAfterNotBefore(claims).flatMap((Function1 & Serializable & scala.Serializable)_ -> this.validateNowIsAfterNotBefore(now, claims).flatMap((Function1 & Serializable & scala.Serializable)_2 -> this.validateNowIsBeforeExpirationTime(now, claims).map((Function1 & Serializable & scala.Serializable)_ -> claims)));
            return either;
        });
    }

    private Either<Error, JWTClaimsSet> validateHasIssueTimeAndExpirationTime(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getIssueTime()).isEmpty() || Option$.MODULE$.apply((Object)claims.getExpirationTime()).isEmpty() ? new Left((Object)new JwtInvalidClaimError("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.")) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateExpirationTimeIsAfterNotBefore(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && !claims.getExpirationTime().after(claims.getNotBeforeTime()) ? new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expiration time must be after the not-before time but exp=", " and nbf=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claims.getExpirationTime(), claims.getNotBeforeTime()})))) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateNowIsAfterNotBefore(Instant now, JWTClaimsSet claims) {
        Instant nowPlusLeeway = now.plusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && claims.getNotBeforeTime().toInstant().isAfter(nowPlusLeeway) ? new Left((Object)new JwtTooEarlyError(claims.getNotBeforeTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> validateNowIsBeforeExpirationTime(Instant now, JWTClaimsSet claims) {
        Instant nowMinusLeeway = now.minusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return claims.getExpirationTime().toInstant().isBefore(nowMinusLeeway) ? new Left((Object)new JwtExpiredError(claims.getExpirationTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> verifyQueryStringHash(JWTClaimsSet claims, String queryStringHash) {
        Right right;
        Option maybeExtractedQueryStringHash = Option$.MODULE$.apply(claims.getClaim(HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName()));
        Option option = maybeExtractedQueryStringHash;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object extractedQueryStringHash = some.value();
            String string = queryStringHash;
            Object object = extractedQueryStringHash;
            right = (string == null ? object != null : !string.equals(object)) ? new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to have value '", "' but instead it has the value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName(), queryStringHash, maybeExtractedQueryStringHash})))) : package$.MODULE$.Right().apply((Object)claims);
        } else if (None$.MODULE$.equals(option)) {
            right = package$.MODULE$.Right().apply((Object)claims);
        } else {
            throw new MatchError((Object)option);
        }
        return right;
    }

    private Either<Error, JWSObject> verifySignature(JWSObject jwsObject) {
        Left left;
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> jwsObject.verify(this.verifier()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean isValid = BoxesRunTime.unboxToBoolean((Object)success.value());
            left = isValid ? package$.MODULE$.Right().apply((Object)jwsObject) : new Left((Object)new JwtSignatureMismatchError(jwsObject.getParsedString()));
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            left = new Left((Object)new JwtSignatureMismatchError(exception.getMessage()));
        } else {
            throw new MatchError((Object)try_);
        }
        return left;
    }

    public JwtReader copy(String sharedSecret) {
        return new JwtReader(sharedSecret);
    }

    public String copy$default$1() {
        return this.sharedSecret();
    }

    public String productPrefix() {
        return "JwtReader";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.sharedSecret();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JwtReader;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JwtReader)) return false;
        boolean bl = true;
        if (!bl) return false;
        JwtReader jwtReader = (JwtReader)x$1;
        String string = this.sharedSecret();
        String string2 = jwtReader.sharedSecret();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!jwtReader.canEqual(this)) return false;
        return true;
    }

    public JwtReader(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        Product.$init$((Product)this);
        this.verifier = new MACVerifier(sharedSecret);
    }
}

