/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import io.toolsplus.atlassian.jwt.api.CanonicalHttpRequest;
import java.net.URLEncoder;
import java.security.MessageDigest;
import org.bouncycastle.util.encoders.Hex;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class HttpRequestCanonicalizer$ {
    public static HttpRequestCanonicalizer$ MODULE$;
    private final String QueryStringHashClaimName;
    private final String JwtParamName;
    private final char QueryParamsSeparator;
    private final String EncodedParamValueSeparator;
    private final char CanonicalRequestPartSeparator;

    static {
        new HttpRequestCanonicalizer$();
    }

    public String QueryStringHashClaimName() {
        return this.QueryStringHashClaimName;
    }

    private String JwtParamName() {
        return this.JwtParamName;
    }

    private char QueryParamsSeparator() {
        return this.QueryParamsSeparator;
    }

    private String EncodedParamValueSeparator() {
        return this.EncodedParamValueSeparator;
    }

    public char CanonicalRequestPartSeparator() {
        return this.CanonicalRequestPartSeparator;
    }

    public String canonicalize(CanonicalHttpRequest request) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeMethod(request), BoxesRunTime.boxToCharacter((char)this.CanonicalRequestPartSeparator())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeUri(request), BoxesRunTime.boxToCharacter((char)this.CanonicalRequestPartSeparator())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeQueryParameters(request)}));
    }

    public String computeCanonicalRequestHash(CanonicalHttpRequest request) {
        return this.computeSha256Hash(this.canonicalize(request));
    }

    private String computeSha256Hash(String hashInput) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashInputBytes = hashInput.getBytes();
        digest.update(hashInputBytes, 0, hashInputBytes.length);
        return new String(Hex.encode((byte[])digest.digest()));
    }

    public String canonicalizeMethod(CanonicalHttpRequest request) {
        return request.method().toUpperCase();
    }

    public String canonicalizeUri(CanonicalHttpRequest request) {
        String relativeRequestPath = request.relativePath();
        String pathWithoutTrailingSlash = relativeRequestPath.endsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(relativeRequestPath)).dropRight(1) : relativeRequestPath;
        String path = pathWithoutTrailingSlash.isEmpty() ? "/" : pathWithoutTrailingSlash;
        String separatorAsString = ((Object)BoxesRunTime.boxToCharacter((char)this.CanonicalRequestPartSeparator())).toString();
        String encodedPath = path.replaceAll(separatorAsString, this.percentEncode(separatorAsString));
        return encodedPath.startsWith("/") ? encodedPath : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encodedPath}));
    }

    public String canonicalizeQueryParameters(CanonicalHttpRequest request) {
        return ((TraversableOnce)((TraversableLike)request.parameterMap().$minus((Object)this.JwtParamName()).toSeq().sortBy((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            Seq values = (Seq)tuple2._2();
            String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MODULE$.percentEncode(key), MODULE$.percentEncode(values.mkString(","))}));
            return string;
        }, (Ordering)Ordering.String$.MODULE$)).map(((Function2 & java.io.Serializable & Serializable)(Function2 & java.io.Serializable & Serializable)(key, values) -> MODULE$.percentEncodePair((String)key, (Seq<String>)values)).tupled(), Seq$.MODULE$.canBuildFrom())).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.QueryParamsSeparator())).toString());
    }

    private String percentEncodePair(String key, Seq<String> values) {
        String encKey = this.percentEncode(key);
        String encVal = ((TraversableOnce)values.map((Function1 & java.io.Serializable & Serializable)value -> MODULE$.percentEncode((String)value), Seq$.MODULE$.canBuildFrom())).mkString(this.EncodedParamValueSeparator());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encKey, encVal}));
    }

    private String percentEncode(String value) {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private HttpRequestCanonicalizer$() {
        MODULE$ = this;
        this.QueryStringHashClaimName = "qsh";
        this.JwtParamName = "jwt";
        this.QueryParamsSeparator = (char)38;
        this.EncodedParamValueSeparator = ",";
        this.CanonicalRequestPartSeparator = (char)38;
    }
}

