/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.io.Serializable;
import net.minidev.json.JSONObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JwtParser$ {
    public static JwtParser$ MODULE$;
    private final String UnexpectedTypeMessagePrefix;
    private final Set<String> NumericClaimNames;

    static {
        new JwtParser$();
    }

    public final Either<ParsingFailure, Jwt> parse(String input) {
        return this.parseJWSObject(input).flatMap((Function1 & Serializable & scala.Serializable)jwsObject -> MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject()).map((Function1 & Serializable & scala.Serializable)claims -> new Jwt((JWSObject)jwsObject, (JWTClaimsSet)claims)));
    }

    public final Either<ParsingFailure, JWSObject> parseJWSObject(String input) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JWSObject.parse((String)input));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JWSObject jwsObject = (JWSObject)success.value();
            right = package$.MODULE$.Right().apply((Object)jwsObject);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ParsingFailure(exception.getMessage(), exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public final Either<ParsingFailure, JWTClaimsSet> parseJWTClaimsSet(JSONObject json) {
        Right right;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JWTClaimsSet.parse((JSONObject)json));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            JWTClaimsSet claims = (JWTClaimsSet)success.value();
            right = package$.MODULE$.Right().apply((Object)claims);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            right = package$.MODULE$.Left().apply((Object)new ParsingFailure(this.claimParsingFailureDetails(exception), exception));
        } else {
            throw new MatchError((Object)try_);
        }
        return right;
    }

    public final String claimParsingFailureDetails(Throwable exception) {
        String string;
        if (exception.getMessage().startsWith(this.UnexpectedTypeMessagePrefix())) {
            String claimName = exception.getMessage().replace(this.UnexpectedTypeMessagePrefix(), "").replaceAll("\"", "");
            string = this.NumericClaimNames().contains((Object)claimName) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to be numeric but it is a string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claimName})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Perhaps a claim is of the wrong type (e.g. expecting integer but found string): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()}));
        } else {
            string = exception.getMessage();
        }
        return string;
    }

    private String UnexpectedTypeMessagePrefix() {
        return this.UnexpectedTypeMessagePrefix;
    }

    private Set<String> NumericClaimNames() {
        return this.NumericClaimNames;
    }

    private JwtParser$() {
        MODULE$ = this;
        this.UnexpectedTypeMessagePrefix = "Unexpected type of JSON object member with key ";
        this.NumericClaimNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exp", "iat", "nbf"}));
    }
}

