/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Error;
import io.toolsplus.atlassian.jwt.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.JwtExpiredError;
import io.toolsplus.atlassian.jwt.JwtInvalidClaimError;
import io.toolsplus.atlassian.jwt.JwtParser$;
import io.toolsplus.atlassian.jwt.JwtReader$;
import io.toolsplus.atlassian.jwt.JwtReader$$anonfun$verifyStandardClaims$2$;
import io.toolsplus.atlassian.jwt.JwtReader$$anonfun$verifyStandardClaims$2$$anonfun$apply$1$;
import io.toolsplus.atlassian.jwt.JwtSignatureMismatchError;
import io.toolsplus.atlassian.jwt.JwtTooEarlyError;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.time.Instant;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001B\u0001\u0003\u0001.\u0011\u0011BS<u%\u0016\fG-\u001a:\u000b\u0005\r!\u0011a\u00016xi*\u0011QAB\u0001\nCRd\u0017m]:jC:T!a\u0002\u0005\u0002\u0013Q|w\u000e\\:qYV\u001c(\"A\u0005\u0002\u0005%|7\u0001A\n\u0005\u00011\u0011R\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBF\u0005\u0003/9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\rg\"\f'/\u001a3TK\u000e\u0014X\r^\u000b\u00027A\u0011Ad\b\b\u0003\u001buI!A\b\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=9A\u0001b\t\u0001\u0003\u0012\u0003\u0006IaG\u0001\u000eg\"\f'/\u001a3TK\u000e\u0014X\r\u001e\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u001aI\u0001\u00071\u0004C\u0004,\u0001\t\u0007IQ\u0002\u0017\u0002\u0011Y,'/\u001b4jKJ,\u0012!\f\t\u0003]Uj\u0011a\f\u0006\u0003aE\nAA[8tK*\u0011!gM\u0001\t]&l'-^:eg*\tA'A\u0002d_6L!AN\u0018\u0003\u0017);6KV3sS\u001aLWM\u001d\u0005\u0007q\u0001\u0001\u000bQB\u0017\u0002\u0013Y,'/\u001b4jKJ\u0004\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014!\u0004:fC\u0012\fe\u000e\u001a,fe&4\u0017\u0010F\u0002=\u001d>\u0003B!P#I\u0017:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\u0011s\u0011a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013a!R5uQ\u0016\u0014(B\u0001#\u000f!\tA\u0013*\u0003\u0002K\u0005\t)QI\u001d:peB\u0011\u0001\u0006T\u0005\u0003\u001b\n\u00111AS<u\u0011\u0015\u0019\u0011\b1\u0001\u001c\u0011\u0015\u0001\u0016\b1\u0001\u001c\u0003=\tX/\u001a:z'R\u0014\u0018N\\4ICND\u0007\"\u0002*\u0001\t\u0013\u0019\u0016\u0001\u0002:fC\u0012$B\u0001\u0010+V-\")1!\u0015a\u00017!)\u0001+\u0015a\u00017!)q+\u0015a\u00011\u0006)2\u000f[8vY\u00124VM]5gsNKwM\\1ukJ,\u0007CA\u0007Z\u0013\tQfBA\u0004C_>dW-\u00198\t\u000bq\u0003A\u0011B/\u0002\u0015Y,'/\u001b4z%\u0016\u001cH\u000fF\u0002==\u000eDQaX.A\u0002\u0001\f\u0011B[<t\u001f\nTWm\u0019;\u0011\u00059\n\u0017B\u000120\u0005%QukU(cU\u0016\u001cG\u000fC\u0003Q7\u0002\u00071\u0004C\u0003f\u0001\u0011%a-\u0001\u000bwKJLg-_*uC:$\u0017M\u001d3DY\u0006LWn\u001d\u000b\u0003O6\u0004B!P#IQB\u0011\u0011n[\u0007\u0002U*\u00111!M\u0005\u0003Y*\u0014ABS,U\u00072\f\u0017.\\:TKRDQA\u001c3A\u0002!\faa\u00197bS6\u001c\b\"\u00029\u0001\t\u0013\t\u0018!\n<bY&$\u0017\r^3ICNL5o];f)&lW-\u00118e\u000bb\u0004\u0018N]1uS>tG+[7f)\t9'\u000fC\u0003o_\u0002\u0007\u0001\u000eC\u0003u\u0001\u0011%Q/\u0001\u0014wC2LG-\u0019;f\u000bb\u0004\u0018N]1uS>tG+[7f\u0013N\fe\r^3s\u001d>$()\u001a4pe\u0016$\"a\u001a<\t\u000b9\u001c\b\u0019\u00015\t\u000ba\u0004A\u0011B=\u00027Y\fG.\u001b3bi\u0016tun^%t\u0003\u001a$XM\u001d(pi\n+gm\u001c:f)\u00119'0!\u0003\t\u000bm<\b\u0019\u0001?\u0002\u00079|w\u000fE\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011\u0001\u0002;j[\u0016T!!a\u0001\u0002\t)\fg/Y\u0005\u0004\u0003\u000fq(aB%ogR\fg\u000e\u001e\u0005\u0006]^\u0004\r\u0001\u001b\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0003\u00052\u0018\r\\5eCR,gj\\<Jg\n+gm\u001c:f\u000bb\u0004\u0018N]1uS>tG+[7f)\u00159\u0017\u0011CA\n\u0011\u0019Y\u00181\u0002a\u0001y\"1a.a\u0003A\u0002!Dq!a\u0006\u0001\t\u0013\tI\"A\u000bwKJLg-_)vKJL8\u000b\u001e:j]\u001eD\u0015m\u001d5\u0015\u000b\u001d\fY\"!\b\t\r9\f)\u00021\u0001i\u0011\u0019\u0001\u0016Q\u0003a\u00017!9\u0011\u0011\u0005\u0001\u0005\n\u0005\r\u0012a\u0004<fe&4\u0017pU5h]\u0006$XO]3\u0015\t\u0005\u0015\u0012q\u0005\t\u0005{\u0015C\u0005\r\u0003\u0004`\u0003?\u0001\r\u0001\u0019\u0005\n\u0003W\u0001\u0011\u0011!C\u0001\u0003[\tAaY8qsR\u0019q%a\f\t\u0011e\tI\u0003%AA\u0002mA\u0011\"a\r\u0001#\u0003%\t!!\u000e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u0007\u0016\u00047\u0005e2FAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0015c\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0013\u0002@\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u00055\u0003!!A\u0005B\u0005=\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002RA!\u00111KA-\u001b\t\t)F\u0003\u0003\u0002X\u0005\u0005\u0011\u0001\u00027b]\u001eL1\u0001IA+\u0011%\ti\u0006AA\u0001\n\u0003\ty&\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002bA\u0019Q\"a\u0019\n\u0007\u0005\u0015dBA\u0002J]RD\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011QNA:!\ri\u0011qN\u0005\u0004\u0003cr!aA!os\"Q\u0011QOA4\u0003\u0003\u0005\r!!\u0019\u0002\u0007a$\u0013\u0007C\u0005\u0002z\u0001\t\t\u0011\"\u0011\u0002|\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002~A1\u0011qPAC\u0003[j!!!!\u000b\u0007\u0005\re\"\u0001\u0006d_2dWm\u0019;j_:LA!a\"\u0002\u0002\nA\u0011\n^3sCR|'\u000fC\u0005\u0002\f\u0002\t\t\u0011\"\u0001\u0002\u000e\u0006A1-\u00198FcV\fG\u000eF\u0002Y\u0003\u001fC!\"!\u001e\u0002\n\u0006\u0005\t\u0019AA7\u0011%\t\u0019\nAA\u0001\n\u0003\n)*\u0001\u0005iCND7i\u001c3f)\t\t\t\u0007C\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u0006AAo\\*ue&tw\r\u0006\u0002\u0002R!I\u0011q\u0014\u0001\u0002\u0002\u0013\u0005\u0013\u0011U\u0001\u0007KF,\u0018\r\\:\u0015\u0007a\u000b\u0019\u000b\u0003\u0006\u0002v\u0005u\u0015\u0011!a\u0001\u0003[:q!a*\u0003\u0011\u0003\tI+A\u0005KoR\u0014V-\u00193feB\u0019\u0001&a+\u0007\r\u0005\u0011\u0001\u0012AAW'\u0011\tY\u000bD\u000b\t\u000f\u0015\nY\u000b\"\u0001\u00022R\u0011\u0011\u0011\u0016\u0005\u000b\u0003k\u000bYK1A\u0005\n\u0005}\u0013A\u0006+j[\u0016\u001cE.Y5n\u0019\u0016,w/Y=TK\u000e|g\u000eZ:\t\u0013\u0005e\u00161\u0016Q\u0001\n\u0005\u0005\u0014a\u0006+j[\u0016\u001cE.Y5n\u0019\u0016,w/Y=TK\u000e|g\u000eZ:!\u0011)\ti,a+\u0002\u0002\u0013\u0005\u0015qX\u0001\u0006CB\u0004H.\u001f\u000b\u0004O\u0005\u0005\u0007BB\r\u0002<\u0002\u00071\u0004\u0003\u0006\u0002F\u0006-\u0016\u0011!CA\u0003\u000f\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002J\u0006=\u0007\u0003B\u0007\u0002LnI1!!4\u000f\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011[Ab\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\u0002\u0004BCAk\u0003W\u000b\t\u0011\"\u0003\u0002X\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\u000e\u0005\u0003\u0002T\u0005m\u0017\u0002BAo\u0003+\u0012aa\u00142kK\u000e$\b")
public class JwtReader
implements Product,
Serializable {
    private final String sharedSecret;
    private final JWSVerifier io$toolsplus$atlassian$jwt$JwtReader$$verifier;

    public static Option<String> unapply(JwtReader jwtReader) {
        return JwtReader$.MODULE$.unapply(jwtReader);
    }

    public static JwtReader apply(String string) {
        return JwtReader$.MODULE$.apply(string);
    }

    public String sharedSecret() {
        return this.sharedSecret;
    }

    public final JWSVerifier io$toolsplus$atlassian$jwt$JwtReader$$verifier() {
        return this.io$toolsplus$atlassian$jwt$JwtReader$$verifier;
    }

    public Either<Error, Jwt> readAndVerify(String jwt, String queryStringHash) {
        return this.read(jwt, queryStringHash, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, Jwt> read(String jwt, String queryStringHash, boolean shouldVerifySignature) {
        Either<ParsingFailure, JWSObject> either = JwtParser$.MODULE$.parseJWSObject(jwt);
        if (either instanceof Right) {
            Either<Error, Jwt> either2;
            Right right = (Right)either;
            JWSObject jwsObject = (JWSObject)right.b();
            if (shouldVerifySignature) {
                Left left;
                Either<Error, JWSObject> either3 = this.verifySignature(jwsObject);
                if (either3 instanceof Right) {
                    left = this.verifyRest(jwsObject, queryStringHash);
                } else {
                    Left left2;
                    if (!(either3 instanceof Left)) throw new MatchError(either3);
                    left = left2 = (Left)either3;
                }
                either2 = left;
                return either2;
            } else {
                either2 = this.verifyRest(jwsObject, queryStringHash);
            }
            return either2;
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Either<Error, Jwt> either4 = (Either<Error, Jwt>)either;
        return either4;
    }

    private Either<Error, Jwt> verifyRest(JWSObject jwsObject, String queryStringHash) {
        Either<ParsingFailure, JWTClaimsSet> either;
        block10: {
            Left left;
            block9: {
                Left left2;
                block2: {
                    Either<Error, JWTClaimsSet> either2;
                    block8: {
                        Left left3;
                        block7: {
                            Left left4;
                            block3: {
                                Either<Error, JWTClaimsSet> either3;
                                block6: {
                                    Left left5;
                                    block5: {
                                        Left left6;
                                        block4: {
                                            either = JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject());
                                            if (!(either instanceof Right)) break block2;
                                            Right right = (Right)either;
                                            JWTClaimsSet claims = (JWTClaimsSet)right.b();
                                            either2 = this.verifyStandardClaims(claims);
                                            if (!(either2 instanceof Right)) break block3;
                                            either3 = this.verifyQueryStringHash(claims, queryStringHash);
                                            if (!(either3 instanceof Right)) break block4;
                                            left5 = package$.MODULE$.Right().apply((Object)new Jwt(jwsObject, claims));
                                            break block5;
                                        }
                                        if (!(either3 instanceof Left)) break block6;
                                        left5 = left6 = (Left)either3;
                                    }
                                    left3 = left5;
                                    break block7;
                                }
                                throw new MatchError(either3);
                            }
                            if (!(either2 instanceof Left)) break block8;
                            left3 = left4 = (Left)either2;
                        }
                        left = left3;
                        break block9;
                    }
                    throw new MatchError(either2);
                }
                if (!(either instanceof Left)) break block10;
                left = left2 = (Left)either;
            }
            return left;
        }
        throw new MatchError(either);
    }

    private Either<Error, JWTClaimsSet> verifyStandardClaims(JWTClaimsSet claims) {
        return EitherOps$.MODULE$.flatMap$extension(package.either$.MODULE$.catsSyntaxEither(EitherOps$.MODULE$.map$extension(package.either$.MODULE$.catsSyntaxEither(this.validateHasIssueTimeAndExpirationTime(claims)), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<JWTClaimsSet, Instant> apply(JWTClaimsSet x$1) {
                Instant now = Instant.now();
                return new Tuple2((Object)x$1, (Object)now);
            }
        })), (Function1)new Serializable(this, claims){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JwtReader $outer;
            public final JWTClaimsSet claims$1;

            public final Either<Error, JWTClaimsSet> apply(Tuple2<JWTClaimsSet, Instant> x$2) {
                Tuple2<JWTClaimsSet, Instant> tuple2 = x$2;
                if (tuple2 != null) {
                    Instant now = (Instant)tuple2._2();
                    Either either = EitherOps$.MODULE$.flatMap$extension(package.either$.MODULE$.catsSyntaxEither(this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$validateExpirationTimeIsAfterNotBefore(this.claims$1)), (Function1)new Serializable(this, now){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$verifyStandardClaims$2 $outer;
                        public final Instant now$1;

                        public final Either<Error, JWTClaimsSet> apply(JWTClaimsSet _) {
                            return EitherOps$.MODULE$.flatMap$extension(package.either$.MODULE$.catsSyntaxEither(this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$$outer().io$toolsplus$atlassian$jwt$JwtReader$$validateNowIsAfterNotBefore(this.now$1, this.$outer.claims$1)), (Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$verifyStandardClaims$2$$anonfun$apply$1 $outer;

                                public final Either<Error, JWTClaimsSet> apply(JWTClaimsSet _) {
                                    return EitherOps$.MODULE$.map$extension(package.either$.MODULE$.catsSyntaxEither(this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$$outer().io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$$outer().io$toolsplus$atlassian$jwt$JwtReader$$validateNowIsBeforeExpirationTime(this.$outer.now$1, this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$$outer().claims$1)), (Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$verifyStandardClaims$2$$anonfun$apply$1$$anonfun$apply$2 $outer;

                                        public final JWTClaimsSet apply(JWTClaimsSet _) {
                                            return this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$anonfun$$$outer().io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$$outer().claims$1;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                }

                                public /* synthetic */ $anonfun$verifyStandardClaims$2$$anonfun$apply$1 io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$anonfun$$$outer() {
                                    return this.$outer;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                }
                            });
                        }

                        public /* synthetic */ $anonfun$verifyStandardClaims$2 io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.now$1 = now$1;
                        }
                    });
                    return either;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ JwtReader io$toolsplus$atlassian$jwt$JwtReader$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.claims$1 = claims$1;
            }
        });
    }

    private Either<Error, JWTClaimsSet> validateHasIssueTimeAndExpirationTime(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getIssueTime()).isEmpty() || Option$.MODULE$.apply((Object)claims.getExpirationTime()).isEmpty() ? new Left((Object)new JwtInvalidClaimError("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes.")) : package$.MODULE$.Right().apply((Object)claims);
    }

    public Either<Error, JWTClaimsSet> io$toolsplus$atlassian$jwt$JwtReader$$validateExpirationTimeIsAfterNotBefore(JWTClaimsSet claims) {
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && !claims.getExpirationTime().after(claims.getNotBeforeTime()) ? new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expiration time must be after the not-before time but exp=", " and nbf=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claims.getExpirationTime(), claims.getNotBeforeTime()})))) : package$.MODULE$.Right().apply((Object)claims);
    }

    public Either<Error, JWTClaimsSet> io$toolsplus$atlassian$jwt$JwtReader$$validateNowIsAfterNotBefore(Instant now, JWTClaimsSet claims) {
        Instant nowPlusLeeway = now.plusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return Option$.MODULE$.apply((Object)claims.getNotBeforeTime()).isDefined() && claims.getNotBeforeTime().toInstant().isAfter(nowPlusLeeway) ? new Left((Object)new JwtTooEarlyError(claims.getNotBeforeTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    public Either<Error, JWTClaimsSet> io$toolsplus$atlassian$jwt$JwtReader$$validateNowIsBeforeExpirationTime(Instant now, JWTClaimsSet claims) {
        Instant nowMinusLeeway = now.minusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds());
        return claims.getExpirationTime().toInstant().isBefore(nowMinusLeeway) ? new Left((Object)new JwtExpiredError(claims.getExpirationTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TimeClaimLeewaySeconds())) : package$.MODULE$.Right().apply((Object)claims);
    }

    private Either<Error, JWTClaimsSet> verifyQueryStringHash(JWTClaimsSet claims, String queryStringHash) {
        Option option;
        block4: {
            Right right;
            block3: {
                block2: {
                    Option maybeExtractedQueryStringHash = Option$.MODULE$.apply(claims.getClaim(HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName()));
                    option = maybeExtractedQueryStringHash;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object extractedQueryStringHash = some.x();
                    String string = queryStringHash;
                    Object object = extractedQueryStringHash;
                    right = !(string != null ? !string.equals(object) : object != null) ? package$.MODULE$.Right().apply((Object)claims) : new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to have value '", "' but instead it has the value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRequestCanonicalizer$.MODULE$.QueryStringHashClaimName(), queryStringHash, maybeExtractedQueryStringHash}))));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                right = package$.MODULE$.Right().apply((Object)claims);
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    private Either<Error, JWSObject> verifySignature(JWSObject jwsObject) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, jwsObject){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JwtReader $outer;
                        private final JWSObject jwsObject$1;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return this.jwsObject$1.verify(this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$verifier());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.jwsObject$1 = jwsObject$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    boolean isValid = BoxesRunTime.unboxToBoolean((Object)success.value());
                    left = isValid ? package$.MODULE$.Right().apply((Object)jwsObject) : new Left((Object)new JwtSignatureMismatchError(jwsObject.getParsedString()));
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = new Left((Object)new JwtSignatureMismatchError(exception.getMessage()));
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public JwtReader copy(String sharedSecret) {
        return new JwtReader(sharedSecret);
    }

    public String copy$default$1() {
        return this.sharedSecret();
    }

    public String productPrefix() {
        return "JwtReader";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.sharedSecret();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JwtReader;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JwtReader)) return false;
        boolean bl = true;
        if (!bl) return false;
        JwtReader jwtReader = (JwtReader)x$1;
        String string = this.sharedSecret();
        String string2 = jwtReader.sharedSecret();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!jwtReader.canEqual(this)) return false;
        return true;
    }

    public JwtReader(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        Product.class.$init$((Product)this);
        this.io$toolsplus$atlassian$jwt$JwtReader$$verifier = new MACVerifier(sharedSecret);
    }
}

