/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import cats.syntax.EitherOps$;
import cats.syntax.package;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import net.minidev.json.JSONObject;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JwtParser$ {
    public static final JwtParser$ MODULE$;
    private final String UnexpectedTypeMessagePrefix;
    private final Set<String> NumericClaimNames;

    static {
        new JwtParser$();
    }

    public final Either<ParsingFailure, Jwt> parse(String input) {
        return EitherOps$.MODULE$.flatMap$extension(package.either$.MODULE$.catsSyntaxEither(this.parseJWSObject(input)), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<ParsingFailure, Jwt> apply(JWSObject jwsObject) {
                return EitherOps$.MODULE$.map$extension(package.either$.MODULE$.catsSyntaxEither(JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject())), (Function1)new Serializable(this, jwsObject){
                    public static final long serialVersionUID = 0L;
                    private final JWSObject jwsObject$1;

                    public final Jwt apply(JWTClaimsSet claims) {
                        return new Jwt(this.jwsObject$1, claims);
                    }
                    {
                        this.jwsObject$1 = jwsObject$1;
                    }
                });
            }
        });
    }

    public final Either<ParsingFailure, JWSObject> parseJWSObject(String input) {
        Try try_;
        block4: {
            Right right;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(input){
                        public static final long serialVersionUID = 0L;
                        private final String input$1;

                        public final JWSObject apply() {
                            return JWSObject.parse((String)this.input$1);
                        }
                        {
                            this.input$1 = input$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    JWSObject jwsObject = (JWSObject)success.value();
                    right = package$.MODULE$.Right().apply((Object)jwsObject);
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                right = package$.MODULE$.Left().apply((Object)new ParsingFailure(exception.getMessage(), exception));
            }
            return right;
        }
        throw new MatchError((Object)try_);
    }

    public final Either<ParsingFailure, JWTClaimsSet> parseJWTClaimsSet(JSONObject json) {
        Try try_;
        block4: {
            Right right;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(json){
                        public static final long serialVersionUID = 0L;
                        private final JSONObject json$1;

                        public final JWTClaimsSet apply() {
                            return JWTClaimsSet.parse((JSONObject)this.json$1);
                        }
                        {
                            this.json$1 = json$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    JWTClaimsSet claims = (JWTClaimsSet)success.value();
                    right = package$.MODULE$.Right().apply((Object)claims);
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                right = package$.MODULE$.Left().apply((Object)new ParsingFailure(this.claimParsingFailureDetails(exception), exception));
            }
            return right;
        }
        throw new MatchError((Object)try_);
    }

    public final String claimParsingFailureDetails(Throwable exception) {
        String string;
        if (exception.getMessage().startsWith(this.UnexpectedTypeMessagePrefix())) {
            String claimName = exception.getMessage().replace(this.UnexpectedTypeMessagePrefix(), "").replaceAll("\"", "");
            string = this.NumericClaimNames().contains((Object)claimName) ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to be numeric but it is a string"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claimName})) : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Perhaps a claim is of the wrong type (e.g. expecting integer but found string): ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()}));
        } else {
            string = exception.getMessage();
        }
        return string;
    }

    private String UnexpectedTypeMessagePrefix() {
        return this.UnexpectedTypeMessagePrefix;
    }

    private Set<String> NumericClaimNames() {
        return this.NumericClaimNames;
    }

    private JwtParser$() {
        MODULE$ = this;
        this.UnexpectedTypeMessagePrefix = "Unexpected type of JSON object member with key ";
        this.NumericClaimNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exp", "iat", "nbf"}));
    }
}

