/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.jwt;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.jwt.Error;
import io.toolsplus.atlassian.jwt.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.jwt.Jwt;
import io.toolsplus.atlassian.jwt.JwtExpiredError;
import io.toolsplus.atlassian.jwt.JwtInvalidClaimError;
import io.toolsplus.atlassian.jwt.JwtParser$;
import io.toolsplus.atlassian.jwt.JwtReader$;
import io.toolsplus.atlassian.jwt.JwtSignatureMismatchError;
import io.toolsplus.atlassian.jwt.JwtTooEarlyError;
import io.toolsplus.atlassian.jwt.ParsingFailure;
import java.time.Instant;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00055f\u0001B\u0001\u0003\u0001.\u0011\u0011BS<u%\u0016\fG-\u001a:\u000b\u0005\r!\u0011a\u00016xi*\u0011QAB\u0001\nCRd\u0017m]:jC:T!a\u0002\u0005\u0002\u0013Q|w\u000e\\:qYV\u001c(\"A\u0005\u0002\u0005%|7\u0001A\n\u0005\u00011\u0011R\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBF\u0005\u0003/9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\rg\"\f'/\u001a3TK\u000e\u0014X\r^\u000b\u00027A\u0011Ad\b\b\u0003\u001buI!A\b\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=9A\u0001b\t\u0001\u0003\u0012\u0003\u0006IaG\u0001\u000eg\"\f'/\u001a3TK\u000e\u0014X\r\u001e\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u001aI\u0001\u00071\u0004C\u0004,\u0001\t\u0007IQ\u0002\u0017\u0002\u0011Y,'/\u001b4jKJ,\u0012!\f\t\u0003]Uj\u0011a\f\u0006\u0003aE\nAA[8tK*\u0011!gM\u0001\t]&l'-^:eg*\tA'A\u0002d_6L!AN\u0018\u0003\u0017);6KV3sS\u001aLWM\u001d\u0005\u0007q\u0001\u0001\u000bQB\u0017\u0002\u0013Y,'/\u001b4jKJ\u0004\u0003\"\u0002\u001e\u0001\t\u0003Y\u0014!\u0004:fC\u0012\fe\u000e\u001a,fe&4\u0017\u0010F\u0002=\u001d>\u0003B!P#I\u0017:\u0011ah\u0011\b\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005\u0011s\u0011a\u00029bG.\fw-Z\u0005\u0003\r\u001e\u0013a!R5uQ\u0016\u0014(B\u0001#\u000f!\tA\u0013*\u0003\u0002K\u0005\t)QI\u001d:peB\u0011\u0001\u0006T\u0005\u0003\u001b\n\u00111AS<u\u0011\u0015\u0019\u0011\b1\u0001\u001c\u0011\u0015\u0001\u0016\b1\u0001\u001c\u0003=\tX/\u001a:z'R\u0014\u0018N\\4ICND\u0007\"\u0002*\u0001\t\u0013\u0019\u0016\u0001\u0002:fC\u0012$B\u0001\u0010+V-\")1!\u0015a\u00017!)\u0001+\u0015a\u00017!)q+\u0015a\u00011\u0006)2\u000f[8vY\u00124VM]5gsNKwM\\1ukJ,\u0007CA\u0007Z\u0013\tQfBA\u0004C_>dW-\u00198\t\u000bq\u0003A\u0011B/\u0002\u0015Y,'/\u001b4z%\u0016\u001cH\u000fF\u0002==\u000eDQaX.A\u0002\u0001\f\u0011B[<t\u001f\nTWm\u0019;\u0011\u00059\n\u0017B\u000120\u0005%QukU(cU\u0016\u001cG\u000fC\u0003Q7\u0002\u00071\u0004C\u0003f\u0001\u0011%a-\u0001\u000bwKJLg-_*uC:$\u0017M\u001d3DY\u0006LWn\u001d\u000b\u0003O6\u0004B!P#IQB\u0011\u0011n[\u0007\u0002U*\u00111!M\u0005\u0003Y*\u0014ABS,U\u00072\f\u0017.\\:TKRDQA\u001c3A\u0002!\faa\u00197bS6\u001c\b\"\u00029\u0001\t\u0013\t\u0018!\u0006<fe&4\u00170U;fef\u001cFO]5oO\"\u000b7\u000f\u001b\u000b\u0004OJ\u001c\b\"\u00028p\u0001\u0004A\u0007\"\u0002)p\u0001\u0004Y\u0002\"B;\u0001\t\u00131\u0018a\u0004<fe&4\u0017pU5h]\u0006$XO]3\u0015\u0005]D\b\u0003B\u001fF\u0011\u0002DQa\u0018;A\u0002\u0001DqA\u001f\u0001\u0002\u0002\u0013\u000510\u0001\u0003d_BLHCA\u0014}\u0011\u001dI\u0012\u0010%AA\u0002mAqA \u0001\u0012\u0002\u0013\u0005q0\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005!fA\u000e\u0002\u0004-\u0012\u0011Q\u0001\t\u0005\u0003\u000f\t\t\"\u0004\u0002\u0002\n)!\u00111BA\u0007\u0003%)hn\u00195fG.,GMC\u0002\u0002\u00109\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019\"!\u0003\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002\u0018\u0001\t\t\u0011\"\u0011\u0002\u001a\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005!A.\u00198h\u0015\t\t)#\u0001\u0003kCZ\f\u0017b\u0001\u0011\u0002 !I\u00111\u0006\u0001\u0002\u0002\u0013\u0005\u0011QF\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003_\u00012!DA\u0019\u0013\r\t\u0019D\u0004\u0002\u0004\u0013:$\b\"CA\u001c\u0001\u0005\u0005I\u0011AA\u001d\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u000f\u0002BA\u0019Q\"!\u0010\n\u0007\u0005}bBA\u0002B]fD!\"a\u0011\u00026\u0005\u0005\t\u0019AA\u0018\u0003\rAH%\r\u0005\n\u0003\u000f\u0002\u0011\u0011!C!\u0003\u0013\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0017\u0002b!!\u0014\u0002T\u0005mRBAA(\u0015\r\t\tFD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA+\u0003\u001f\u0012\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u00033\u0002\u0011\u0011!C\u0001\u00037\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u00041\u0006u\u0003BCA\"\u0003/\n\t\u00111\u0001\u0002<!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011q\u0006\u0005\n\u0003O\u0002\u0011\u0011!C!\u0003S\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u00037A\u0011\"!\u001c\u0001\u0003\u0003%\t%a\u001c\u0002\r\u0015\fX/\u00197t)\rA\u0016\u0011\u000f\u0005\u000b\u0003\u0007\nY'!AA\u0002\u0005mraBA;\u0005!\u0005\u0011qO\u0001\n\u0015^$(+Z1eKJ\u00042\u0001KA=\r\u0019\t!\u0001#\u0001\u0002|M!\u0011\u0011\u0010\u0007\u0016\u0011\u001d)\u0013\u0011\u0010C\u0001\u0003\u007f\"\"!a\u001e\t\u0015\u0005\r\u0015\u0011\u0010b\u0001\n\u0013\ti#A\rU\u00136+ul\u0011'B\u00136{F*R#X\u0003f{6+R\"P\u001d\u0012\u001b\u0006\"CAD\u0003s\u0002\u000b\u0011BA\u0018\u0003i!\u0016*T#`\u00072\u000b\u0015*T0M\u000b\u0016;\u0016)W0T\u000b\u000e{e\nR*!\u0011)\tY)!\u001f\u0002\u0002\u0013\u0005\u0015QR\u0001\u0006CB\u0004H.\u001f\u000b\u0004O\u0005=\u0005BB\r\u0002\n\u0002\u00071\u0004\u0003\u0006\u0002\u0014\u0006e\u0014\u0011!CA\u0003+\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\u0018\u0006u\u0005\u0003B\u0007\u0002\u001anI1!a'\u000f\u0005\u0019y\u0005\u000f^5p]\"I\u0011qTAI\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\u0002\u0004BCAR\u0003s\n\t\u0011\"\u0003\u0002&\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\u000b\u0005\u0003\u0002\u001e\u0005%\u0016\u0002BAV\u0003?\u0011aa\u00142kK\u000e$\b")
public class JwtReader
implements Product,
Serializable {
    private final String sharedSecret;
    private final JWSVerifier io$toolsplus$atlassian$jwt$JwtReader$$verifier;

    public static Option<String> unapply(JwtReader jwtReader) {
        return JwtReader$.MODULE$.unapply(jwtReader);
    }

    public static JwtReader apply(String string) {
        return JwtReader$.MODULE$.apply(string);
    }

    public String sharedSecret() {
        return this.sharedSecret;
    }

    public final JWSVerifier io$toolsplus$atlassian$jwt$JwtReader$$verifier() {
        return this.io$toolsplus$atlassian$jwt$JwtReader$$verifier;
    }

    public Either<Error, Jwt> readAndVerify(String jwt, String queryStringHash) {
        return this.read(jwt, queryStringHash, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, Jwt> read(String jwt, String queryStringHash, boolean shouldVerifySignature) {
        Either<ParsingFailure, JWSObject> either = JwtParser$.MODULE$.parseJWSObject(jwt);
        if (either instanceof Right) {
            Either<Error, Jwt> either2;
            Right right = (Right)either;
            JWSObject jwsObject = (JWSObject)right.b();
            if (shouldVerifySignature) {
                Left left;
                Either<Error, JWSObject> either3 = this.verifySignature(jwsObject);
                if (either3 instanceof Right) {
                    left = this.verifyRest(jwsObject, queryStringHash);
                } else {
                    Left left2;
                    if (!(either3 instanceof Left)) throw new MatchError(either3);
                    left = left2 = (Left)either3;
                }
                either2 = left;
                return either2;
            } else {
                either2 = this.verifyRest(jwsObject, queryStringHash);
            }
            return either2;
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Either<Error, Jwt> either4 = (Either<Error, Jwt>)either;
        return either4;
    }

    private Either<Error, Jwt> verifyRest(JWSObject jwsObject, String queryStringHash) {
        Either<ParsingFailure, JWTClaimsSet> either;
        block10: {
            Left left;
            block9: {
                Left left2;
                block2: {
                    Either<Error, JWTClaimsSet> either2;
                    block8: {
                        Left left3;
                        block7: {
                            Left left4;
                            block3: {
                                Either<Error, JWTClaimsSet> either3;
                                block6: {
                                    Left left5;
                                    block5: {
                                        Left left6;
                                        block4: {
                                            either = JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject());
                                            if (!(either instanceof Right)) break block2;
                                            Right right = (Right)either;
                                            JWTClaimsSet claims = (JWTClaimsSet)right.b();
                                            either2 = this.verifyStandardClaims(claims);
                                            if (!(either2 instanceof Right)) break block3;
                                            either3 = this.verifyQueryStringHash(claims, queryStringHash);
                                            if (!(either3 instanceof Right)) break block4;
                                            left5 = package$.MODULE$.Right().apply((Object)new Jwt(jwsObject, claims));
                                            break block5;
                                        }
                                        if (!(either3 instanceof Left)) break block6;
                                        left5 = left6 = (Left)either3;
                                    }
                                    left3 = left5;
                                    break block7;
                                }
                                throw new MatchError(either3);
                            }
                            if (!(either2 instanceof Left)) break block8;
                            left3 = left4 = (Left)either2;
                        }
                        left = left3;
                        break block9;
                    }
                    throw new MatchError(either2);
                }
                if (!(either instanceof Left)) break block10;
                left = left2 = (Left)either;
            }
            return left;
        }
        throw new MatchError(either);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, JWTClaimsSet> verifyStandardClaims(JWTClaimsSet claims) {
        if (claims.getIssueTime() == null || claims.getExpirationTime() == null) {
            return new Left((Object)new JwtInvalidClaimError("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes."));
        }
        Instant now = Instant.now();
        Instant nowMinusLeeway = now.minusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS());
        Instant nowPlusLeeway = now.plusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS());
        if (claims.getNotBeforeTime() != null) {
            if (!claims.getExpirationTime().after(claims.getNotBeforeTime())) return new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expiration time must be after the not-before time but exp=", " and nbf=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claims.getExpirationTime(), claims.getNotBeforeTime()}))));
            if (claims.getNotBeforeTime().toInstant().isAfter(nowPlusLeeway)) {
                return new Left((Object)new JwtTooEarlyError(claims.getNotBeforeTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS()));
            }
        }
        if (!claims.getExpirationTime().toInstant().isBefore(nowMinusLeeway)) return package$.MODULE$.Right().apply((Object)claims);
        return new Left((Object)new JwtExpiredError(claims.getExpirationTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$jwt$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS()));
    }

    private Either<Error, JWTClaimsSet> verifyQueryStringHash(JWTClaimsSet claims, String queryStringHash) {
        Option option;
        block4: {
            Right right;
            block3: {
                block2: {
                    Option maybeExtractedQueryStringHash = Option$.MODULE$.apply(claims.getClaim(HttpRequestCanonicalizer$.MODULE$.QUERY_STRING_HASH_CLAIM_NAME()));
                    option = maybeExtractedQueryStringHash;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object extractedQueryStringHash = some.x();
                    String string = queryStringHash;
                    Object object = extractedQueryStringHash;
                    right = !(string != null ? !string.equals(object) : object != null) ? package$.MODULE$.Right().apply((Object)claims) : new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to have value '", "' but instead it has the value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRequestCanonicalizer$.MODULE$.QUERY_STRING_HASH_CLAIM_NAME(), queryStringHash, maybeExtractedQueryStringHash}))));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                right = package$.MODULE$.Right().apply((Object)claims);
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    private Either<Error, JWSObject> verifySignature(JWSObject jwsObject) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, jwsObject){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JwtReader $outer;
                        private final JWSObject jwsObject$1;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return this.jwsObject$1.verify(this.$outer.io$toolsplus$atlassian$jwt$JwtReader$$verifier());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.jwsObject$1 = jwsObject$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    boolean isValid = BoxesRunTime.unboxToBoolean((Object)success.value());
                    left = isValid ? package$.MODULE$.Right().apply((Object)jwsObject) : new Left((Object)new JwtSignatureMismatchError(jwsObject.getParsedString()));
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = new Left((Object)new JwtSignatureMismatchError(exception.getMessage()));
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public JwtReader copy(String sharedSecret) {
        return new JwtReader(sharedSecret);
    }

    public String copy$default$1() {
        return this.sharedSecret();
    }

    public String productPrefix() {
        return "JwtReader";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.sharedSecret();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JwtReader;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JwtReader)) return false;
        boolean bl = true;
        if (!bl) return false;
        JwtReader jwtReader = (JwtReader)x$1;
        String string = this.sharedSecret();
        String string2 = jwtReader.sharedSecret();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!jwtReader.canEqual(this)) return false;
        return true;
    }

    public JwtReader(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        Product.class.$init$((Product)this);
        this.io$toolsplus$atlassian$jwt$JwtReader$$verifier = new MACVerifier(sharedSecret);
    }
}

