/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.connect.jwt.scala;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import io.toolsplus.atlassian.connect.jwt.scala.Error;
import io.toolsplus.atlassian.connect.jwt.scala.HttpRequestCanonicalizer$;
import io.toolsplus.atlassian.connect.jwt.scala.Jwt;
import io.toolsplus.atlassian.connect.jwt.scala.JwtExpiredError;
import io.toolsplus.atlassian.connect.jwt.scala.JwtInvalidClaimError;
import io.toolsplus.atlassian.connect.jwt.scala.JwtParser$;
import io.toolsplus.atlassian.connect.jwt.scala.JwtReader$;
import io.toolsplus.atlassian.connect.jwt.scala.JwtSignatureMismatchError;
import io.toolsplus.atlassian.connect.jwt.scala.JwtTooEarlyError;
import io.toolsplus.atlassian.connect.jwt.scala.ParsingFailure;
import java.time.Instant;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001B\u0001\u0003\u0001>\u0011\u0011BS<u%\u0016\fG-\u001a:\u000b\u0005\r!\u0011!B:dC2\f'BA\u0003\u0007\u0003\rQw\u000f\u001e\u0006\u0003\u000f!\tqaY8o]\u0016\u001cGO\u0003\u0002\n\u0015\u0005I\u0011\r\u001e7bgNL\u0017M\u001c\u0006\u0003\u00171\t\u0011\u0002^8pYN\u0004H.^:\u000b\u00035\t!![8\u0004\u0001M!\u0001\u0001E\u000b\u0019!\t\t2#D\u0001\u0013\u0015\u0005\u0019\u0011B\u0001\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011CF\u0005\u0003/I\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u00123%\u0011!D\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t9\u0001\u0011)\u001a!C\u0001;\u0005a1\u000f[1sK\u0012\u001cVm\u0019:fiV\ta\u0004\u0005\u0002 E9\u0011\u0011\u0003I\u0005\u0003CI\ta\u0001\u0015:fI\u00164\u0017BA\u0012%\u0005\u0019\u0019FO]5oO*\u0011\u0011E\u0005\u0005\tM\u0001\u0011\t\u0012)A\u0005=\u0005i1\u000f[1sK\u0012\u001cVm\u0019:fi\u0002BQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtDC\u0001\u0016-!\tY\u0003!D\u0001\u0003\u0011\u0015ar\u00051\u0001\u001f\u0011\u001dq\u0003A1A\u0005\u000e=\n\u0001B^3sS\u001aLWM]\u000b\u0002aA\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\u0005U>\u001cXM\u0003\u00026m\u0005Aa.[7ckN$7OC\u00018\u0003\r\u0019w.\\\u0005\u0003sI\u00121BS,T-\u0016\u0014\u0018NZ5fe\"11\b\u0001Q\u0001\u000eA\n\u0011B^3sS\u001aLWM\u001d\u0011\t\u000bu\u0002A\u0011\u0001 \u0002\u001bI,\u0017\rZ!oIZ+'/\u001b4z)\ry\u0014K\u0015\t\u0005\u0001\"[eJ\u0004\u0002B\r:\u0011!)R\u0007\u0002\u0007*\u0011AID\u0001\u0007yI|w\u000e\u001e \n\u0003\rI!a\u0012\n\u0002\u000fA\f7m[1hK&\u0011\u0011J\u0013\u0002\u0007\u000b&$\b.\u001a:\u000b\u0005\u001d\u0013\u0002CA\u0016M\u0013\ti%AA\u0003FeJ|'\u000f\u0005\u0002,\u001f&\u0011\u0001K\u0001\u0002\u0004\u0015^$\b\"B\u0003=\u0001\u0004q\u0002\"B*=\u0001\u0004q\u0012aD9vKJL8\u000b\u001e:j]\u001eD\u0015m\u001d5\t\u000bU\u0003A\u0011\u0002,\u0002\tI,\u0017\r\u001a\u000b\u0005\u007f]C\u0016\fC\u0003\u0006)\u0002\u0007a\u0004C\u0003T)\u0002\u0007a\u0004C\u0003[)\u0002\u00071,A\u000btQ>,H\u000e\u001a,fe&4\u0017pU5h]\u0006$XO]3\u0011\u0005Ea\u0016BA/\u0013\u0005\u001d\u0011un\u001c7fC:DQa\u0018\u0001\u0005\n\u0001\f!B^3sS\u001aL(+Z:u)\ry\u0014M\u001a\u0005\u0006Ez\u0003\raY\u0001\nU^\u001cxJ\u00196fGR\u0004\"!\r3\n\u0005\u0015\u0014$!\u0003&X'>\u0013'.Z2u\u0011\u0015\u0019f\f1\u0001\u001f\u0011\u0015A\u0007\u0001\"\u0003j\u0003Q1XM]5gsN#\u0018M\u001c3be\u0012\u001cE.Y5ngR\u0011!\u000e\u001d\t\u0005\u0001\"[5\u000e\u0005\u0002m]6\tQN\u0003\u0002\u0006i%\u0011q.\u001c\u0002\r\u0015^#6\t\\1j[N\u001cV\r\u001e\u0005\u0006c\u001e\u0004\ra[\u0001\u0007G2\f\u0017.\\:\t\u000bM\u0004A\u0011\u0002;\u0002+Y,'/\u001b4z#V,'/_*ue&tw\rS1tQR\u0019!.\u001e<\t\u000bE\u0014\b\u0019A6\t\u000bM\u0013\b\u0019\u0001\u0010\t\u000ba\u0004A\u0011B=\u0002\u001fY,'/\u001b4z'&<g.\u0019;ve\u0016$\"A_>\u0011\t\u0001C5j\u0019\u0005\u0006E^\u0004\ra\u0019\u0005\b{\u0002\t\t\u0011\"\u0001\u007f\u0003\u0011\u0019w\u000e]=\u0015\u0005)z\bb\u0002\u000f}!\u0003\u0005\rA\b\u0005\n\u0003\u0007\u0001\u0011\u0013!C\u0001\u0003\u000b\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\b)\u001aa$!\u0003,\u0005\u0005-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0006\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\tyAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"!\b\u0001\u0003\u0003%\t%a\b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\u0003\u0005\u0003\u0002$\u00055RBAA\u0013\u0015\u0011\t9#!\u000b\u0002\t1\fgn\u001a\u0006\u0003\u0003W\tAA[1wC&\u00191%!\n\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0012\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u001b!\r\t\u0012qG\u0005\u0004\u0003s\u0011\"aA%oi\"I\u0011Q\b\u0001\u0002\u0002\u0013\u0005\u0011qH\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t%a\u0012\u0011\u0007E\t\u0019%C\u0002\u0002FI\u00111!\u00118z\u0011)\tI%a\u000f\u0002\u0002\u0003\u0007\u0011QG\u0001\u0004q\u0012\n\u0004\"CA'\u0001\u0005\u0005I\u0011IA(\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA)!\u0019\t\u0019&!\u0017\u0002B5\u0011\u0011Q\u000b\u0006\u0004\u0003/\u0012\u0012AC2pY2,7\r^5p]&!\u00111LA+\u0005!IE/\u001a:bi>\u0014\b\"CA0\u0001\u0005\u0005I\u0011AA1\u0003!\u0019\u0017M\\#rk\u0006dGcA.\u0002d!Q\u0011\u0011JA/\u0003\u0003\u0005\r!!\u0011\t\u0013\u0005\u001d\u0004!!A\u0005B\u0005%\u0014\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005U\u0002\"CA7\u0001\u0005\u0005I\u0011IA8\u0003!!xn\u0015;sS:<GCAA\u0011\u0011%\t\u0019\bAA\u0001\n\u0003\n)(\u0001\u0004fcV\fGn\u001d\u000b\u00047\u0006]\u0004BCA%\u0003c\n\t\u00111\u0001\u0002B\u001d9\u00111\u0010\u0002\t\u0002\u0005u\u0014!\u0003&xiJ+\u0017\rZ3s!\rY\u0013q\u0010\u0004\u0007\u0003\tA\t!!!\u0014\t\u0005}\u0004\u0003\u0007\u0005\bQ\u0005}D\u0011AAC)\t\ti\b\u0003\u0006\u0002\n\u0006}$\u0019!C\u0005\u0003g\t\u0011\u0004V%N\u000b~\u001bE*Q%N?2+UiV!Z?N+5i\u0014(E'\"I\u0011QRA@A\u0003%\u0011QG\u0001\u001b)&kUiX\"M\u0003&ku\fT#F/\u0006KvlU#D\u001f:#5\u000b\t\u0005\u000b\u0003#\u000by(!A\u0005\u0002\u0006M\u0015!B1qa2LHc\u0001\u0016\u0002\u0016\"1A$a$A\u0002yA!\"!'\u0002\u0000\u0005\u0005I\u0011QAN\u0003\u001d)h.\u00199qYf$B!!(\u0002$B!\u0011#a(\u001f\u0013\r\t\tK\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\u0005\u0015\u0016qSA\u0001\u0002\u0004Q\u0013a\u0001=%a!Q\u0011\u0011VA@\u0003\u0003%I!a+\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003[\u0003B!a\t\u00020&!\u0011\u0011WA\u0013\u0005\u0019y%M[3di\u0002")
public class JwtReader
implements Product,
Serializable {
    private final String sharedSecret;
    private final JWSVerifier io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$verifier;

    public static Option<String> unapply(JwtReader jwtReader) {
        return JwtReader$.MODULE$.unapply(jwtReader);
    }

    public static JwtReader apply(String string) {
        return JwtReader$.MODULE$.apply(string);
    }

    public String sharedSecret() {
        return this.sharedSecret;
    }

    public final JWSVerifier io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$verifier() {
        return this.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$verifier;
    }

    public Either<Error, Jwt> readAndVerify(String jwt, String queryStringHash) {
        return this.read(jwt, queryStringHash, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, Jwt> read(String jwt, String queryStringHash, boolean shouldVerifySignature) {
        Either<ParsingFailure, JWSObject> either = JwtParser$.MODULE$.parseJWSObject(jwt);
        if (either instanceof Right) {
            Either<Error, Jwt> either2;
            Right right = (Right)either;
            JWSObject jwsObject = (JWSObject)right.b();
            if (shouldVerifySignature) {
                Left left;
                Either<Error, JWSObject> either3 = this.verifySignature(jwsObject);
                if (either3 instanceof Right) {
                    left = this.verifyRest(jwsObject, queryStringHash);
                } else {
                    Left left2;
                    if (!(either3 instanceof Left)) throw new MatchError(either3);
                    left = left2 = (Left)either3;
                }
                either2 = left;
                return either2;
            } else {
                either2 = this.verifyRest(jwsObject, queryStringHash);
            }
            return either2;
        }
        if (!(either instanceof Left)) throw new MatchError(either);
        Either<Error, Jwt> either4 = (Either<Error, Jwt>)either;
        return either4;
    }

    private Either<Error, Jwt> verifyRest(JWSObject jwsObject, String queryStringHash) {
        Either<ParsingFailure, JWTClaimsSet> either;
        block10: {
            Left left;
            block9: {
                Left left2;
                block2: {
                    Either<Error, JWTClaimsSet> either2;
                    block8: {
                        Left left3;
                        block7: {
                            Left left4;
                            block3: {
                                Either<Error, JWTClaimsSet> either3;
                                block6: {
                                    Left left5;
                                    block5: {
                                        Left left6;
                                        block4: {
                                            either = JwtParser$.MODULE$.parseJWTClaimsSet(jwsObject.getPayload().toJSONObject());
                                            if (!(either instanceof Right)) break block2;
                                            Right right = (Right)either;
                                            JWTClaimsSet claims = (JWTClaimsSet)right.b();
                                            either2 = this.verifyStandardClaims(claims);
                                            if (!(either2 instanceof Right)) break block3;
                                            either3 = this.verifyQueryStringHash(claims, queryStringHash);
                                            if (!(either3 instanceof Right)) break block4;
                                            left5 = package$.MODULE$.Right().apply((Object)new Jwt(jwsObject, claims));
                                            break block5;
                                        }
                                        if (!(either3 instanceof Left)) break block6;
                                        left5 = left6 = (Left)either3;
                                    }
                                    left3 = left5;
                                    break block7;
                                }
                                throw new MatchError(either3);
                            }
                            if (!(either2 instanceof Left)) break block8;
                            left3 = left4 = (Left)either2;
                        }
                        left = left3;
                        break block9;
                    }
                    throw new MatchError(either2);
                }
                if (!(either instanceof Left)) break block10;
                left = left2 = (Left)either;
            }
            return left;
        }
        throw new MatchError(either);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Either<Error, JWTClaimsSet> verifyStandardClaims(JWTClaimsSet claims) {
        if (claims.getIssueTime() == null || claims.getExpirationTime() == null) {
            return new Left((Object)new JwtInvalidClaimError("'exp' and 'iat' are required claims. Atlassian JWT does not allow JWTs with unlimited lifetimes."));
        }
        Instant now = Instant.now();
        Instant nowMinusLeeway = now.minusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS());
        Instant nowPlusLeeway = now.plusSeconds(JwtReader$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS());
        if (claims.getNotBeforeTime() != null) {
            if (!claims.getExpirationTime().after(claims.getNotBeforeTime())) return new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The expiration time must be after the not-before time but exp=", " and nbf=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{claims.getExpirationTime(), claims.getNotBeforeTime()}))));
            if (claims.getNotBeforeTime().toInstant().isAfter(nowPlusLeeway)) {
                return new Left((Object)new JwtTooEarlyError(claims.getNotBeforeTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS()));
            }
        }
        if (!claims.getExpirationTime().toInstant().isBefore(nowMinusLeeway)) return package$.MODULE$.Right().apply((Object)claims);
        return new Left((Object)new JwtExpiredError(claims.getExpirationTime().toInstant(), now, JwtReader$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$TIME_CLAIM_LEEWAY_SECONDS()));
    }

    private Either<Error, JWTClaimsSet> verifyQueryStringHash(JWTClaimsSet claims, String queryStringHash) {
        Option option;
        block4: {
            Right right;
            block3: {
                block2: {
                    Option maybeExtractedQueryStringHash = Option$.MODULE$.apply(claims.getClaim(HttpRequestCanonicalizer$.MODULE$.QUERY_STRING_HASH_CLAIM_NAME()));
                    option = maybeExtractedQueryStringHash;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Object extractedQueryStringHash = some.x();
                    String string = queryStringHash;
                    Object object = extractedQueryStringHash;
                    right = !(string != null ? !string.equals(object) : object != null) ? package$.MODULE$.Right().apply((Object)claims) : new Left((Object)new JwtInvalidClaimError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Expecting claim '", "' to have value '", "' but instead it has the value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRequestCanonicalizer$.MODULE$.QUERY_STRING_HASH_CLAIM_NAME(), queryStringHash, maybeExtractedQueryStringHash}))));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                right = package$.MODULE$.Right().apply((Object)claims);
            }
            return right;
        }
        throw new MatchError((Object)option);
    }

    private Either<Error, JWSObject> verifySignature(JWSObject jwsObject) {
        Try try_;
        block4: {
            Left left;
            block3: {
                block2: {
                    try_ = Try$.MODULE$.apply((Function0)new Serializable(this, jwsObject){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ JwtReader $outer;
                        private final JWSObject jwsObject$1;

                        public final boolean apply() {
                            return this.apply$mcZ$sp();
                        }

                        public boolean apply$mcZ$sp() {
                            return this.jwsObject$1.verify(this.$outer.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$verifier());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.jwsObject$1 = jwsObject$1;
                        }
                    });
                    if (!(try_ instanceof Success)) break block2;
                    Success success = (Success)try_;
                    boolean isValid = BoxesRunTime.unboxToBoolean((Object)success.value());
                    left = isValid ? package$.MODULE$.Right().apply((Object)jwsObject) : new Left((Object)new JwtSignatureMismatchError(jwsObject.getParsedString()));
                    break block3;
                }
                if (!(try_ instanceof Failure)) break block4;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                left = new Left((Object)new JwtSignatureMismatchError(exception.getMessage()));
            }
            return left;
        }
        throw new MatchError((Object)try_);
    }

    public JwtReader copy(String sharedSecret) {
        return new JwtReader(sharedSecret);
    }

    public String copy$default$1() {
        return this.sharedSecret();
    }

    public String productPrefix() {
        return "JwtReader";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 0: 
        }
        return this.sharedSecret();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof JwtReader;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof JwtReader)) return false;
        boolean bl = true;
        if (!bl) return false;
        JwtReader jwtReader = (JwtReader)x$1;
        String string = this.sharedSecret();
        String string2 = jwtReader.sharedSecret();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!jwtReader.canEqual(this)) return false;
        return true;
    }

    public JwtReader(String sharedSecret) {
        this.sharedSecret = sharedSecret;
        Product.class.$init$((Product)this);
        this.io$toolsplus$atlassian$connect$jwt$scala$JwtReader$$verifier = new MACVerifier(sharedSecret);
    }
}

