/*
 * Decompiled with CFR 0.152.
 */
package io.toolsplus.atlassian.connect.jwt.scala;

import io.toolsplus.atlassian.connect.jwt.scala.api.CanonicalHttpRequest;
import java.net.URLEncoder;
import java.security.MessageDigest;
import org.bouncycastle.util.encoders.Hex;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class HttpRequestCanonicalizer$ {
    public static final HttpRequestCanonicalizer$ MODULE$;
    private final String QUERY_STRING_HASH_CLAIM_NAME;
    private final String JWT_PARAM_NAME;
    private final char QUERY_PARAMS_SEPARATOR;
    private final String ENCODED_PARAM_VALUE_SEPARATOR;
    private final char CANONICAL_REQUEST_PART_SEPARATOR;

    static {
        new HttpRequestCanonicalizer$();
    }

    public String QUERY_STRING_HASH_CLAIM_NAME() {
        return this.QUERY_STRING_HASH_CLAIM_NAME;
    }

    private String JWT_PARAM_NAME() {
        return this.JWT_PARAM_NAME;
    }

    private char QUERY_PARAMS_SEPARATOR() {
        return this.QUERY_PARAMS_SEPARATOR;
    }

    private String ENCODED_PARAM_VALUE_SEPARATOR() {
        return this.ENCODED_PARAM_VALUE_SEPARATOR;
    }

    public char CANONICAL_REQUEST_PART_SEPARATOR() {
        return this.CANONICAL_REQUEST_PART_SEPARATOR;
    }

    public String canonicalize(CanonicalHttpRequest request) {
        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeMethod(request), BoxesRunTime.boxToCharacter((char)this.CANONICAL_REQUEST_PART_SEPARATOR())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeUri(request), BoxesRunTime.boxToCharacter((char)this.CANONICAL_REQUEST_PART_SEPARATOR())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.canonicalizeQueryParameters(request)}))).toString();
    }

    public String computeCanonicalRequestHash(CanonicalHttpRequest request) {
        return this.computeSha256Hash(this.canonicalize(request));
    }

    private String computeSha256Hash(String hashInput) {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hashInputBytes = hashInput.getBytes();
        digest.update(hashInputBytes, 0, hashInputBytes.length);
        return new String(Hex.encode((byte[])digest.digest()));
    }

    public String canonicalizeMethod(CanonicalHttpRequest request) {
        return request.method().toUpperCase();
    }

    public String canonicalizeUri(CanonicalHttpRequest request) {
        String relativeRequestPath = request.relativePath();
        String pathWithoutTrailingSlash = relativeRequestPath.endsWith("/") ? (String)new StringOps(Predef$.MODULE$.augmentString(relativeRequestPath)).dropRight(1) : relativeRequestPath;
        String path = pathWithoutTrailingSlash.isEmpty() ? "/" : pathWithoutTrailingSlash;
        String separatorAsString = ((Object)BoxesRunTime.boxToCharacter((char)this.CANONICAL_REQUEST_PART_SEPARATOR())).toString();
        String encodedPath = path.replaceAll(separatorAsString, this.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(separatorAsString));
        return encodedPath.startsWith("/") ? encodedPath : new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encodedPath}));
    }

    public String canonicalizeQueryParameters(CanonicalHttpRequest request) {
        return ((TraversableOnce)((TraversableLike)request.parameterMap().$minus((Object)this.JWT_PARAM_NAME()).toSeq().sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Seq<String>> x0$1) {
                Tuple2<String, Seq<String>> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Seq values = (Seq)tuple2._2();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{HttpRequestCanonicalizer$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(key), HttpRequestCanonicalizer$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(values.mkString(","))}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, (Ordering)Ordering.String$.MODULE$)).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String key, Seq<String> values) {
                return HttpRequestCanonicalizer$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncodePair(key, values);
            }
        }.tupled(), Seq$.MODULE$.canBuildFrom())).mkString(((Object)BoxesRunTime.boxToCharacter((char)this.QUERY_PARAMS_SEPARATOR())).toString());
    }

    public String io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncodePair(String key, Seq<String> values) {
        String encKey = this.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(key);
        String encVal = ((TraversableOnce)values.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String value) {
                return HttpRequestCanonicalizer$.MODULE$.io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(value);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(this.ENCODED_PARAM_VALUE_SEPARATOR());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{encKey, encVal}));
    }

    public String io$toolsplus$atlassian$connect$jwt$scala$HttpRequestCanonicalizer$$percentEncode(String value) {
        return URLEncoder.encode(value, "UTF-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
    }

    private HttpRequestCanonicalizer$() {
        MODULE$ = this;
        this.QUERY_STRING_HASH_CLAIM_NAME = "qsh";
        this.JWT_PARAM_NAME = "jwt";
        this.QUERY_PARAMS_SEPARATOR = (char)38;
        this.ENCODED_PARAM_VALUE_SEPARATOR = ",";
        this.CANONICAL_REQUEST_PART_SEPARATOR = (char)38;
    }
}

