/*
 * Decompiled with CFR 0.152.
 */
package io.timson.firehose.stream;

import io.timson.firehose.request.CreateDeliveryStreamRequest;
import io.timson.firehose.stream.DeliveryStream;
import io.timson.firehose.stream.DeliveryStreamFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DeliveryStreamService {
    private final Map<String, DeliveryStream> deliveryStreams = new HashMap<String, DeliveryStream>();
    private final DeliveryStreamFactory deliveryStreamFactory;

    public DeliveryStreamService(DeliveryStreamFactory deliveryStreamFactory) {
        this.deliveryStreamFactory = deliveryStreamFactory;
    }

    public void write(String deliveryStream, String data) {
        DeliveryStream stream = this.getDeliveryStream(deliveryStream);
        stream.write(data);
    }

    public void createStream(CreateDeliveryStreamRequest createStreamRequest) {
        String name = createStreamRequest.getName();
        if (this.deliveryStreams.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Stream with name %s already exists", name));
        }
        DeliveryStream deliveryStream = this.deliveryStreamFactory.fromRequest(createStreamRequest);
        this.deliveryStreams.put(name, deliveryStream);
    }

    public void deleteStream(String name) {
        if (!this.deliveryStreams.containsKey(name)) {
            throw new IllegalArgumentException(String.format("Stream with name %s does not exists", name));
        }
        DeliveryStream deliveryStream = this.getDeliveryStream(name);
        deliveryStream.stop();
        this.deliveryStreams.remove(name);
    }

    public Set<String> listStreams() {
        return this.deliveryStreams.keySet();
    }

    private DeliveryStream getDeliveryStream(String name) {
        DeliveryStream stream = this.deliveryStreams.get(name);
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Unknown delivery stream %s", name));
        }
        return stream;
    }
}

